/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ValueSpecificationOperations
extends NamedElementOperations {
    protected ValueSpecificationOperations() {
    }

    public static boolean isComputable(ValueSpecification valueSpecification) {
        return false;
    }

    public static int integerValue(ValueSpecification valueSpecification) {
        throw new UnsupportedOperationException();
    }

    public static boolean booleanValue(ValueSpecification valueSpecification) {
        throw new UnsupportedOperationException();
    }

    public static String stringValue(ValueSpecification valueSpecification) {
        return null;
    }

    public static int unlimitedValue(ValueSpecification valueSpecification) {
        throw new UnsupportedOperationException();
    }

    public static boolean isNull(ValueSpecification valueSpecification) {
        return false;
    }

    public static double realValue(ValueSpecification valueSpecification) {
        throw new UnsupportedOperationException();
    }

    public static boolean isCompatibleWith(ValueSpecification valueSpecification, ParameterableElement p) {
        if (valueSpecification.eClass().isInstance((Object)p)) {
            Type type = valueSpecification.getType();
            return type == null ? ((ValueSpecification)p).eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false) == null : type.conformsTo(((ValueSpecification)p).getType());
        }
        return false;
    }

    protected static void setValue(ValueSpecification valueSpecification, final String newValue) {
        new UMLSwitch<Object>(){

            @Override
            public Object caseDuration(Duration duration) {
                ValueSpecification expr = duration.getExpr();
                return expr == null || expr instanceof Duration ? null : this.doSwitch((EObject)expr);
            }

            @Override
            public Object caseInstanceValue(InstanceValue instanceValue) {
                Type type = instanceValue.getType();
                if (!(type instanceof Enumeration)) {
                    ValueSpecification specification;
                    InstanceSpecification instance = instanceValue.getInstance();
                    if (instance != null && (specification = instance.getSpecification()) != null) {
                        return this.doSwitch((EObject)specification);
                    }
                    return null;
                }
                instanceValue.setInstance(((Enumeration)type).getOwnedLiteral(newValue));
                return instanceValue;
            }

            @Override
            public Object caseLiteralBoolean(LiteralBoolean literalBoolean) {
                literalBoolean.setValue(Boolean.valueOf(newValue));
                return literalBoolean;
            }

            @Override
            public Object caseLiteralInteger(LiteralInteger literalInteger) {
                literalInteger.setValue(Integer.parseInt(newValue));
                return literalInteger;
            }

            @Override
            public Object caseLiteralReal(LiteralReal literalReal) {
                literalReal.setValue(Double.parseDouble(newValue));
                return literalReal;
            }

            @Override
            public Object caseLiteralString(LiteralString literalString) {
                literalString.setValue(newValue);
                return literalString;
            }

            @Override
            public Object caseLiteralUnlimitedNatural(LiteralUnlimitedNatural literalUnlimitedNatural) {
                literalUnlimitedNatural.setValue(Integer.parseInt(newValue));
                return literalUnlimitedNatural;
            }

            @Override
            public Object caseOpaqueExpression(OpaqueExpression opaqueExpression) {
                EList<String> bodies = opaqueExpression.getBodies();
                if (bodies.isEmpty()) {
                    bodies.add((Object)newValue);
                } else {
                    bodies.set(0, (Object)newValue);
                }
                return opaqueExpression;
            }

            @Override
            public Object caseTimeExpression(TimeExpression timeExpression) {
                ValueSpecification expr = timeExpression.getExpr();
                return expr == null || expr instanceof TimeExpression ? null : this.doSwitch((EObject)expr);
            }

            @Override
            public Object defaultCase(EObject eObject) {
                throw new UnsupportedOperationException();
            }
        }.doSwitch((EObject)valueSpecification);
    }
}

