/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.validation;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.uml2.uml.UMLPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingConstraintDescriptor
extends AbstractConstraintDescriptor {
    private final String namespace;
    private final EClass target;
    private final String id;
    private final String name;

    DelegatingConstraintDescriptor(String namespace, EClass target, String name) {
        this.namespace = namespace;
        this.target = target;
        this.name = UMLPlugin.INSTANCE.getString("_UI_Validation_constraintName", new Object[]{target.getName(), name});
        StringBuilder buf = new StringBuilder();
        buf.append(namespace);
        buf.append('.').append(target.getEPackage().getName()).append('.').append(target.getName());
        buf.append('.').append(name);
        this.id = buf.toString();
        this.setEnabled(!EMFModelValidationPreferences.isConstraintDisabled((String)this.id));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.namespace;
    }

    public String getDescription() {
        return UMLPlugin.INSTANCE.getString("_UI_Validation_constraintDesc", new Object[]{this.getName()});
    }

    public ConstraintSeverity getSeverity() {
        return ConstraintSeverity.WARNING;
    }

    public int getStatusCode() {
        return 0;
    }

    public EvaluationMode<?> getEvaluationMode() {
        return EvaluationMode.BATCH;
    }

    public boolean targetsTypeOf(EObject eObject) {
        return this.target.isInstance((Object)eObject);
    }

    public boolean targetsEvent(Notification notification) {
        return false;
    }

    public String getMessagePattern() {
        return UMLPlugin.INSTANCE.getString("_UI_Validation_violation", new Object[]{this.getName()});
    }

    public String getBody() {
        return null;
    }

    EClass getTarget() {
        return this.target;
    }
}

