/*
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: UML2Article.java,v 1.2 2004/07/23 16:34:43 khussey Exp $
 */
package com.ibm.uml2.articles;

import java.io.IOException;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.util.UML2Resource;

/**
 *  
 */
public abstract class UML2Article {

	public static boolean DEBUG = true;

	protected static void out(String output) {

		if (DEBUG) {
			System.out.println(output);
		}
	}

	protected static void err(String error) {
		System.err.println(error);
	}

	protected static void registerResourceFactories() {
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(
			UML2Resource.FILE_EXTENSION, UML2Resource.Factory.INSTANCE);
	}

	protected static void save(org.eclipse.uml2.Package package_, URI uri) {
		Resource resource = new ResourceSetImpl().createResource(uri);
		resource.getContents().add(package_);

		try {
			resource.save(null);
			out("Done.");
		} catch (IOException ioe) {
			err(ioe.getMessage());
		}
	}

}