/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.SynchronizableGmfDiagramEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.contexts.IContextService;

public class UmlGmfDiagramEditor
extends SynchronizableGmfDiagramEditor
implements IInternationalizationEditor {
    private Diagram diagram;
    private PartNameSynchronizer partNameSynchronizer;
    private ServicesRegistry servicesRegistry;
    protected boolean viewerInitialized = false;
    protected Adapter diagramKindAdapter;

    public UmlGmfDiagramEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws ServiceException {
        super(true);
        this.diagram = diagram;
        this.servicesRegistry = servicesRegistry;
        this.partNameSynchronizer = new PartNameSynchronizer(diagram);
        LabelInternationalizationUtils.managePartLabelSynchronizer((EObject)diagram, (IInternationalizationEditor)this);
        ISaveAndDirtyService saveAndDirtyService = (ISaveAndDirtyService)servicesRegistry.getService(ISaveAndDirtyService.class);
        saveAndDirtyService.registerIsaveablePart((ISaveablePart)this);
        this.viewerInitialized = false;
        PapyrusDiagramStyle style = DiagramUtils.getPapyrusDiagramStyle((Diagram)diagram);
        this.diagramKindAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                UmlGmfDiagramEditor.this.getEditDomain().setPaletteRoot(UmlGmfDiagramEditor.this.createPaletteRoot(null));
                DiagramEditPart diagramEditPart = (DiagramEditPart)UmlGmfDiagramEditor.this.getAdapter(DiagramEditPart.class);
                if (diagramEditPart != null) {
                    UmlGmfDiagramEditor.this.getGraphicalViewer().setContents((EditPart)diagramEditPart);
                }
            }
        };
        if (style != null) {
            style.eAdapters().add((Object)this.diagramKindAdapter);
        }
    }

    public void setFocus() {
        if (!this.viewerInitialized) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    UmlGmfDiagramEditor.this.doInitializeGraphicalViewer();
                    UmlGmfDiagramEditor.this.viewerInitialized = true;
                }
            });
        }
        super.setFocus();
    }

    protected void doInitializeGraphicalViewer() {
        super.initializeGraphicalViewer();
    }

    protected void initializeGraphicalViewer() {
    }

    public void persistViewerSettings() {
        if (this.getDiagramEditPart() != null) {
            super.persistViewerSettings();
        }
    }

    public void dispose() {
        if (this.diagramKindAdapter != null) {
            PapyrusDiagramStyle style = DiagramUtils.getPapyrusDiagramStyle((Diagram)this.getDiagram());
            if (style != null) {
                style.eAdapters().remove((Object)this.diagramKindAdapter);
            }
            this.diagramKindAdapter = null;
        }
        this.setUndoContext(new IUndoContext(){

            public String getLabel() {
                return "Disposed undo context";
            }

            public boolean matches(IUndoContext context) {
                return false;
            }
        });
        super.dispose();
        try {
            ISaveAndDirtyService saveAndDirtyService = (ISaveAndDirtyService)this.servicesRegistry.getService(ISaveAndDirtyService.class);
            saveAndDirtyService.removeIsaveablePart((ISaveablePart)this);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.partNameSynchronizer = null;
        this.diagram = null;
        this.servicesRegistry = null;
    }

    public Object getAdapter(Class type) {
        if (type == ServicesRegistry.class) {
            return this.servicesRegistry;
        }
        return super.getAdapter(type);
    }

    protected void stopListening() {
        super.stopListening();
    }

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.partNameSynchronizer.setDiagram(diagram);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = new KeyHandler();
        return keyHandler;
    }

    public void createPartControl(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.eclipse.gmf.runtime.diagram.ui.diagramContext");
        super.createPartControl(parent);
    }

    public void modifyPartName(String name) {
        this.setPartName(name);
    }

    public void refreshEditorPart() {
        DiagramHelper.forceRefresh((DiagramEditPart)this.getDiagramEditPart());
    }

    public class PartNameSynchronizer {
        Diagram diagram;
        private Adapter diagramNameListener = new Adapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(Diagram.class) == 11 && notification.getNotifier() == PartNameSynchronizer.this.diagram) {
                    UmlGmfDiagramEditor.this.setPartName(LabelInternationalization.getInstance().getDiagramLabel(PartNameSynchronizer.this.diagram));
                } else if (notification.getFeature() == InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value() && notification.getNotifier() == PartNameSynchronizer.this.diagram) {
                    UmlGmfDiagramEditor.this.setPartName(LabelInternationalization.getInstance().getDiagramLabel(PartNameSynchronizer.this.diagram));
                }
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };

        PartNameSynchronizer(Diagram diagram) {
            this.setDiagram(diagram);
        }

        public void setDiagram(Diagram diagram) {
            if (this.diagram != null) {
                diagram.eAdapters().remove((Object)this.diagramNameListener);
            }
            this.diagram = diagram;
            UmlGmfDiagramEditor.this.setPartName(LabelInternationalization.getInstance().getDiagramLabel(diagram));
            diagram.eAdapters().add((Object)this.diagramNameListener);
        }
    }
}

