/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.handler;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.MigratorProfileApplicationDelegate;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.handler.ReapplyProfileCommand;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.service.ReapplyProfilesService;
import org.eclipse.papyrus.uml.profile.service.ui.RefreshProfileDialog;
import org.eclipse.papyrus.uml.profile.validation.ProfileValidationHelper;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileMigrationToolService
extends ReapplyProfilesService {
    public static boolean isUsingProfileMigrationTool = false;
    private ServicesRegistry servicesRegistry;
    private Package rootPackage;

    public void postInit(IMultiDiagramEditor editor) {
        super.postInit(editor);
    }

    public void postDisplay(IMultiDiagramEditor editor) {
        if (isUsingProfileMigrationTool) {
            this.ProfileMigration_checkProfiles(editor);
            isUsingProfileMigrationTool = false;
        } else {
            super.postDisplay(editor);
        }
    }

    public void beforeClose(IMultiDiagramEditor editor) {
        super.beforeClose(editor);
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        super.init(servicesRegistry);
        this.servicesRegistry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        super.startService();
    }

    public void disposeService() throws ServiceException {
        super.disposeService();
    }

    protected void ProfileMigration_checkProfiles(IMultiDiagramEditor editor) {
        ModelSet modelSet;
        try {
            modelSet = (ModelSet)this.servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            return;
        }
        UmlModel umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (umlModel == null) {
            return;
        }
        this.rootPackage = this.getRootPackage(umlModel);
        if (this.rootPackage == null) {
            return;
        }
        this.ProfileMigration_checkAndRefreshProfiles(this.rootPackage, editor);
    }

    protected boolean ProfileMigration_checkAndRefreshProfiles(Package currentPackage, IMultiDiagramEditor editor) {
        if (Display.getCurrent() == null) {
            return false;
        }
        MigratorProfileApplicationDelegate delegate = new MigratorProfileApplicationDelegate();
        for (ProfileApplication profileApplication : delegate.getProfileApplications(currentPackage)) {
            if (!ProfileUtil.isDirty((Package)currentPackage, (Profile)delegate.getAppliedProfile(profileApplication))) continue;
            RefreshProfileDialog dialog = new RefreshProfileDialog(editor.getSite().getShell(), this.rootPackage);
            dialog.setCallback(this.profileMigration_getCallback(dialog));
            dialog.open();
            return true;
        }
        for (Package nestedPackage : currentPackage.getNestedPackages()) {
            if (!this.ProfileMigration_checkAndRefreshProfiles(nestedPackage, editor)) continue;
            return true;
        }
        return false;
    }

    protected Runnable profileMigration_getCallback(final RefreshProfileDialog dialog) {
        return new Runnable(){

            @Override
            public void run() {
                Map profilesToReapply = dialog.getProfilesToReapply();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ProfileMigrationToolService.this.rootPackage);
                if (domain != null) {
                    LinkedList allProfiles = new LinkedList();
                    for (Collection profiles : profilesToReapply.values()) {
                        allProfiles.addAll(profiles);
                    }
                    if (ProfileValidationHelper.checkApplicableProfiles((Shell)Display.getCurrent().getActiveShell(), allProfiles)) {
                        CompoundCommand command = new CompoundCommand();
                        for (Map.Entry profiles : profilesToReapply.entrySet()) {
                            for (Profile profile : (Collection)profiles.getValue()) {
                                command.append((Command)new ReapplyProfileCommand((Package)profiles.getKey(), profile, domain));
                            }
                        }
                        domain.getCommandStack().execute((Command)command);
                    }
                } else {
                    Activator.log.error((Throwable)new IllegalArgumentException("Cannot reapply profiles on Package " + ProfileMigrationToolService.this.rootPackage.getQualifiedName() + ". The EditingDomain cannot be found"));
                }
            }
        };
    }
}

