/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.notify;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.papyrus.infra.tools.Activator;
import org.eclipse.papyrus.infra.tools.notify.IContext;
import org.eclipse.papyrus.infra.tools.notify.INotification;
import org.eclipse.papyrus.infra.tools.notify.INotificationBuilder;
import org.eclipse.papyrus.infra.tools.notify.LogNotification;
import org.eclipse.papyrus.infra.tools.notify.NotificationRunnable;
import org.eclipse.papyrus.infra.tools.notify.Type;
import org.eclipse.papyrus.infra.tools.spi.INotificationBuilderFactory;

public class NotificationBuilder
implements INotificationBuilder {
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    private static final int YES = 64;
    private static final int NO = 128;

    @Override
    public NotificationBuilder setMessage(String message) {
        this.parameters.put("message", message);
        return this;
    }

    @Override
    public NotificationBuilder setAsynchronous(boolean asynchronous) {
        this.parameters.put("asynchronous", asynchronous);
        return this;
    }

    @Override
    public NotificationBuilder addAction(NotificationRunnable runnable) {
        LinkedList<NotificationRunnable> runnables = (LinkedList<NotificationRunnable>)this.parameters.get("default_action");
        if (runnables == null) {
            runnables = new LinkedList<NotificationRunnable>();
            this.parameters.put("default_action", runnables);
        }
        runnables.add(runnable);
        return this;
    }

    @Override
    public NotificationBuilder setDelay(long delayMs) {
        this.parameters.put("delay", delayMs);
        return this;
    }

    @Override
    public NotificationBuilder setTemporary(boolean temporary) {
        this.parameters.put("temporary", temporary);
        return this;
    }

    @Override
    public NotificationBuilder setTitle(String title) {
        this.parameters.put("title", title);
        return this;
    }

    @Override
    public NotificationBuilder setHTML(boolean useHTML) {
        this.parameters.put("html", useHTML);
        return this;
    }

    @Override
    public NotificationBuilder setType(Type type) {
        this.parameters.put("type", (Object)type);
        return this;
    }

    @Override
    public NotificationBuilder setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public INotification run() {
        INotification result;
        INotificationBuilderFactory delegator = Activator.getDefault().getNotificationBuilderFactory();
        if (delegator != null) {
            INotificationBuilder delegate = delegator.createNotificationBuilder();
            this.parameters.forEach(delegate::setParameter);
            result = delegate.run();
        } else {
            result = new LogNotification((Type)((Object)this.parameters.get("type")), (String)this.parameters.get("message"));
        }
        return result;
    }

    public static NotificationBuilder createInformationBuilder() {
        NotificationBuilder builder = new NotificationBuilder();
        return builder;
    }

    public static NotificationBuilder createAsyncPopup(String text) {
        return new NotificationBuilder().setAsynchronous(true).setTemporary(true).setMessage(text).setDelay(2000L);
    }

    public static NotificationBuilder createAsyncPopup(String title, String text) {
        return new NotificationBuilder().setAsynchronous(true).setTemporary(true).setMessage(text).setTitle(title).setDelay(2000L);
    }

    public static NotificationBuilder createInfoPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setTemporary(false).setMessage(text).setType(Type.INFO);
    }

    public static NotificationBuilder createWarningPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setTemporary(false).setMessage(text).setType(Type.WARNING);
    }

    public static NotificationBuilder createQuestionPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setTemporary(false).setMessage(text).setType(Type.QUESTION);
    }

    public static NotificationBuilder createErrorPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setTemporary(false).setMessage(text).setType(Type.ERROR);
    }

    public static NotificationBuilder createYesNo(String message, final Runnable yes, final Runnable no) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(false).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                if (yes != null) {
                    context.put("action_id", 64);
                    yes.run();
                }
            }

            @Override
            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                if (no != null) {
                    context.put("action_id", 128);
                    no.run();
                }
            }

            @Override
            public String getLabel() {
                return "No";
            }
        });
    }

    public static NotificationBuilder createYesNo(String message) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(false).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                context.put("action_id", 64);
            }

            @Override
            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                context.put("action_id", 128);
            }

            @Override
            public String getLabel() {
                return "No";
            }
        });
    }

    public static NotificationBuilder createYesNo(String message, final NotificationRunnable yes, final NotificationRunnable no) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(false).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                if (yes != null) {
                    context.put("action_id", 64);
                    yes.run(context);
                }
            }

            @Override
            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            @Override
            public void run(IContext context) {
                if (no != null) {
                    context.put("action_id", 128);
                    no.run(context);
                }
            }

            @Override
            public String getLabel() {
                return "No";
            }
        });
    }
}

