/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.command.ErrorTransactionalCommand;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.provider.PasteNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractPasteEObjectInNattableCommandProvider
implements PasteNattableCommandProvider {
    protected static final String PASTE_ACTION_TASK_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteAction;
    protected static final String PASTE_ROWS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteRows;
    protected static final String PASTE_COMMAND_HAS_BEEN_CANCELLED = Messages.PasteEObjectAxisInTableCommandProvider_CommandCreationHasBeenCancelled;
    protected static final String PASTE_COMMAND_CANT_BE_EXECUTED = "The Paste command can't be executed";
    protected static final String PASTE_COMMAND_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteFromStringCommand;
    protected static final String CREATING_ELEMENT_A_NUMBER_X_Y = Messages.PasteEObjectAxisInTableCommandProvider_CreatingAnumberXonY;
    protected INattableModelManager tableManager;
    protected final Table table;
    protected final TransactionalEditingDomain tableEditingDomain;
    protected final TransactionalEditingDomain contextEditingDomain;
    protected final EObject tableContext;
    protected List<String> postActions;
    protected int factor;
    protected final int nbOperationsToDo;
    protected List<Object> secondAxis;
    protected boolean isDisposed = false;
    protected final Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters;
    protected boolean detachedMode;
    protected final boolean pasteColumn;
    protected final CSVPasteHelper pasteHelper;
    protected final Reader reader;
    protected final CSVParser parser;
    protected final int refreshEachReadChar = 1000;

    public AbstractPasteEObjectInNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, Reader reader, CSVPasteHelper pasteHelper, long totalSize) {
        this.tableManager = tableManager;
        this.pasteColumn = pasteColumn;
        this.existingConverters = new HashMap<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter>();
        this.table = tableManager.getTable();
        this.tableContext = this.table.getContext();
        this.tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(this.table);
        this.contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(this.table);
        this.reader = reader;
        this.pasteHelper = pasteHelper;
        this.parser = this.createParser();
        long div = -1L;
        if (totalSize > Integer.MAX_VALUE) {
            div = totalSize / Integer.MAX_VALUE;
            if (div > Integer.MAX_VALUE) {
                div *= 2L;
            }
            this.factor = (int)div;
            this.nbOperationsToDo = (int)(totalSize / div);
        } else {
            this.factor = 1;
            this.nbOperationsToDo = (int)totalSize;
        }
        this.init();
    }

    protected abstract CSVParser createParser();

    protected abstract void init();

    @Override
    public IStatus executePasteFromStringCommand(boolean useProgressMonitor, boolean openDialog) {
        IStatus resultStatus = Status.OK_STATUS;
        if (this.isDisposed) {
            throw new RuntimeException("The command provider is disposed");
        }
        String pasteJobName = PASTE_ROWS_JOB_NAME;
        if (this.detachedMode) {
            this.executePasteFromStringCommandInDetachedMode(useProgressMonitor, pasteJobName);
        } else {
            this.executePasteFromStringCommandInAttachedMode(useProgressMonitor, pasteJobName);
        }
        return resultStatus;
    }

    protected void executePasteFromStringCommandInDetachedMode(boolean useProgressMonitor, String pasteJobName) {
        final HashMap<Object, Object> sharedMap = new HashMap<Object, Object>();
        sharedMap.put("pastedElementContainer", this.tableContext);
        sharedMap.put("referencesToSet", new ArrayList());
        sharedMap.put("cellsToAdd", new ArrayList());
        sharedMap.put("additionnal_post_actions_to_conclude_paste", new ArrayList());
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInDetachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor(), sharedMap);
            try {
                try {
                    CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                    sharedMap.clear();
                    this.tableManager = null;
                }
            }
            finally {
                sharedMap.clear();
                this.tableManager = null;
            }
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = AbstractPasteEObjectInNattableCommandProvider.this.getPasteFromStringCommandInDetachedMode(AbstractPasteEObjectInNattableCommandProvider.this.contextEditingDomain, AbstractPasteEObjectInNattableCommandProvider.this.tableEditingDomain, monitor, sharedMap);
                    if (pasteCommand == null) {
                        AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            try {
                                int initialRowsSize = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
                                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                                int finalRowsSize = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
                                SelectionLayer selectionLayer = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getSelectionLayer();
                                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, initialRowsSize, false, false));
                                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, finalRowsSize, true, false));
                            }
                            catch (ExecutionException e) {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                                AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                                sharedMap.clear();
                                return status;
                            }
                        }
                        finally {
                            AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                            sharedMap.clear();
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                    sharedMap.clear();
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", AbstractPasteEObjectInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private ICommand getPasteFromStringCommandInDetachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor, Map<Object, Object> sharedMap) {
        if (this.pasteColumn) {
            return new UnexecutableCommand((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteEObjectTreeAxisInNatTableCommandProvider_CantPasteColumnsInTreeTable));
        }
        return this.getPasteRowFromStringInDetachedModeCommand(contextEditingDomain, tableEditingDomain, progressMonitor, sharedMap);
    }

    protected abstract ICommand getPasteRowFromStringInDetachedModeCommand(TransactionalEditingDomain var1, TransactionalEditingDomain var2, IProgressMonitor var3, Map<Object, Object> var4);

    protected void executePasteFromStringCommandInAttachedMode(boolean useProgressMonitor, String pasteJobName) {
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInAttachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor());
            try {
                try {
                    CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                    this.tableManager = null;
                }
            }
            finally {
                this.tableManager = null;
            }
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = AbstractPasteEObjectInNattableCommandProvider.this.getPasteFromStringCommandInAttachedMode(AbstractPasteEObjectInNattableCommandProvider.this.contextEditingDomain, AbstractPasteEObjectInNattableCommandProvider.this.tableEditingDomain, monitor);
                    if (pasteCommand == null) {
                        AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            try {
                                int initialRowsSize = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
                                EMFCommandOperation op = new EMFCommandOperation(AbstractPasteEObjectInNattableCommandProvider.this.contextEditingDomain, (Command)new GMFtoEMFCommandWrapper(pasteCommand));
                                CheckedOperationHistory.getInstance().execute((IUndoableOperation)op, monitor, null);
                                int finalRowsSize = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
                                SelectionLayer selectionLayer = AbstractPasteEObjectInNattableCommandProvider.this.tableManager.getBodyLayerStack().getSelectionLayer();
                                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, initialRowsSize, false, false));
                                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, finalRowsSize, true, false));
                            }
                            catch (Exception e) {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                                AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                                return status;
                            }
                        }
                        finally {
                            AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    AbstractPasteEObjectInNattableCommandProvider.this.tableManager = null;
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", AbstractPasteEObjectInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private ICommand getPasteFromStringCommandInAttachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor) {
        if (this.pasteColumn) {
            return new UnexecutableCommand((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteEObjectTreeAxisInNatTableCommandProvider_CantPasteColumnsInTreeTable));
        }
        return this.getPasteRowFromStringInAttachedModeCommand(contextEditingDomain, tableEditingDomain, progressMonitor);
    }

    protected abstract ICommand getPasteRowFromStringInAttachedModeCommand(TransactionalEditingDomain var1, TransactionalEditingDomain var2, IProgressMonitor var3);

    protected IStatus getStatusCommand(Command command) {
        ICommand gmfCommand;
        IStatus resultStatus = Status.OK_STATUS;
        if (command instanceof CompoundCommand) {
            Iterator subCommandIterator = ((CompoundCommand)command).getCommandList().iterator();
            while (subCommandIterator.hasNext() && resultStatus.isOK()) {
                IStatus subStatus;
                Command subCommand = (Command)subCommandIterator.next();
                if (!(command instanceof CompoundCommand) || (subStatus = this.getStatusCommand(subCommand)).isOK()) continue;
                resultStatus = subStatus;
            }
        } else if (command instanceof GMFtoEMFCommandWrapper && (gmfCommand = ((GMFtoEMFCommandWrapper)command).getGMFCommand()) instanceof ErrorTransactionalCommand) {
            resultStatus = ((ErrorTransactionalCommand)gmfCommand).getStatus();
        }
        return resultStatus;
    }

    protected Collection<String> getPostActions() {
        return this.postActions;
    }

    protected void localDispose() {
        this.isDisposed = true;
        for (AbstractStringValueConverter current : this.existingConverters.values()) {
            current.dispose();
        }
        this.existingConverters.clear();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

