/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationDelegateRegistry {
    private static final String EXT_POINT = "profileApplicationDelegates";
    private static final IProfileApplicationDelegate NULL_DELEGATE = new IProfileApplicationDelegate.Default(){

        @Override
        public boolean appliesTo(ProfileApplication profileApplication) {
            return false;
        }
    };
    public static final ProfileApplicationDelegateRegistry INSTANCE = new ProfileApplicationDelegateRegistry();
    private final List<IProfileApplicationDelegate> delegates = new ArrayList<IProfileApplicationDelegate>(2);
    private boolean needPrune;

    private ProfileApplicationDelegateRegistry() {
        new MyRegistryReader().readRegistry();
        this.delegates.add(new IProfileApplicationDelegate.Default());
    }

    private void prune() {
        if (this.needPrune) {
            this.needPrune = false;
            ListIterator<IProfileApplicationDelegate> iter = this.delegates.listIterator();
            while (iter.hasNext()) {
                MyRegistryReader.Descriptor desc;
                IProfileApplicationDelegate next = iter.next();
                if (next == NULL_DELEGATE) {
                    iter.remove();
                    continue;
                }
                if (!(next instanceof MyRegistryReader.Descriptor) || (desc = (MyRegistryReader.Descriptor)next).instance == null) continue;
                iter.set(desc.instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProfileApplicationDelegate getDelegate(Package package_) {
        IProfileApplicationDelegate result = NULL_DELEGATE;
        List<IProfileApplicationDelegate> list = this.delegates;
        synchronized (list) {
            this.prune();
            for (IProfileApplicationDelegate next : this.delegates) {
                if (!next.appliesTo(package_)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProfileApplicationDelegate getDelegate(ProfileApplication profileApplication) {
        IProfileApplicationDelegate result = NULL_DELEGATE;
        List<IProfileApplicationDelegate> list = this.delegates;
        synchronized (list) {
            this.prune();
            for (IProfileApplicationDelegate next : this.delegates) {
                if (!next.appliesTo(profileApplication)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProvider(String className) {
        List<IProfileApplicationDelegate> list = this.delegates;
        synchronized (list) {
            Iterator<IProfileApplicationDelegate> iter = this.delegates.iterator();
            while (iter.hasNext()) {
                IProfileApplicationDelegate next = iter.next();
                if (next instanceof MyRegistryReader.Descriptor) {
                    MyRegistryReader.Descriptor desc = (MyRegistryReader.Descriptor)next;
                    if (!className.equals(desc.getClassName())) continue;
                    iter.remove();
                    break;
                }
                if (!className.equals(next.getClass().getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    private class MyRegistryReader
    extends RegistryReader {
        private static final String A_CLASS = "class";
        private static final String E_DELEGATE = "delegate";
        private Descriptor currentDescriptor;

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.uml.tools", ProfileApplicationDelegateRegistry.EXT_POINT);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            return add ? this.handleAdd(element) : this.handleRemove(element);
        }

        private boolean handleAdd(IConfigurationElement element) {
            boolean result = false;
            if (E_DELEGATE.equals(element.getName())) {
                if (element.getAttribute(A_CLASS) == null) {
                    this.logMissingAttribute(element, A_CLASS);
                } else {
                    this.currentDescriptor = new Descriptor(element, A_CLASS);
                    ProfileApplicationDelegateRegistry.this.delegates.add(this.currentDescriptor);
                }
                result = true;
            }
            return result;
        }

        private boolean handleRemove(IConfigurationElement element) {
            boolean result = true;
            if (E_DELEGATE.equals(element.getName())) {
                String className = element.getAttribute(A_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, A_CLASS);
                    result = false;
                } else {
                    ProfileApplicationDelegateRegistry.this.removeProvider(className);
                }
            }
            return result;
        }

        private class Descriptor
        extends RegistryReader.PluginClassDescriptor
        implements IProfileApplicationDelegate {
            private IProfileApplicationDelegate instance;

            Descriptor(IConfigurationElement element, String attributeName) {
                super(element, attributeName);
            }

            String getClassName() {
                return this.element.getAttribute(this.attributeName);
            }

            IProfileApplicationDelegate getInstance() {
                if (this.instance == null) {
                    try {
                        this.instance = (IProfileApplicationDelegate)this.createInstance();
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to instantiate profile-application delegate extension.", (Throwable)e);
                        this.instance = NULL_DELEGATE;
                    }
                    ProfileApplicationDelegateRegistry.this.needPrune = true;
                }
                return this.instance;
            }

            @Override
            public boolean appliesTo(Package package_) {
                return this.getInstance().appliesTo(package_);
            }

            @Override
            public boolean appliesTo(ProfileApplication profileApplication) {
                return this.getInstance().appliesTo(profileApplication);
            }

            @Override
            public Iterable<ProfileApplication> getProfileApplications(Package package_) {
                return this.getInstance().getProfileApplications(package_);
            }

            @Override
            public ProfileApplication getProfileApplication(Package package_, Profile profile) {
                return this.getInstance().getProfileApplication(package_, profile);
            }

            @Override
            public EList<EObject> applyProfile(Package package_, Profile profile, Package context, IProgressMonitor monitor) {
                return this.getInstance().applyProfile(package_, profile, context, monitor);
            }

            @Override
            public Package getApplyingPackage(ProfileApplication profileApplication) {
                return this.getInstance().getApplyingPackage(profileApplication);
            }

            @Override
            public Profile getAppliedProfile(ProfileApplication profileApplication) {
                return this.getInstance().getAppliedProfile(profileApplication);
            }

            @Override
            public EList<EObject> reapplyProfile(Package package_, Profile profile, IProgressMonitor monitor) {
                return this.getInstance().reapplyProfile(package_, profile, monitor);
            }
        }
    }
}

