/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.sequence.RestoreExecutionEndAdvice;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ObservationLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDLifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeObservation;

public class SequenceDeleteHelper {
    public static CompoundCommand completeDeleteDestructionOccurenceViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart destructionEventPart) {
        LifelineEditPart lifelinePart;
        EObject obj;
        if (destructionEventPart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)destructionEventPart).resolveSemanticElement()) instanceof DestructionOccurrenceSpecification && (lifelinePart = SequenceUtil.getParentLifelinePart(destructionEventPart)) != null) {
            for (Object lifelineChild : lifelinePart.getChildren()) {
                IBorderItemEditPart timePart;
                boolean isNotLinked;
                if (!(lifelineChild instanceof IBorderItemEditPart) || (isNotLinked = OccurrenceSpecificationMoveHelper.canTimeElementPartBeYMoved(timePart = (IBorderItemEditPart)lifelineChild))) continue;
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
            DestructionOccurrenceSpecification dos = (DestructionOccurrenceSpecification)obj;
            if (dos.getMessage() != null) {
                SequenceDeleteHelper.destroyMessageEvent(deleteViewsCmd, dos.getMessage().getSendEvent(), editingDomain);
                DestroyElementRequest myReq = new DestroyElementRequest(editingDomain, (EObject)dos.getMessage(), false);
                deleteViewsCmd.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(myReq)));
            }
            deleteViewsCmd.add(((OLDLifelineEditPart)lifelinePart).getAlignLifelineBottomToParentCommand(null, true));
        }
        return deleteViewsCmd;
    }

    public static CompoundCommand completeDeleteMessageViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart messagePart) {
        EObject obj;
        if (messagePart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)messagePart).resolveSemanticElement()) instanceof Message) {
            Message message = (Message)obj;
            LifelineEditPart srcLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getSource());
            MessageEnd send = message.getSendEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, srcLifelinePart, send);
            LifelineEditPart tgtLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getTarget());
            MessageEnd receive = message.getReceiveEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, tgtLifelinePart, receive);
            if (send instanceof OccurrenceSpecification) {
                SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteViewsCmd, editingDomain, (OccurrenceSpecification)send, srcLifelinePart, false);
            }
            if (receive instanceof OccurrenceSpecification) {
                SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteViewsCmd, editingDomain, (OccurrenceSpecification)receive, tgtLifelinePart, false);
            }
        }
        return deleteViewsCmd;
    }

    private static void addDeleteRelatedTimePartsToCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, LifelineEditPart lifelineEP, MessageEnd messageEnd) {
        if (lifelineEP != null && messageEnd instanceof OccurrenceSpecification) {
            for (Object lifelineChild : lifelineEP.getChildren()) {
                IBorderItemEditPart timePart;
                int positionForEvent;
                if (!(lifelineChild instanceof IBorderItemEditPart) || (positionForEvent = SequenceUtil.positionWhereEventIsLinkedToPart((OccurrenceSpecification)messageEnd, timePart = (IBorderItemEditPart)lifelineChild)) == 0) continue;
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
        }
    }

    public static CompoundCommand completeDeleteExecutionSpecificationViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart executionPart) {
        EObject obj;
        if (executionPart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)executionPart).resolveSemanticElement()) instanceof ExecutionSpecification) {
            ExecutionSpecification execution = (ExecutionSpecification)obj;
            LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(executionPart);
            if (lifelinePart != null) {
                for (Object lifelineChild : lifelinePart.getChildren()) {
                    if (!(lifelineChild instanceof IBorderItemEditPart)) continue;
                    IBorderItemEditPart timePart = (IBorderItemEditPart)lifelineChild;
                    OccurrenceSpecification start = execution.getStart();
                    OccurrenceSpecification finish = execution.getStart();
                    int positionForStart = SequenceUtil.positionWhereEventIsLinkedToPart(start, timePart);
                    int positionForFinish = SequenceUtil.positionWhereEventIsLinkedToPart(finish, timePart);
                    if (positionForStart == 0 && positionForFinish == 0) continue;
                    ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                    deleteViewsCmd.add((Command)deleteTimeViewCommand);
                }
                for (Object targetConnection : lifelinePart.getTargetConnections()) {
                    if (!(targetConnection instanceof ObservationLinkEditPart)) continue;
                    ObservationLinkEditPart observationLinkEditPart = (ObservationLinkEditPart)((Object)targetConnection);
                    TimeObservationLabelEditPart source = (TimeObservationLabelEditPart)observationLinkEditPart.getSource();
                    OccurrenceSpecification start = execution.getStart();
                    OccurrenceSpecification finish = execution.getFinish();
                    int positionForStart = SequenceUtil.positionWhereEventIsLinkedToPart(start, source);
                    int positionForFinish = SequenceUtil.positionWhereEventIsLinkedToPart(finish, source);
                    if (positionForStart != 0) {
                        SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteViewsCmd, editingDomain, start, lifelinePart, false);
                    }
                    if (positionForFinish == 0) continue;
                    SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteViewsCmd, editingDomain, finish, lifelinePart, false);
                }
            }
        }
        return deleteViewsCmd;
    }

    public static void deleteView(CompositeTransactionalCommand cmd, List<Element> elements, TransactionalEditingDomain editingDomain) {
        for (Element element : elements) {
            SequenceDeleteHelper.deleteView(cmd, element, editingDomain);
        }
    }

    public static void deleteView(CompositeTransactionalCommand cmd, Element element, TransactionalEditingDomain editingDomain) {
        List views = DiagramEditPartsUtil.getEObjectViews((EObject)element);
        for (Object object : views) {
            if (!(object instanceof View)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)object));
        }
    }

    public static Command completeDeleteMessageCommand(DestroyElementRequest req, EditPart editPart) {
        ICommand deleteCommand;
        EObject selectedEObject = req.getElementToDestroy();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)selectedEObject);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
            CompoundCommand command = new CompoundCommand(deleteCommand.getLabel());
            command.add((Command)new ICommandProxy(deleteCommand));
            SequenceDeleteHelper.destroyMessageEvents(command, Arrays.asList(editPart), req.getEditingDomain());
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static void destroyExecutionOccurrenceSpecification(DestroyElementRequest req, CompoundCommand deleteElementsCommand, ShapeNodeEditPart host, ExecutionSpecification es) {
        DestroyElementRequest delStart = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getStart(), false);
        deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delStart)));
        DestroyElementRequest delEnd = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getFinish(), false);
        deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delEnd)));
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host, req.getEditingDomain());
        if (host.getParent() instanceof LifelineEditPart) {
            ArrayList<OccurrenceSpecification> oss = new ArrayList<OccurrenceSpecification>();
            oss.add(es.getStart());
            oss.add(es.getFinish());
            SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteElementsCommand, req.getEditingDomain(), (LifelineEditPart)host.getParent(), oss, true);
        }
        SequenceDeleteHelper.addDestroyExecutionSpecificationChildrenCommand(deleteElementsCommand, req.getEditingDomain(), host);
    }

    public static void destroyMessageEvents(CompoundCommand deleteElementsCommand, ShapeNodeEditPart host, TransactionalEditingDomain transactionalEditingDomain) {
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host.getSourceConnections(), transactionalEditingDomain);
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host.getTargetConnections(), transactionalEditingDomain);
    }

    static void destroyMessageEvents(CompoundCommand deleteElementsCommand, List<?> list, TransactionalEditingDomain transactionalEditingDomain) {
        for (Object o : list) {
            if (!(o instanceof ConnectionEditPart)) continue;
            ConnectionEditPart connectionEP = (ConnectionEditPart)o;
            EObject model = ((ConnectionEditPart)o).resolveSemanticElement();
            if (!(model instanceof Message)) continue;
            Message message = (Message)model;
            MessageEnd receiveEvent = message.getReceiveEvent();
            MessageEnd sendEvent = message.getSendEvent();
            SequenceDeleteHelper.destroyMessageEvent(deleteElementsCommand, sendEvent, transactionalEditingDomain);
            SequenceDeleteHelper.addDeleteMessageRelatedTimeObservationLinkCommand(transactionalEditingDomain, (EditPart)connectionEP, deleteElementsCommand, sendEvent, true);
            if (receiveEvent instanceof DestructionOccurrenceSpecification) continue;
            SequenceDeleteHelper.destroyMessageEvent(deleteElementsCommand, receiveEvent, transactionalEditingDomain);
            SequenceDeleteHelper.addDeleteMessageRelatedTimeObservationLinkCommand(transactionalEditingDomain, (EditPart)connectionEP, deleteElementsCommand, receiveEvent, true);
        }
    }

    static void destroyMessageEvent(CompoundCommand deleteElementsCommand, MessageEnd event, TransactionalEditingDomain transactionalEditingDomain) {
        if (event != null) {
            ICommand editCommand;
            DestroyElementRequest myReq = new DestroyElementRequest(transactionalEditingDomain, (EObject)event, false);
            RestoreExecutionEndAdvice provider = new RestoreExecutionEndAdvice();
            if (provider != null && (editCommand = provider.getAfterEditCommand((IEditCommandRequest)myReq)) != null && editCommand.canExecute()) {
                deleteElementsCommand.add((Command)new ICommandProxy(editCommand));
            }
            deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(myReq)));
        }
    }

    static void addDestroyExecutionSpecificationChildrenCommand(CompoundCommand deleteElementsCommand, TransactionalEditingDomain editingDomain, ShapeNodeEditPart part) {
        List<ShapeNodeEditPart> list = OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(part);
        for (ShapeNodeEditPart p : list) {
            EditCommandRequestWrapper request = new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(p.resolveSemanticElement(), false));
            deleteElementsCommand.add(p.getCommand((Request)request));
            SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, p.getSourceConnections(), editingDomain);
            SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, p.getTargetConnections(), editingDomain);
        }
    }

    static void addDeleteMessageRelatedTimeObservationLinkCommand(TransactionalEditingDomain editingDomain, EditPart editPart, CompoundCommand compoundCommand, MessageEnd messageEnd, boolean deleteRelatedEvent) {
        OccurrenceSpecification occurrenceSpecification;
        EList receiveCovereds;
        if (messageEnd != null && messageEnd instanceof OccurrenceSpecification && (receiveCovereds = (occurrenceSpecification = (OccurrenceSpecification)messageEnd).getCovereds()).size() > 0) {
            LifelineEditPart srcLifelinePart = (LifelineEditPart)SequenceUtil.getEditPart(editPart, (EObject)receiveCovereds.get(0), LifelineEditPart.class);
            SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(compoundCommand, editingDomain, occurrenceSpecification, srcLifelinePart, deleteRelatedEvent);
        }
    }

    private static void addDeleteRelatedTimeObservationLinkCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, OccurrenceSpecification os, LifelineEditPart srcLifelinePart, boolean deleteRelatedEvent) {
        ArrayList<OccurrenceSpecification> oss = new ArrayList<OccurrenceSpecification>();
        oss.add(os);
        SequenceDeleteHelper.addDeleteRelatedTimeObservationLinkCommand(deleteViewsCmd, editingDomain, srcLifelinePart, oss, deleteRelatedEvent);
    }

    public static void addDeleteRelatedTimeObservationLinkCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, LifelineEditPart srcLifelinePart, List<OccurrenceSpecification> oss, boolean deleteRelatedEvent) {
        List<TimeObservationLabelEditPart> timeObservationEditParts = SequenceUtil.findOccurenceSpecificationRelatedTimeObservationPart(srcLifelinePart, oss);
        for (final TimeObservationLabelEditPart timeObservationEditPart : timeObservationEditParts) {
            View view = (View)timeObservationEditPart.getModel();
            EList sourceEdges = view.getSourceEdges();
            for (Object sourceEdge : sourceEdges) {
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)sourceEdge));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
            if (!deleteRelatedEvent) continue;
            deleteViewsCmd.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "Remove TimeObservation related event", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    TimeObservation timeObservation = (TimeObservation)timeObservationEditPart.resolveSemanticElement();
                    timeObservation.setEvent(null);
                    return CommandResult.newOKCommandResult();
                }
            }));
        }
    }
}

