/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTreeTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeHierarchicalTableStyle
extends AbstractTreeTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (HandlerUtil.matchesRadioState((ExecutionEvent)event)) {
            return null;
        }
        String currentState = event.getParameter("org.eclipse.ui.commands.radioStateParameter");
        Table table = this.getTable();
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        SetCommand cmd = null;
        DisplayStyle value = DisplayStyle.get((String)currentState);
        if (style == null) {
            TableDisplayStyle displayStyle = NattablestyleFactory.eINSTANCE.createTableDisplayStyle();
            displayStyle.setDisplayStyle(value);
            cmd = new AddCommand((EditingDomain)this.getTableEditingDomain(), (EObject)table, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), Collections.singleton(displayStyle));
        } else {
            cmd = new SetCommand((EditingDomain)this.getTableEditingDomain(), (EObject)style, (EStructuralFeature)NattablestylePackage.eINSTANCE.getTableDisplayStyle_DisplayStyle(), (Object)value);
        }
        if (cmd != null && cmd.canExecute()) {
            this.getTableEditingDomain().getCommandStack().execute((org.eclipse.emf.common.command.Command)cmd);
            HandlerUtil.updateRadioState((Command)event.getCommand(), (String)currentState);
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled()) {
            DisplayStyle style = TableHelper.getTableDisplayStyle(this.getCurrentNattableModelManager());
            this.setBaseEnabled(DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)style) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)style));
        }
    }
}

