/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree.objects;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.DataTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.EnumerationValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.MetaclassValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ParentTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.PrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public abstract class ValueTreeObject
extends ParentTreeObject {
    protected Object value;
    protected AppliedStereotypePropertyTreeObject thePropertyTreeObjectParent;

    public AppliedStereotypePropertyTreeObject getThePropertyTreeObjectParent() {
        return this.thePropertyTreeObjectParent;
    }

    public ValueTreeObject(AppliedStereotypePropertyTreeObject parent, Object value) {
        super(parent);
        this.thePropertyTreeObjectParent = parent;
        this.value = value;
    }

    @Override
    protected void createChildren() {
    }

    public Object getValue() {
        return this.value;
    }

    public void moveMeUp(int index) {
        Object currentVal = ((AppliedStereotypePropertyTreeObject)this.getParent()).getValue();
        ArrayList<Object> tempValues = new ArrayList<Object>();
        if (currentVal instanceof EList) {
            EList currentValues = (EList)currentVal;
            int i = 0;
            while (i < currentValues.size()) {
                tempValues.add(currentValues.get(i));
                ++i;
            }
        } else {
            return;
        }
        if (index < 1 || index >= tempValues.size()) {
            return;
        }
        Object tmp = tempValues.get(index - 1);
        tempValues.set(index - 1, this.value);
        tempValues.set(index, tmp);
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.getParent();
        pTO.updateValue(tempValues);
        this.getParent().moveChildUp(this);
    }

    public void moveMeDown(int index) {
        Object currentVal = ((AppliedStereotypePropertyTreeObject)this.getParent()).getValue();
        ArrayList<Object> tempValues = new ArrayList<Object>();
        if (currentVal instanceof EList) {
            EList currentValues = (EList)currentVal;
            int i = 0;
            while (i < currentValues.size()) {
                tempValues.add(currentValues.get(i));
                ++i;
            }
        } else {
            return;
        }
        if (index == -1 || index >= tempValues.size() - 1) {
            return;
        }
        Object tmp = tempValues.get(index + 1);
        tempValues.set(index + 1, this.value);
        tempValues.set(index, tmp);
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.getParent();
        pTO.updateValue(tempValues);
        this.getParent().moveChildDown(this);
    }

    public static ValueTreeObject createInstance(AppliedStereotypePropertyTreeObject parent, Object newValue) {
        Property property = parent.getProperty();
        Type type = property.getType();
        ValueTreeObject newVTO = null;
        if (type instanceof PrimitiveType) {
            newVTO = PrimitiveTypeValueTreeObject.createInstance(parent, newValue);
        } else if (!(type instanceof Class) || type instanceof Stereotype || !property.isComposite()) {
            if (type instanceof Enumeration) {
                newVTO = new EnumerationValueTreeObject(parent, newValue);
            } else if (type instanceof DataType) {
                newVTO = new DataTypeValueTreeObject(parent, newValue);
            } else if (type instanceof Stereotype) {
                newVTO = new StereotypeValueTreeObject(parent, newValue);
            } else if (Util.isMetaclass(type)) {
                newVTO = new MetaclassValueTreeObject(parent, newValue);
            }
        }
        return newVTO;
    }

    public abstract void editMe();
}

