/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifeLineLayoutManager;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.swt.graphics.Color;

public class LifelineFigure
extends RoundedCompartmentFigure {
    protected RectangleFigure lifelineHeaderBoundsFigure;
    @Deprecated
    protected RectangleFigure fFigureExecutionsContainerFigure;
    @Deprecated
    protected LifelineDotLineCustomFigure fFigureLifelineDotLineFigure;

    public LifelineFigure() {
        this.setLayoutManager((LayoutManager)new LifeLineLayoutManager());
        this.setTransparency(100);
        this.createContents();
    }

    public void setTransparency(int transparency) {
        super.setTransparency(100);
    }

    public PointList getPolygonPoints() {
        PointList points = new PointList(8);
        points.addPoint(new Point(this.getBounds().x, this.getBounds().y));
        points.addPoint(new Point(this.getBounds().x + this.getBounds().width, this.getBounds().y));
        points.addPoint(new Point(this.getBounds().x + this.getBounds().width, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()));
        points.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()));
        points.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, this.getBounds().y + this.getBounds().height));
        points.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()));
        points.addPoint(new Point(this.getBounds().x, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()));
        points.addPoint(new Point(this.getBounds().x, this.getBounds().y));
        return points;
    }

    public void paint(Graphics graphics) {
        Rectangle rect = this.getBounds();
        graphics.pushState();
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineWidth(1);
        graphics.drawRectangle(rect.x, rect.y, rect.width - 1, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader() - rect.y);
        graphics.setLineDash(new int[]{5, 5});
        graphics.drawLine(new Point(rect.x + rect.width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()), new Point(rect.x + rect.width / 2, rect.y + rect.height - 1));
        graphics.popState();
        super.paint(graphics);
    }

    public LayoutManager getLayoutManager() {
        return new XYLayout();
    }

    public LayoutManager getLifeLineLayoutManager() {
        return super.getLayoutManager();
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        super.paintBackground(graphics, this.getFigureLifelineNameContainerFigure().getBounds());
    }

    protected IFigure getBorderedFigure() {
        return this.getFigureLifelineNameContainerFigure();
    }

    protected Border getDefaultBorder(Color borderColor) {
        int margin = this.getMapMode().DPtoLP(7);
        MarginBorder defaultBorder = new MarginBorder(margin, margin, margin, margin);
        return defaultBorder;
    }

    private void createContents() {
        this.lifelineHeaderBoundsFigure = new LifelineHeaderFigure();
        this.add((IFigure)this.lifelineHeaderBoundsFigure);
    }

    protected IMapMode getMapMode() {
        return MapModeUtil.getMapMode();
    }

    public WrappingLabel getFigureLifelineLabelFigure() {
        return this.getNameLabel();
    }

    @Deprecated
    public RectangleFigure getFigureLifelineNameContainerFigure() {
        return this.lifelineHeaderBoundsFigure;
    }

    @Deprecated
    public RectangleFigure getFigureExecutionsContainerFigure() {
        return this.fFigureExecutionsContainerFigure;
    }

    @Deprecated
    public LifelineDotLineCustomFigure getFigureLifelineDotLineFigure() {
        return this.fFigureLifelineDotLineFigure;
    }

    public final class LifelineHeaderFigure
    extends RectangleFigure {
        protected void fillShape(Graphics graphics) {
        }

        protected void outlineShape(Graphics graphics) {
        }
    }
}

