/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDGateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionFragmentsCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionHeadImpactLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDGateCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StereotypeInteractionFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.UMLPackage;

public class OldCustomInteractionEditPart
extends InteractionEditPart
implements IPapyrusEditPart {
    public static final int DEFAULT_MARGIN = 0;
    public static final String TOP_MARGIN_PROPERTY = "TopMarginLabel";
    public static final String LEFT_MARGIN_PROPERTY = "LeftMarginLabel";
    public static final String BOTTOM_MARGIN_PROPERTY = "BottomMarginLabel";
    public static final String RIGHT_MARGIN_PROPERTY = "RightMarginLabel";
    private NotificationHelper notifier = null;

    public OldCustomInteractionEditPart(View view) {
        super(view);
    }

    protected NotificationHelper getNotifier() {
        if (this.notifier == null) {
            try {
                Field f = InteractionEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifier = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifier = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        OldCustomInteractionEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifier;
    }

    public org.eclipse.gef.commands.Command getUpdateLifelinesHeightsCommand(org.eclipse.gef.commands.Command command) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof InteractionInteractionCompartmentEditPart)) continue;
            InteractionInteractionCompartmentEditPart childEditPart = (InteractionInteractionCompartmentEditPart)((Object)child);
            for (Object grandChild : childEditPart.getChildren()) {
                boolean cfr_ignored_0 = grandChild instanceof OLDLifelineEditPart;
            }
        }
        return command;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new InteractionGraphicalNodeEditPolicy());
        this.installEditPolicy("Gate Creation Edit Policy", (EditPolicy)new OLDGateCreationEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new InteractionFragmentsCreationEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableShapeEditPolicy(){

            protected org.eclipse.gef.commands.Command getResizeCommand(ChangeBoundsRequest request) {
                Rectangle newBounds = this.getInitialFeedbackBounds().getCopy();
                Dimension sizeDelta = request.getSizeDelta();
                newBounds.width += sizeDelta.width;
                newBounds.height += sizeDelta.height;
                Dimension minimumSize = OldCustomInteractionEditPart.this.getFigure().getMinimumSize();
                if (newBounds.width < minimumSize.width || newBounds.height < minimumSize.height) {
                    return UnexecutableCommand.INSTANCE;
                }
                org.eclipse.gef.commands.Command command = OldCustomInteractionEditPart.this.getUpdateLifelinesHeightsCommand(super.getResizeCommand(request));
                return command;
            }
        });
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("HeadImpactLayoutEditPolicy", (EditPolicy)new InteractionHeadImpactLayoutEditPolicy());
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new StereotypeInteractionFigure(){

            public Dimension getMinimumSize(int wHint, int hHint) {
                Rectangle bounds = new Rectangle();
                for (Object child : OldCustomInteractionEditPart.this.getChildren()) {
                    if (!(child instanceof InteractionInteractionCompartmentEditPart)) continue;
                    InteractionInteractionCompartmentEditPart childEditPart = (InteractionInteractionCompartmentEditPart)((Object)child);
                    for (Object grandChild : childEditPart.getChildren()) {
                        GraphicalEditPart editPart = (GraphicalEditPart)grandChild;
                        IFigure figure = editPart.getFigure();
                        if (grandChild instanceof OLDLifelineEditPart) {
                            Rectangle childBounds = figure.getBounds().getCopy();
                            bounds.union(childBounds);
                            continue;
                        }
                        bounds.union(figure.getBounds());
                    }
                    IFigure figure = childEditPart.getFigure();
                    Rectangle rectangle = figure.getBounds();
                    IFigure parentfigure = OldCustomInteractionEditPart.this.getFigure();
                    Rectangle parentRectangle = parentfigure.getBounds();
                    Dimension zoomedAddon = new Dimension(10, 16);
                    figure.translateToRelative((Translatable)zoomedAddon);
                    bounds.width += parentRectangle.width - rectangle.width + zoomedAddon.width;
                    bounds.height += parentRectangle.height - rectangle.height + zoomedAddon.height;
                    break;
                }
                return bounds.getSize();
            }
        };
        return this.primaryShape;
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            InteractionRectangleFigure irf;
            this.primaryShape.setBackgroundColor(color);
            if (this.primaryShape instanceof InteractionRectangleFigure && (irf = (InteractionRectangleFigure)this.primaryShape).getCompartmentFigure() != null) {
                irf.getCompartmentFigure().setForegroundColor(color);
            }
        }
    }

    protected void refreshFont() {
        super.refreshFont();
        this.refreshBounds();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabelMargin();
    }

    public void refreshLabelMargin() {
        IFigure figure = null;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        Object model = this.getModel();
        if (model instanceof View) {
            leftMargin = NotationUtils.getIntValue((View)((View)model), (String)LEFT_MARGIN_PROPERTY, (int)0);
            rightMargin = NotationUtils.getIntValue((View)((View)model), (String)RIGHT_MARGIN_PROPERTY, (int)0);
            topMargin = NotationUtils.getIntValue((View)((View)model), (String)TOP_MARGIN_PROPERTY, (int)0);
            bottomMargin = NotationUtils.getIntValue((View)((View)model), (String)BOTTOM_MARGIN_PROPERTY, (int)0);
        }
        if (this instanceof IPapyrusEditPart) {
            figure = this.getPrimaryShape();
            List labelChildFigureList = FigureUtils.findChildFigureInstances((IFigure)figure, IPapyrusWrappingLabel.class);
            for (IPapyrusWrappingLabel label : labelChildFigureList) {
                if (label == null) continue;
                label.setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            }
        }
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        NotificationHelper notifier = this.getNotifier();
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getInteraction_FormalGate().equals(feature)) {
            notifier.unlistenObject((Notifier)notification.getOldValue());
            notifier.listenObject((Notifier)notification.getNewValue());
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof Gate) {
            String newPrefix;
            String oldPrefix;
            Gate gate = (Gate)notification.getNotifier();
            String oldStringValue = notification.getOldStringValue();
            String newStringValue = notification.getNewStringValue();
            if (oldStringValue != null && newStringValue != null && !(oldPrefix = oldStringValue.split("_")[0]).equals(newPrefix = newStringValue.split("_")[0]) && (oldPrefix.equals(MessageDirection.IN.getName()) || oldPrefix.equals(MessageDirection.OUT.getName()))) {
                notifier.unlistenObject((Notifier)gate);
                gate.setName(String.valueOf(oldPrefix) + "_" + gate.getName());
                notifier.listenObject((Notifier)gate);
            }
        }
        super.handleNotificationEvent(notification);
        if (!notification.isTouch()) {
            this.synchronizeSize();
        }
    }

    protected void refreshBounds() {
        super.refreshBounds();
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OldCustomInteractionEditPart.this.synchronizeSize();
            }
        });
    }

    private void synchronizeSize() {
        LayoutConstraint c;
        View view = this.getNotationView();
        if (view instanceof Shape && (c = ((Shape)view).getLayoutConstraint()) instanceof Size) {
            org.eclipse.gef.commands.Command commandUpdateLifelines;
            final Size size = (Size)c;
            Dimension realSize = this.getFigure().getMinimumSize();
            final Dimension sizeDelta = new Dimension();
            if (size.getWidth() != -1 && realSize.width > size.getWidth()) {
                sizeDelta.width = realSize.width;
            }
            if (size.getHeight() != -1 && realSize.height > size.getHeight()) {
                sizeDelta.height = realSize.height;
            }
            if (sizeDelta.width != 0 || sizeDelta.height != 0) {
                AbstractCommand cmd = new AbstractCommand(){

                    public boolean canExecute() {
                        return true;
                    }

                    public boolean canUndo() {
                        return false;
                    }

                    public void execute() {
                        if (sizeDelta.width != 0) {
                            size.setWidth(sizeDelta.width);
                        }
                        if (sizeDelta.height != 0) {
                            size.setHeight(sizeDelta.height);
                        }
                    }

                    public void redo() {
                        this.execute();
                    }
                };
                CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)cmd, true);
            }
            if ((commandUpdateLifelines = this.getUpdateLifelinesHeightsCommand(null)) != null) {
                CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new GEFtoEMFCommandWrapper(commandUpdateLifelines), true);
            }
        }
    }

    public void activate() {
        super.activate();
        NotificationHelper notifier = this.getNotifier();
        Interaction interaction = (Interaction)this.resolveSemanticElement();
        if (interaction != null) {
            for (Gate formalGate : interaction.getFormalGates()) {
                notifier.listenObject((Notifier)formalGate);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
    }

    public void removeNotify() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.removeNotify();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor sourceAnchor = this.createAnchor(request, UMLElementTypes.Message_FoundEdge, "Message_FoundEdge", MessageFoundEditPart.class);
        if (sourceAnchor == null) {
            sourceAnchor = super.getSourceConnectionAnchor(request);
        }
        return sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof MessageFoundEditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, true)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor sourceConnectionAnchor = super.getSourceConnectionAnchor(connEditPart);
        return sourceConnectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ConnectionAnchor targetAnchor = this.createAnchor(request, UMLElementTypes.Message_LostEdge, "Message_LostEdge", MessageLostEditPart.class);
        if (targetAnchor == null) {
            targetAnchor = this.createAnchor(request, UMLElementTypes.Message_CreateEdge, "Message_CreateEdge", MessageCreateEditPart.class);
        }
        if (targetAnchor == null) {
            targetAnchor = super.getTargetConnectionAnchor(request);
        }
        return targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if ((connEditPart instanceof MessageLostEditPart || connEditPart instanceof MessageCreateEditPart) && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, false)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor targetConnectionAnchor = super.getTargetConnectionAnchor(connEditPart);
        return targetConnectionAnchor;
    }

    private ConnectionAnchor createAnchor(Request request, IElementType elementType, String visualId, Class<?> messageType) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!elementType.equals(obj)) continue;
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = createRequest.getConnectionViewDescriptor();
            if (connectionViewDescriptor != null && visualId.equals(connectionViewDescriptor.getSemanticHint())) {
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof ReconnectRequest && messageType.isInstance(connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) && request instanceof LocationRequest) {
            return this.createAnchor(((LocationRequest)request).getLocation().getCopy());
        }
        return null;
    }

    private ConnectionAnchor createAnchor(Point location) {
        return AnchorHelper.InnerPointAnchor.createAnchorAtLocation(this.getFigure(), new PrecisionPoint(location));
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof InteractionInteractionCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane(pane);
            pane.remove(((InteractionInteractionCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof OLDGateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((OLDGateEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    @Override
    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return super.getContentPaneFor(editPart);
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof OLDGateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().add(((OLDGateEditPart)childEditPart).getFigure(), (Object)new GateLocator((OLDGateEditPart)childEditPart, this.getFigure()));
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected NodeFigure createNodePlate() {
        return new RoundedRectangleNodePlateFigure(857, 757){

            protected ConnectionAnchor createAnchor(PrecisionPoint p) {
                if (p == null) {
                    return this.createDefaultAnchor();
                }
                return new AnchorHelper.IntersectionPointAnchor((IFigure)this, p);
            }
        };
    }
}

