/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.example.programmaticcreation;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLViewProvider;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateSequenceDiagramElementsCommand
extends AbstractEMFOperation {
    public static UMLViewProvider sequenceDiagViewProvider = new UMLViewProvider();
    protected ExecutionEvent m_event;
    protected Class m_context;

    public CreateSequenceDiagramElementsCommand(TransactionalEditingDomain domain, ExecutionEvent event, Class context) {
        super(domain, "add lifelines and message");
        this.m_context = context;
        this.m_event = event;
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject diagramEObj;
        Object windowsContainer = null;
        Object model = windowsContainer.getActiveSashWindowsPage().getRawModel();
        if (model instanceof PageRef && (diagramEObj = ((PageRef)model).getEmfPageIdentifier()) instanceof Diagram) {
            Diagram diagram = (Diagram)diagramEObj;
            View interactionView = null;
            for (Object child : diagram.getChildren()) {
                if (!(child instanceof View) || ((View)child).getElement() != this.m_context) continue;
                interactionView = (View)child;
            }
            Interaction interaction = (Interaction)this.m_context;
            Lifeline lifeline1 = interaction.createLifeline("TestLifeline1");
            Lifeline lifeline2 = interaction.createLifeline("TestLifeline2");
            MessageOccurrenceSpecification mosSrc = (MessageOccurrenceSpecification)interaction.createFragment("source", UMLPackage.eINSTANCE.getMessageOccurrenceSpecification());
            MessageOccurrenceSpecification mosDst = (MessageOccurrenceSpecification)interaction.createFragment("target", UMLPackage.eINSTANCE.getMessageOccurrenceSpecification());
            Message message = interaction.createMessage("from l1 to l2");
            mosSrc.setMessage(message);
            mosSrc.setCovered(lifeline1);
            mosDst.setMessage(message);
            mosDst.setCovered(lifeline2);
            message.setSendEvent((MessageEnd)mosSrc);
            message.setReceiveEvent((MessageEnd)mosDst);
            DurationConstraint durationConstraint = (DurationConstraint)interaction.createOwnedRule("constraint", UMLPackage.eINSTANCE.getDurationConstraint());
            View lifelineV1 = this.addLifeline(lifeline1, interactionView, 40, 40);
            View lifelineV2 = this.addLifeline(lifeline2, interactionView, 170, 40);
            this.addDurationConstraint(durationConstraint, interactionView, 250, 100);
            this.addMessage(message, diagram, lifelineV1, lifelineV2);
        }
        return Status.OK_STATUS;
    }

    public View addLifeline(Lifeline lifeline, View interactionView, int x, int y) {
        Object compartment = interactionView.getChildren().get(1);
        String nodeType = UMLVisualIDRegistry.getType((String)"Lifeline_Shape");
        Node lifelineView = ViewService.createNode((View)((View)compartment), (EObject)lifeline, (String)nodeType, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        Bounds location = NotationFactory.eINSTANCE.createBounds();
        location.setX(x);
        location.setY(y);
        if (lifelineView instanceof Node) {
            lifelineView.setLayoutConstraint((LayoutConstraint)location);
        }
        if (lifelineView instanceof Shape) {
            Shape lifelineShape = (Shape)lifelineView;
            lifelineShape.setLineWidth(2);
            lifelineShape.setLineColor(0xB0B0B0);
        }
        return lifelineView;
    }

    public View addDurationConstraint(DurationConstraint durationContraint, View interactionView, int x, int y) {
        Object compartment = interactionView.getChildren().get(1);
        Node lifelineView = sequenceDiagViewProvider.createDurationConstraint_Shape((EObject)durationContraint, (View)compartment, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        Bounds location = NotationFactory.eINSTANCE.createBounds();
        location.setX(x);
        location.setY(y);
        if (lifelineView instanceof Node) {
            lifelineView.setLayoutConstraint((LayoutConstraint)location);
        }
        return lifelineView;
    }

    public void addMessage(Message message, Diagram diagram, View lifelineSrcV, View lifelineDstV) {
        Edge messageView = sequenceDiagViewProvider.createMessage_AsynchEdge((EObject)message, (View)diagram, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        if (messageView instanceof Edge) {
            Edge messageEdge = messageView;
            messageEdge.setSource(lifelineSrcV);
            messageEdge.setTarget(lifelineDstV);
            IdentityAnchor sourceAnchor = (IdentityAnchor)messageEdge.createSourceAnchor(NotationPackage.eINSTANCE.getIdentityAnchor());
            IdentityAnchor targetAnchor = (IdentityAnchor)messageEdge.createSourceAnchor(NotationPackage.eINSTANCE.getIdentityAnchor());
            sourceAnchor.setId("(1.0,0.7){R}");
            targetAnchor.setId("(1.1,0.7){R}");
        }
    }
}

