/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internationalization.modelelements;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.commands.AddEAnnotationDetailCommand;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.commands.RemoveEAnnotationDetailCommand;
import org.eclipse.papyrus.infra.emf.commands.RemoveFromResourcecommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.internationalization.common.command.LocaleInternationalizationPreferenceCommand;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationAnnotationResourceUtils;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationPreferenceModel;
import org.eclipse.papyrus.infra.internationalization.ui.Activator;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationPreferenceModelUtils;

public class LanguageObservableValue
extends AbstractObservableValue<String>
implements IObserving {
    private EditingDomain domain;

    public LanguageObservableValue(EditingDomain domain) {
        this.domain = domain;
    }

    public Object getObserved() {
        InternationalizationPreferenceModel model = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
        return model.getPrivateResourceURI();
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        if (!InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            return "";
        }
        InternationalizationPreferenceModel model = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
        return InternationalizationPreferencesUtils.getLocalePreference((URI)model.getPrivateResourceURI()).toString();
    }

    protected void doSetValue(String value) {
        Command command = this.getSetCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    protected Command getSetCommand(String value) {
        TransactionalEditingDomain domainForResource;
        CompoundCommand compoundCommand;
        EAnnotation annotation;
        Resource resource;
        InternationalizationPreferenceModel model;
        boolean needCreateAnnotation;
        block11: {
            needCreateAnnotation = true;
            model = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
            resource = model.getResource();
            annotation = InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)resource);
            compoundCommand = new CompoundCommand("Create internationalization command");
            if (annotation != null) {
                if (annotation.getDetails().containsKey((Object)"language")) {
                    try {
                        domainForResource = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)resource);
                        compoundCommand.append((Command)new RemoveEAnnotationDetailCommand(domainForResource, annotation, "language"));
                        if (1 == annotation.getDetails().size()) {
                            compoundCommand.append((Command)new RemoveFromResourcecommand(domainForResource, resource, (EObject)annotation));
                            break block11;
                        }
                        needCreateAnnotation = false;
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                } else {
                    needCreateAnnotation = false;
                }
            }
        }
        if (value != null) {
            if (needCreateAnnotation) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Internationalization");
                annotation.getDetails().put((Object)"language", (Object)value);
                compoundCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AddToResourceCommand(((ModelSet)resource.getResourceSet()).getTransactionalEditingDomain(), resource, (EObject)annotation)));
            } else {
                try {
                    domainForResource = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)resource);
                    compoundCommand.append((Command)new AddEAnnotationDetailCommand(domainForResource, annotation, "language", value));
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            compoundCommand.append((Command)new LocaleInternationalizationPreferenceCommand(model.getPrivateResourceURI(), value));
        }
        return !compoundCommand.getCommandList().isEmpty() ? compoundCommand : UnexecutableCommand.INSTANCE;
    }
}

