/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class EMFInstanceOfConstraint
extends AbstractConstraint {
    private String className;
    private String nsUri;
    private EPackage metamodel;

    @Override
    protected void setDescriptor(SimpleConstraint descriptor) {
        this.className = this.getValue("className");
        this.nsUri = this.getValue("nsUri");
        this.metamodel = EPackage.Registry.INSTANCE.getEPackage(this.nsUri);
        if (this.metamodel == null) {
            Activator.log.warn("Metamodel with nsUri " + this.nsUri + " not found");
        }
    }

    @Override
    public boolean overrides(Constraint otherConstraint) {
        boolean result;
        if (!(otherConstraint instanceof EMFInstanceOfConstraint)) {
            return false;
        }
        EMFInstanceOfConstraint constraint = (EMFInstanceOfConstraint)otherConstraint;
        EClass thisClass = EMFHelper.getEClass((String)this.nsUri, (String)this.className);
        EClass otherClass = EMFHelper.getEClass((String)constraint.nsUri, (String)constraint.className);
        boolean bl = result = !this.equals(constraint) && EMFHelper.isSubclass((EClass)thisClass, (EClass)otherClass) && thisClass != otherClass;
        return result || super.overrides(constraint);
    }

    @Override
    public boolean match(Object selection) {
        if (this.className == null || this.nsUri == null) {
            return false;
        }
        EObject selectedItem = EMFHelper.getEObject((Object)selection);
        if (selectedItem != null) {
            if (this.metamodel == null) {
                return EMFHelper.isInstance((EObject)selectedItem, (String)this.className, (String)this.nsUri);
            }
            return EMFHelper.isInstance((EObject)selectedItem, (String)this.className, (EPackage)this.metamodel);
        }
        return false;
    }

    public String toString() {
        return "EMFInstanceOfConstraint (" + this.nsUri + "/" + this.className + ")";
    }

    @Override
    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof EMFInstanceOfConstraint)) {
            return false;
        }
        EMFInstanceOfConstraint other = (EMFInstanceOfConstraint)constraint;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.nsUri == null ? other.nsUri != null : !this.nsUri.equals(other.nsUri));
    }
}

