/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.uripattern;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPattern;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternComparison;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternMatchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileNamespaceURIPatternRegistry {
    public static final ProfileNamespaceURIPatternRegistry INSTANCE = new ProfileNamespaceURIPatternRegistry();
    private static final String EXTENSION_ID = "org.eclipse.papyrus.uml.modelrepair.profileNamespaceURIPattern";
    private static final String NAME = "profileNamespaceURIPattern";
    private static final String URI_PATTERN = "uriPattern";
    private static final String VERSION_FORMAT = "versionFormat";
    private List<ProfileNamespaceURIPattern> profileNamespaceURIPatterns = new ArrayList<ProfileNamespaceURIPattern>();

    private ProfileNamespaceURIPatternRegistry() {
        this.initFromExtensionPoints();
    }

    private void initFromExtensionPoints() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if (NAME.equals(element.getName())) {
                    ProfileNamespaceURIPattern pattern = this.processProfileNamespaceURIPattern(element);
                    this.register(pattern);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
    }

    private ProfileNamespaceURIPattern processProfileNamespaceURIPattern(IConfigurationElement element) {
        String uriPattern = element.getAttribute(URI_PATTERN);
        String versionFormat = element.getAttribute(VERSION_FORMAT);
        return new ProfileNamespaceURIPattern(uriPattern, versionFormat);
    }

    public List<ProfileNamespaceURIPattern> getProfileNamespaceURIPatterns() {
        return Collections.unmodifiableList(this.profileNamespaceURIPatterns);
    }

    public void register(ProfileNamespaceURIPattern profileNamespaceURIPattern) {
        this.profileNamespaceURIPatterns.add(profileNamespaceURIPattern);
    }

    public void unregister(ProfileNamespaceURIPattern profileNamespaceURIPattern) {
        this.profileNamespaceURIPatterns.remove(profileNamespaceURIPattern);
    }

    public Optional<ProfileNamespaceURIPattern> tryFindPattern(String namespaceURI) {
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternMatchResult match = pattern.match(namespaceURI);
            if (!match.hasMatched()) continue;
            return Optional.of((Object)pattern);
        }
        return Optional.absent();
    }

    public List<ProfileNamespaceURIPattern> findPatterns(String namespaceURI) {
        ArrayList patterns = Lists.newArrayList();
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternMatchResult match = pattern.match(namespaceURI);
            if (!match.hasMatched()) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    public Optional<ProfileNamespaceURIPatternMatchResult> tryFindMatch(String namespaceURI) {
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternMatchResult match = pattern.match(namespaceURI);
            if (!match.hasMatched()) continue;
            return Optional.of((Object)match);
        }
        return Optional.absent();
    }

    public List<ProfileNamespaceURIPatternMatchResult> findMatches(String namespaceURI) {
        ArrayList matches = Lists.newArrayList();
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternMatchResult match = pattern.match(namespaceURI);
            if (!match.hasMatched()) continue;
            matches.add(match);
        }
        return matches;
    }

    public Optional<ProfileNamespaceURIPatternComparison> tryFindComparison(String lhsNamespaceUri, String rhsNamespaceUri) {
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternComparison comparison = pattern.compare(lhsNamespaceUri, rhsNamespaceUri);
            if (!comparison.isValid()) continue;
            return Optional.of((Object)comparison);
        }
        return Optional.absent();
    }

    public List<ProfileNamespaceURIPatternComparison> findComparisons(String lhsNamespaceUri, String rhsNamespaceUri) {
        ArrayList comparisons = Lists.newArrayList();
        for (ProfileNamespaceURIPattern pattern : this.getProfileNamespaceURIPatterns()) {
            ProfileNamespaceURIPatternComparison comparison = pattern.compare(lhsNamespaceUri, rhsNamespaceUri);
            if (!comparison.isValid()) continue;
            comparisons.add(comparison);
        }
        return comparisons;
    }
}

