/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.FragmentsOrdererHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperandBoundsComputeHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.InteractionFragment;

public class OLDCombinedFragmentCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        ICommand orderingFragmentsCommand;
        Command createElementAndViewCmd = super.getCreateElementAndViewCommand(request);
        if (createElementAndViewCmd == null || !createElementAndViewCmd.canExecute()) {
            return createElementAndViewCmd;
        }
        if (OLDCombinedFragmentCreationEditPolicy.isDerivedCombinedFragment(request.getViewAndElementDescriptor().getSemanticHint())) {
            ICommand createUpdateBoundsCmd;
            ICommandProxy commandProxy;
            ICommand realCmd;
            Rectangle selectionRect = this.getSelectionRectangle(request);
            Set<InteractionFragment> coveredInteractionFragments = SequenceUtil.getCoveredInteractionFragments(selectionRect, this.getHost(), null);
            request.getExtendedData().put("Covered InteractionFragments", coveredInteractionFragments);
            String hint = request.getViewAndElementDescriptor().getSemanticHint();
            if (OperandBoundsComputeHelper.isDerivedCombinedFragment(hint) && createElementAndViewCmd instanceof ICommandProxy && (realCmd = (commandProxy = (ICommandProxy)createElementAndViewCmd).getICommand()) instanceof CompositeCommand && (createUpdateBoundsCmd = OperandBoundsComputeHelper.createUpdateCFAndIOBoundsForCFCreationCommand(this.getHost(), (CreateViewRequest)request)) != null) {
                ((CompositeCommand)realCmd).add((IUndoableOperation)createUpdateBoundsCmd);
            }
        }
        if (createElementAndViewCmd.canExecute() && (orderingFragmentsCommand = FragmentsOrdererHelper.createOrderingFragmentsCommand(this.getHost(), request)) != null) {
            createElementAndViewCmd = createElementAndViewCmd.chain((Command)new ICommandProxy(orderingFragmentsCommand));
        }
        return createElementAndViewCmd;
    }

    protected Command getCreateCommand(CreateViewRequest request) {
        Command createViewCmd = super.getCreateCommand(request);
        if (createViewCmd instanceof ICommandProxy) {
            ICommandProxy commandProxy = (ICommandProxy)createViewCmd;
            CompositeCommand compositeCommand = null;
            ICommand realCmd = commandProxy.getICommand();
            if (realCmd instanceof CompositeCommand) {
                compositeCommand = (CompositeCommand)realCmd;
            } else {
                compositeCommand = new CompositeCommand(commandProxy.getLabel());
                compositeCommand.add((IUndoableOperation)realCmd);
                realCmd = compositeCommand;
            }
            for (CreateViewRequest.ViewDescriptor viewDescriptor : request.getViewDescriptors()) {
                ICommand createUpdateBoundsCmd;
                String hint = viewDescriptor.getSemanticHint();
                if (!OLDCombinedFragmentCreationEditPolicy.isDerivedCombinedFragment(hint) || !OperandBoundsComputeHelper.isDerivedCombinedFragment(hint) || (createUpdateBoundsCmd = OperandBoundsComputeHelper.createUpdateCFAndIOBoundsForCFCreationCommand(this.getHost(), request)) == null) continue;
                ((CompositeCommand)realCmd).add((IUndoableOperation)createUpdateBoundsCmd);
            }
            createViewCmd = new ICommandProxy(compositeCommand.reduce());
        }
        return createViewCmd;
    }

    private Rectangle getSelectionRectangle(CreateViewAndElementRequest request) {
        Rectangle selectionRect = new Rectangle();
        Point location = request.getLocation();
        Dimension size = request.getSize();
        if (location != null) {
            selectionRect.x = location.x;
            selectionRect.y = location.y;
        } else {
            selectionRect.x = 100;
            selectionRect.y = 100;
        }
        if (size != null) {
            selectionRect.height = size.height;
            selectionRect.width = size.width;
        } else {
            selectionRect.height = 61;
            selectionRect.width = 112;
        }
        return selectionRect;
    }

    private static boolean isDerivedCombinedFragment(String hint) {
        if (((IHintedType)UMLElementTypes.InteractionOperand_Shape).getSemanticHint().equals(hint)) {
            return true;
        }
        if (((IHintedType)UMLElementTypes.CombinedFragment_Shape).getSemanticHint().equals(hint)) {
            return true;
        }
        return ((IHintedType)UMLElementTypes.ConsiderIgnoreFragment_Shape).getSemanticHint().equals(hint);
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.isCreatingGate(request)) {
            return this.getCombinedFragmentEditPart();
        }
        return super.getTargetEditPart(request);
    }

    private EditPart getCombinedFragmentEditPart() {
        EditPart editPart = this.getHost();
        while (editPart != null) {
            if (editPart instanceof CombinedFragmentEditPart) {
                return editPart;
            }
            editPart = editPart.getParent();
        }
        return null;
    }

    private boolean isCreatingGate(Request request) {
        if (!(request instanceof CreateRequest)) {
            return false;
        }
        CreateRequest createReq = (CreateRequest)request;
        try {
            Object newObjectType = createReq.getNewObjectType();
            return "Gate".equals(newObjectType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean understandsRequest(Request request) {
        if (this.isCreatingGate(request)) {
            return this.getCombinedFragmentEditPart() != null;
        }
        return super.understandsRequest(request);
    }
}

