/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AnnotatedLinkEditPart;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.TimeObservation;

public class AnnotatedLinkEditCommand
extends AbstractTransactionalCommand {
    private AnnotatedLinkEditPart annotatedLink;
    private Element oldSourceElement;
    private Element oldTargetElement;
    private Element newSourceElement;
    private Element newTargetElement;

    public AnnotatedLinkEditCommand(TransactionalEditingDomain domain) {
        super(domain, "edit annotated link", null);
    }

    public boolean canExecute() {
        if (this.newSourceElement != null) {
            if (!(this.newSourceElement instanceof Comment || this.newSourceElement instanceof Observation || this.newSourceElement instanceof Constraint)) {
                return false;
            }
            if (this.newSourceElement == this.newTargetElement || this.newSourceElement == this.oldTargetElement) {
                return false;
            }
        } else if (this.oldSourceElement != null) {
            if (!(this.oldSourceElement instanceof Comment || this.oldSourceElement instanceof Observation || this.oldSourceElement instanceof Constraint)) {
                return false;
            }
            if (this.oldSourceElement == this.newTargetElement || this.oldSourceElement == this.newTargetElement) {
                return false;
            }
        }
        Element targetElement = this.newTargetElement == null ? this.oldTargetElement : this.newTargetElement;
        Element sourceElement = this.newSourceElement == null ? this.oldSourceElement : this.newSourceElement;
        return this.checkTargetType(sourceElement, targetElement);
    }

    private boolean checkTargetType(Element sourceElement, Element targetElement) {
        if (sourceElement == null || targetElement == null) {
            return false;
        }
        if (sourceElement instanceof DurationObservation || sourceElement instanceof TimeObservation) {
            return targetElement instanceof NamedElement;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Element sourceElement;
        if (!this.canExecute()) {
            return CommandResult.newErrorCommandResult((String)"Unable to create annotated link");
        }
        Element targetElement = this.newTargetElement == null ? this.oldTargetElement : this.newTargetElement;
        Element element = sourceElement = this.newSourceElement == null ? this.oldSourceElement : this.newSourceElement;
        if (targetElement == null || sourceElement == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to create annotated link");
        }
        if (this.oldSourceElement != null) {
            if (this.oldSourceElement instanceof Comment) {
                ((Comment)this.oldSourceElement).getAnnotatedElements().remove((Object)this.oldTargetElement);
            } else if (this.oldSourceElement instanceof DurationObservation) {
                ((DurationObservation)this.oldSourceElement).getEvents().remove((Object)this.oldTargetElement);
            } else if (this.oldSourceElement instanceof TimeObservation) {
                ((TimeObservation)this.oldSourceElement).setEvent(null);
            } else if (this.oldSourceElement instanceof Constraint) {
                ((Constraint)this.oldSourceElement).getConstrainedElements().remove((Object)this.oldTargetElement);
            }
        }
        if (sourceElement instanceof Comment) {
            ((Comment)sourceElement).getAnnotatedElements().add((Object)targetElement);
        } else if (sourceElement instanceof DurationObservation && targetElement instanceof NamedElement) {
            ((DurationObservation)sourceElement).getEvents().add((Object)((NamedElement)targetElement));
        } else if (sourceElement instanceof TimeObservation && targetElement instanceof NamedElement) {
            ((TimeObservation)sourceElement).setEvent((NamedElement)targetElement);
        } else if (sourceElement instanceof Constraint) {
            ((Constraint)sourceElement).getConstrainedElements().add((Object)targetElement);
        }
        return CommandResult.newOKCommandResult((Object)sourceElement);
    }

    private Element resolveElement(EditPart editPart) {
        EObject element;
        if (editPart == null) {
            return null;
        }
        Object model = editPart.getModel();
        if (model instanceof View && (element = ViewUtil.resolveSemanticElement((View)((View)model))) instanceof Element) {
            return (Element)element;
        }
        return null;
    }

    public void setSource(EditPart source) {
        this.newSourceElement = this.resolveElement(source);
    }

    public void setTarget(EditPart target) {
        this.newTargetElement = this.resolveElement(target);
    }

    public AnnotatedLinkEditPart getAnnotatedLink() {
        return this.annotatedLink;
    }

    public void setAnnotatedLink(AnnotatedLinkEditPart annotatedLink) {
        this.annotatedLink = annotatedLink;
        if (annotatedLink != null) {
            this.oldSourceElement = this.resolveElement(annotatedLink.getSource());
            this.oldTargetElement = this.resolveElement(annotatedLink.getTarget());
        }
    }
}

