/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.handler;

import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.commands.ControlModeCommandParameterValues;
import org.eclipse.papyrus.infra.services.controlmode.commands.ResourceLocationParameterValues;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.ui.IControlModeFragmentDialogProvider;
import org.eclipse.papyrus.infra.services.controlmode.util.LabelHelper;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ControlCommandHandler
extends AbstractHandler {
    private static final String PARAMETER_ERROR = Messages.getString("ControlCommandHandler.parameter.error");
    private static final String PARAMETER_VALUE_ERROR = Messages.getString("ControlCommandHandler.parameter.value.error");
    private static final String MODELSET_ERROR = Messages.getString("ControlCommandHandler.modelset.error");
    private static final String SHOW_DIALOG_PARAMETER = "showDialog";
    private static final String NO_EDITING_DOMAIN_MESSAGE = Messages.getString("ControlCommandHandler.editing.domain.error");
    private static final String EMPTY_SELECTION_MESSAGE = Messages.getString("ControlCommandHandler.empty.selection.message");
    public static final String CONTROLMODE_USE_DIALOG_PARAMETER = "org.eclipse.papyrus.infra.services.controlmode.useDialogParameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
                    NotificationBuilder.createInfoPopup((String)EMPTY_SELECTION_MESSAGE).run();
                    return null;
                }
                EObject eObjectToControl = EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
                try {
                    TransactionalEditingDomain editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)eObjectToControl);
                    if (this.getShowDialogParameterValue(event).booleanValue()) {
                        IControlModeFragmentDialogProvider provider = this.getDialogProvider(eObjectToControl);
                        Dialog dialog = provider.createDialog(Display.getCurrent().getActiveShell(), eObjectToControl, this.getDefaultLabelResource(eObjectToControl));
                        if (dialog.open() == 0) {
                            ControlModeRequest controlRequest = provider.getControlRequest(dialog, editingDomain, eObjectToControl);
                            IControlModeManager controlMng = ControlModeManager.getInstance();
                            Diagnostic problems = controlMng.approveRequest(controlRequest);
                            if (problems != null && problems.getSeverity() >= 4) {
                                IStatus status = BasicDiagnostic.toIStatus((Diagnostic)problems);
                                StatusManager.getManager().handle(status, 2);
                            } else {
                                ICommand controlCommand = controlMng.getControlCommand(controlRequest);
                                editingDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(controlCommand));
                            }
                        }
                        break block10;
                    }
                    URI resourceURI = this.getParameterisedURI(event);
                    if (resourceURI == null) {
                        resourceURI = this.computeDefaultURI(eObjectToControl.eResource(), this.getDefaultLabelResource(eObjectToControl));
                    }
                    ControlModeRequest controlRequest = ControlModeRequest.createUIControlModelRequest(editingDomain, eObjectToControl, resourceURI);
                    IControlModeManager controlMng = ControlModeManager.getInstance();
                    ICommand controlCommand = controlMng.getControlCommand(controlRequest);
                    editingDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(controlCommand));
                }
                catch (ServiceException e) {
                    NotificationBuilder.createInfoPopup((String)NO_EDITING_DOMAIN_MESSAGE).run();
                }
            } else {
                NotificationBuilder.createInfoPopup((String)EMPTY_SELECTION_MESSAGE).run();
            }
        }
        return null;
    }

    private URI getParameterisedURI(ExecutionEvent event) {
        ResourceLocationParameterValues parameterValues = null;
        Command command = event.getCommand();
        try {
            parameterValues = (ResourceLocationParameterValues)command.getParameter("org.eclipse.papyrus.infra.services.controlmode.resourceLocation").getValues();
        }
        catch (ParameterValuesException e) {
            ControlModePlugin.log.error((Throwable)e);
        }
        catch (NotDefinedException e) {
            ControlModePlugin.log.error((Throwable)e);
        }
        return parameterValues.getResourceLocation();
    }

    public URI computeDefaultURI(Resource currentResource, String defaultName) {
        String ext = currentResource.getURI().fileExtension();
        URI uri = currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(defaultName).appendFileExtension(ext);
        return uri;
    }

    protected Boolean getShowDialogParameterValue(ExecutionEvent event) {
        Boolean showDialogValue = null;
        ControlModeCommandParameterValues parameterValues = null;
        try {
            Command command = event.getCommand();
            parameterValues = (ControlModeCommandParameterValues)command.getParameter(CONTROLMODE_USE_DIALOG_PARAMETER).getValues();
            showDialogValue = parameterValues.get(SHOW_DIALOG_PARAMETER);
            if (showDialogValue == null) {
                showDialogValue = true;
            }
        }
        catch (ParameterValuesException e) {
            ControlModePlugin.log.error(PARAMETER_VALUE_ERROR, (Throwable)e);
        }
        catch (NotDefinedException e) {
            ControlModePlugin.log.error(PARAMETER_ERROR, (Throwable)e);
        }
        return showDialogValue;
    }

    IControlModeFragmentDialogProvider getDialogProvider(EObject context) {
        try {
            ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)context);
            return (IControlModeFragmentDialogProvider)PlatformHelper.getAdapter((Object)modelSet, IControlModeFragmentDialogProvider.class, (Object)IControlModeFragmentDialogProvider.DEFAULT);
        }
        catch (ServiceException e) {
            ControlModePlugin.log.error(MODELSET_ERROR, (Throwable)e);
            return IControlModeFragmentDialogProvider.DEFAULT;
        }
    }

    protected String getDefaultLabelResource(EObject eObject) {
        Object eGet;
        String defaultName = null;
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature("name");
        if (feature != null && (eGet = eObject.eGet(feature)) instanceof String) {
            defaultName = (String)eGet;
        }
        if (defaultName == null) {
            defaultName = LabelHelper.getPrettyLabel(eObject);
            Pattern p = Pattern.compile("<<.*?>>|<.*?>");
            defaultName = p.matcher(defaultName).replaceAll("").trim();
        }
        StringBuilder b = new StringBuilder();
        char[] cArray = defaultName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (Character.isJavaIdentifierPart(c.charValue())) {
                b.append(c);
            } else {
                b.append("_");
            }
            ++n2;
        }
        return b.toString();
    }
}

