/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.util.FiltersAdapterFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ChildConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Configuration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.SeparatorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.editor.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.NewFilterDialog;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.PaletteConfigurationEditorPlugin;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.PaletteconfigurationEditor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider.CustomPaletteconfigurationItemProviderAdapterFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CustomPaletteconfigurationEditor
extends PaletteconfigurationEditor
implements ITabbedPropertySheetPageContributor {
    private static final String CONTRIBUTION_ID = "PaletteConfiguration";
    private IPropertySheetPage propertySheetPage;
    private ToolBar toolbar;
    protected static final String CREATE_DRAWERS_ICON = "/icons/new_drawer.gif";
    protected static final String CREATE_SEPARATOR_ICON = "/icons/new_separator.gif";
    protected static final String CREATE_STACK_ICON = "/icons/new_stack.gif";
    protected static final String CREATE_TOOL_ICON = "/icons/new_tool.gif";
    protected static final String DELETE_ICON = "/icons/delete.gif";
    protected static final String FILTERS_ICON = "/icons/filter.gif";
    private static final String NEW_TOOL_LABEL = Messages.CustomPaletteconfigurationEditor_NewTool;
    private static final String STACK_LABEL = "Stack";
    private static final String DRAWER_LABEL = "Drawer";
    private static final String SEPARATOR_LABEL = "Separator";
    protected static final String VALIDATOR = "validator";

    @Override
    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        ResourceSet resourceSet = (ResourceSet)object;
                        if (!resourceSet.getResources().isEmpty() && !((Resource)resourceSet.getResources().get(0)).getContents().isEmpty() && ((Resource)resourceSet.getResources().get(0)).getContents().get(0) instanceof PaletteConfiguration) {
                            return ((PaletteConfiguration)((Resource)resourceSet.getResources().get(0)).getContents().get(0)).getDrawerConfigurations();
                        }
                        return Collections.emptyList();
                    }
                };
            }
        });
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CustomPaletteconfigurationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new FiltersAdapterFactory());
        TransactionalCommandStackImpl commandStack = new TransactionalCommandStackImpl();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                CustomPaletteconfigurationEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CustomPaletteconfigurationEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            CustomPaletteconfigurationEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator i = (this).CustomPaletteconfigurationEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = (PropertySheetPage)i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        TransactionalEditingDomainImpl editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)this.adapterFactory, (TransactionalCommandStack)commandStack);
        WorkspaceEditingDomainFactory.INSTANCE.mapResourceSet((TransactionalEditingDomain)editingDomain);
        this.editingDomain = editingDomain;
    }

    @Override
    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return this.propertySheetPage;
    }

    public String getContributorId() {
        return CONTRIBUTION_ID;
    }

    protected ToolItem createCheckToolBarItem(ToolBar toolbar, String shownElementsIcon, String tooltip, Listener listener) {
        ToolItem item = new ToolItem(toolbar, 2080);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration", (String)shownElementsIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        return item;
    }

    @Override
    public void createPages() {
        this.createModel();
        Composite parent = this.getContainer();
        Composite paletteComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paletteComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        paletteComposite.setLayoutData((Object)data);
        this.toolbar = new ToolBar(paletteComposite, 256);
        GridData data2 = new GridData(16384, 0x1000000, true, false);
        data2.horizontalIndent = 20;
        this.toolbar.setLayoutData((Object)data2);
        this.populatePalettePreviewToolBar(this.toolbar);
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(paletteComposite, 2);
            data = new GridData(4, 4, true, true);
            tree.setLayoutData((Object)data);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CustomPaletteconfigurationEditor.this.handleSelectionChanged(event);
                }
            });
            this.handleSelectionChanged(null);
            this.addDragDropSupport((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)paletteComposite);
            this.setPageText(pageIndex, PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomPaletteconfigurationEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    CustomPaletteconfigurationEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CustomPaletteconfigurationEditor.this.updateProblemIndication();
            }
        });
    }

    protected void addDragDropSupport(StructuredViewer viewer) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    protected void populatePalettePreviewToolBar(ToolBar toolbar) {
        PaletteConfigurationEntrySelectedValidator validator = new PaletteConfigurationEntrySelectedValidator();
        PaletteConfigurationStackLeafSelectedValidator validatorForNotStackChild = new PaletteConfigurationStackLeafSelectedValidator();
        this.createToolBarItem(toolbar, DELETE_ICON, Messages.CustomPaletteconfigurationEditor_RemoveButtonTooltip, this.createRemoveElementListener(), validator);
        this.createToolBarItem(toolbar, CREATE_DRAWERS_ICON, Messages.CustomPaletteconfigurationEditor_Create_Drawer_Tooltip, this.createNewDrawerListener(), null);
        this.createToolBarItem(toolbar, CREATE_SEPARATOR_ICON, Messages.CustomPaletteconfigurationEditor_Create_Separator_Tooltip, this.createNewSeparatorListener(), validatorForNotStackChild);
        this.createToolBarItem(toolbar, CREATE_TOOL_ICON, Messages.CustomPaletteconfigurationEditor_Create_Tool_Tooltip, this.createNewToolListener(), validator);
        this.createToolBarItem(toolbar, CREATE_STACK_ICON, Messages.CustomPaletteconfigurationEditor_Create_Stack_Tooltip, this.createNewStackListener(), validatorForNotStackChild);
        this.createToolBarItem(toolbar, FILTERS_ICON, "Create a new Filter", this.createFilterListener(), () -> {
            Object firstElement = ((IStructuredSelection)this.getSelection()).getFirstElement();
            return firstElement instanceof Configuration || firstElement instanceof CompoundFilter;
        });
    }

    private Listener createFilterListener() {
        return event -> {
            CompoundFilter parent;
            IStructuredSelection selection = (IStructuredSelection)this.selectionViewer.getSelection();
            if (selection == null || selection.size() != 1) {
                return;
            }
            Object selected = selection.getFirstElement();
            StrictCompoundCommand command = new StrictCompoundCommand();
            if (selected instanceof Configuration) {
                Configuration configuration = (Configuration)selected;
                if (configuration.getFilter() != null) {
                    command.append((Command)new DeleteCommand(this.getEditingDomain(), Collections.singleton(configuration.getFilter())));
                }
                parent = configuration;
            } else if (selected instanceof CompoundFilter) {
                parent = (CompoundFilter)selected;
            } else {
                return;
            }
            List<CommandParameter> newChildDescriptors = this.editingDomain.getNewChildDescriptors((Object)parent, null).stream().filter(CommandParameter.class::isInstance).map(CommandParameter.class::cast).collect(Collectors.toList());
            NewFilterDialog dialog = new NewFilterDialog(this.getSite().getShell(), newChildDescriptors);
            if (dialog.open() == 0 && dialog.getNewChild() != null) {
                CommandParameter newChild = dialog.getNewChild();
                Command createCommand = this.editingDomain.createCommand(CreateChildCommand.class, new CommandParameter((Object)parent, null, (Object)newChild));
                command.append(createCommand);
                TransactionalEditingDomain ted = (TransactionalEditingDomain)this.editingDomain;
                EMFOperationCommand operation = new EMFOperationCommand(ted, (IUndoableOperation)new AbstractEMFOperation(ted, "Create filter", (CompoundCommand)command){
                    private final /* synthetic */ CompoundCommand val$command;
                    {
                        this.val$command = compoundCommand;
                        super($anonymous0, $anonymous1);
                    }

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (this.val$command.canExecute()) {
                            this.val$command.execute();
                            return Status.OK_STATUS;
                        }
                        throw new ExecutionException("Unable to create a new filter - the operation is not enabled");
                    }
                });
                ted.getCommandStack().execute((Command)operation);
            }
        };
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            int i = 0;
            while (i < this.toolbar.getItemCount()) {
                ToolItem item = this.toolbar.getItem(i);
                Object validator = item.getData(VALIDATOR);
                if (validator instanceof ToolBarItemValidator) {
                    item.setEnabled(((ToolBarItemValidator)validator).isEnable());
                }
                ++i;
            }
        }
    }

    protected void createToolBarItem(ToolBar toolbar, String itemIcon, String tooltip, Listener listener, ToolBarItemValidator validator) {
        ToolItem item = new ToolItem(toolbar, 2048);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.gmfdiag.common", (String)itemIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        item.setData(VALIDATOR, (Object)validator);
    }

    protected Listener createRemoveElementListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                for (Object object : selection) {
                    if (!(object instanceof Configuration)) continue;
                    EcoreUtil.delete((EObject)((EObject)object));
                }
                CustomPaletteconfigurationEditor.this.selectionViewer.refresh();
            }
        };
    }

    protected Listener createNewDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                EObject palette = (EObject)((Resource)CustomPaletteconfigurationEditor.this.editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
                if (palette instanceof PaletteConfiguration) {
                    DrawerConfiguration drawer = PaletteconfigurationFactory.eINSTANCE.createDrawerConfiguration();
                    drawer.setLabel(CustomPaletteconfigurationEditor.DRAWER_LABEL);
                    EList drawerConfigurations = ((PaletteConfiguration)palette).getDrawerConfigurations();
                    drawerConfigurations.add((Object)drawer);
                    CustomPaletteconfigurationEditor.this.selectionViewer.refresh();
                }
            }
        };
    }

    protected Listener createNewSeparatorListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection()).getFirstElement();
                SeparatorConfiguration separator = PaletteconfigurationFactory.eINSTANCE.createSeparatorConfiguration();
                separator.setLabel(CustomPaletteconfigurationEditor.SEPARATOR_LABEL);
                separator.setId(CreatePaletteItemUtil.generateID((String)CustomPaletteconfigurationEditor.SEPARATOR_LABEL));
                if (object instanceof DrawerConfiguration) {
                    ((DrawerConfiguration)object).getOwnedConfigurations().add((Object)separator);
                } else if (object instanceof ChildConfiguration) {
                    EList ownedConfigurations = ((DrawerConfiguration)((ChildConfiguration)object).eContainer()).getOwnedConfigurations();
                    int index = ownedConfigurations.indexOf(object);
                    ownedConfigurations.add(index, (Object)separator);
                }
                CustomPaletteconfigurationEditor.this.selectionViewer.expandToLevel(object, 1);
                CustomPaletteconfigurationEditor.this.selectionViewer.refresh();
            }
        };
    }

    protected Listener createNewStackListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection()).getFirstElement();
                StackConfiguration stack = PaletteconfigurationFactory.eINSTANCE.createStackConfiguration();
                stack.setLabel(CustomPaletteconfigurationEditor.STACK_LABEL);
                stack.setId(CreatePaletteItemUtil.generateID((String)CustomPaletteconfigurationEditor.STACK_LABEL));
                if (object instanceof DrawerConfiguration) {
                    ((DrawerConfiguration)object).getOwnedConfigurations().add((Object)stack);
                } else if (object instanceof ChildConfiguration) {
                    EList ownedConfigurations = ((DrawerConfiguration)((ChildConfiguration)object).eContainer()).getOwnedConfigurations();
                    int index = ownedConfigurations.indexOf(object);
                    ownedConfigurations.add(index, (Object)stack);
                }
                CustomPaletteconfigurationEditor.this.selectionViewer.expandToLevel(object, 1);
                CustomPaletteconfigurationEditor.this.selectionViewer.refresh();
            }
        };
    }

    protected Listener createNewToolListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection()).getFirstElement();
                ToolConfiguration tool = PaletteconfigurationFactory.eINSTANCE.createToolConfiguration();
                tool.setLabel(NEW_TOOL_LABEL);
                if (object instanceof DrawerConfiguration || object instanceof StackConfiguration) {
                    if (object instanceof DrawerConfiguration) {
                        ((DrawerConfiguration)object).getOwnedConfigurations().add((Object)tool);
                    } else if (object instanceof StackConfiguration) {
                        ((StackConfiguration)object).getOwnedConfigurations().add((Object)tool);
                    }
                } else if (object instanceof ChildConfiguration) {
                    EObject eContainer = ((EObject)object).eContainer();
                    if (eContainer instanceof DrawerConfiguration) {
                        EList ownedConfigurations = ((DrawerConfiguration)eContainer).getOwnedConfigurations();
                        int index = ownedConfigurations.indexOf(object);
                        ownedConfigurations.add(index, (Object)tool);
                    } else if (eContainer instanceof StackConfiguration) {
                        EList ownedConfigurations = ((StackConfiguration)eContainer).getOwnedConfigurations();
                        int index = ownedConfigurations.indexOf(object);
                        ownedConfigurations.add(index, (Object)tool);
                    }
                }
                CustomPaletteconfigurationEditor.this.selectionViewer.expandToLevel(object, 1);
                CustomPaletteconfigurationEditor.this.selectionViewer.refresh();
            }
        };
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        saveOptions.put("URI_HANDLER", (String)new URIHandlerImpl.PlatformSchemeAware());
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CustomPaletteconfigurationEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CustomPaletteconfigurationEditor.this.isPersisted(resource) || CustomPaletteconfigurationEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            CustomPaletteconfigurationEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        CustomPaletteconfigurationEditor.this.resourceToDiagnosticMap.put(resource, CustomPaletteconfigurationEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            PaletteConfigurationEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected class PaletteConfigurationEntrySelectedValidator
    implements ToolBarItemValidator {
        protected PaletteConfigurationEntrySelectedValidator() {
        }

        @Override
        public boolean isEnable() {
            if (CustomPaletteconfigurationEditor.this.selectionViewer != null && !CustomPaletteconfigurationEditor.this.selectionViewer.getControl().isDisposed()) {
                IStructuredSelection selection = (IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection();
                if (selection == null) {
                    return false;
                }
                Object object = selection.getFirstElement();
                return object instanceof Configuration;
            }
            return false;
        }
    }

    protected class PaletteConfigurationStackLeafSelectedValidator
    implements ToolBarItemValidator {
        protected PaletteConfigurationStackLeafSelectedValidator() {
        }

        @Override
        public boolean isEnable() {
            if (CustomPaletteconfigurationEditor.this.selectionViewer != null && !CustomPaletteconfigurationEditor.this.selectionViewer.getControl().isDisposed()) {
                IStructuredSelection selection = (IStructuredSelection)CustomPaletteconfigurationEditor.this.selectionViewer.getSelection();
                if (selection == null) {
                    return false;
                }
                Object object = selection.getFirstElement();
                return object instanceof Configuration && !(((Configuration)object).eContainer() instanceof StackConfiguration);
            }
            return false;
        }
    }

    protected static interface ToolBarItemValidator {
        public boolean isEnable();
    }
}

