/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionsPackage;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsFactory;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.AbstractSynchronizedOnEStructuralFeatureAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.MasterObjectAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.IWrapper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;

public class EObjectColumnMatrixAxisManager
extends AbstractSynchronizedOnEStructuralFeatureAxisManager {
    private final IBooleanEObjectExpression defaultFilter = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();
    private List<EObject> listenEObjects = new ArrayList<EObject>();
    private Map<TreeFillingConfiguration, TreeFillingConfigurationHelper> map;
    private Map<EStructuralFeature, TreeFillingConfiguration> featureVSConfiguration;
    private List<EStructuralFeature> tableFeatureToListen = new ArrayList<EStructuralFeature>();
    private Adapter tableConfigurationChangesListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            Object listenFeature = msg.getFeature();
            boolean toListen = false;
            if (listenFeature instanceof EStructuralFeature) {
                EClass eClass = ((EStructuralFeature)listenFeature).getEContainingClass();
                toListen = ExpressionsPackage.eINSTANCE.getIExpression().isSuperTypeOf(eClass);
            }
            if (toListen || EObjectColumnMatrixAxisManager.this.tableFeatureToListen.contains(msg.getFeature())) {
                EObjectColumnMatrixAxisManager.this.updateAxisAfterConfigurationChange();
                EObjectColumnMatrixAxisManager.this.cleanAndReinitListenObjects();
                EObjectColumnMatrixAxisManager.this.cleanAndFillTreeFillingConfigurationMap();
            }
        }
    };

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        Assert.isTrue((boolean)(this.getRepresentedContentProvider() instanceof MasterObjectAxisProvider));
        this.listenEObjects = new ArrayList<EObject>();
        this.tableFeatureToListen = new ArrayList<EStructuralFeature>();
        this.tableFeatureToListen.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getLocalTableHeaderAxisConfiguration_AxisManagerConfigurations());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_AxisUsedAsAxisProvider());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_FilterRule());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources());
        this.cleanAndReinitListenObjects();
        this.cleanAndFillTreeFillingConfigurationMap();
    }

    private void addListenerOnTableConfigurationObjects(EObject eobject) {
        if (eobject != null && !eobject.eAdapters().contains((Object)this.tableConfigurationChangesListener)) {
            eobject.eAdapters().add((Object)this.tableConfigurationChangesListener);
            this.listenEObjects.add(eobject);
        }
    }

    private void removeListenersOnTableConfigurationObjects() {
        for (EObject current : this.listenEObjects) {
            current.eAdapters().remove((Object)this.tableConfigurationChangesListener);
        }
    }

    private void cleanAndReinitListenObjects() {
        AbstractAxisProvider rowAxisProvider;
        AbstractAxisProvider axisProvider;
        ICellEditorConfiguration cellEditorConfiguration;
        this.removeListenersOnTableConfigurationObjects();
        Table table = this.getTableManager().getTable();
        if (table == null) {
            return;
        }
        this.addListenerOnTableConfigurationObjects((EObject)table);
        LocalTableHeaderAxisConfiguration columnHeaderAxisConfiguration = table.getLocalColumnHeaderAxisConfiguration();
        if (columnHeaderAxisConfiguration instanceof LocalTableHeaderAxisConfiguration) {
            this.addListenerOnTableConfigurationObjects((EObject)columnHeaderAxisConfiguration);
            for (IAxisConfiguration current : columnHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != 1) continue;
                TreeFillingConfiguration treeFillingConfiguration = (TreeFillingConfiguration)current;
                this.addListenerOnTableConfigurationObjects((EObject)treeFillingConfiguration);
                IAxis provider = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                this.addListenerOnTableConfigurationObjects((EObject)provider);
                IBooleanEObjectExpression filterRule = treeFillingConfiguration.getFilterRule();
                this.addListenerOnTableConfigurationObjects((EObject)filterRule);
            }
        }
        if ((cellEditorConfiguration = table.getOwnedCellEditorConfigurations()) != null) {
            this.addListenerOnTableConfigurationObjects((EObject)cellEditorConfiguration);
            if (cellEditorConfiguration instanceof GenericRelationshipMatrixCellEditorConfiguration) {
                GenericRelationshipMatrixCellEditorConfiguration tmp = (GenericRelationshipMatrixCellEditorConfiguration)cellEditorConfiguration;
                IBooleanEObjectExpression filter = tmp.getCellContentsFilter();
                this.addListenerOnTableConfigurationObjects((EObject)filter);
            }
        }
        if ((axisProvider = table.getCurrentColumnAxisProvider()) instanceof IMasterAxisProvider) {
            this.addListenerOnTableConfigurationObjects((EObject)axisProvider);
        }
        if ((rowAxisProvider = table.getCurrentRowAxisProvider()) instanceof IMasterAxisProvider) {
            this.addListenerOnTableConfigurationObjects((EObject)rowAxisProvider);
        }
    }

    private void cleanAndFillTreeFillingConfigurationMap() {
        if (this.map == null) {
            this.map = new HashMap<TreeFillingConfiguration, TreeFillingConfigurationHelper>();
        }
        if (this.featureVSConfiguration == null) {
            this.featureVSConfiguration = new HashMap<EStructuralFeature, TreeFillingConfiguration>();
        }
        this.map.clear();
        this.featureVSConfiguration.clear();
        Table table = this.getTableManager().getTable();
        if (table != null) {
            for (TreeFillingConfiguration treeFillingConfiguration : FillingConfigurationUtils.getTreeFillingConfigurationForColumn((Table)table, (AxisManagerRepresentation)this.representedAxisManager)) {
                if (treeFillingConfiguration.getDepth() != 1) continue;
                TreeFillingConfigurationHelper helper = new TreeFillingConfigurationHelper(treeFillingConfiguration);
                this.map.put(treeFillingConfiguration, helper);
                this.featureVSConfiguration.put(helper.getEStructuralFeatureToListen(), treeFillingConfiguration);
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getListenFeatures() {
        if (this.map == null) {
            this.cleanAndFillTreeFillingConfigurationMap();
        }
        this.listenFeatures = new HashSet();
        for (TreeFillingConfigurationHelper helper : this.map.values()) {
            EStructuralFeature current = helper.getEStructuralFeatureToListen();
            this.listenFeatures.add(current);
        }
        return this.listenFeatures;
    }

    @Override
    protected void verifyFeatureMultiplicity() {
    }

    @Override
    protected void verifyValues() {
    }

    @Override
    protected List<Object> getFeaturesValue() {
        this.getListenFeatures();
        ArrayList<Object> values = new ArrayList<Object>();
        for (EObject source : this.getColumnSources()) {
            values.addAll(this.getListenFeatureValueFor(source));
        }
        return values;
    }

    protected List<Object> getListenFeatureValueFor(EObject listenObject) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TreeFillingConfigurationHelper current : this.map.values()) {
            EStructuralFeature feature = current.getEStructuralFeatureToListen();
            IBooleanEObjectExpression exp = current.getFilterRule();
            if (feature == null) continue;
            Object value = listenObject.eGet(feature);
            if (feature.isMany()) {
                for (Object tmp : (Collection)value) {
                    if (!(tmp instanceof EObject) || !((Boolean)exp.evaluate((Object)((EObject)tmp))).booleanValue()) continue;
                    values.add(tmp);
                }
                continue;
            }
            if (!(value instanceof EObject) || !((Boolean)exp.evaluate((Object)((EObject)value))).booleanValue()) continue;
            values.add(value);
        }
        return values;
    }

    public boolean isAllowedContents(Object object) {
        return true;
    }

    public boolean isAllowedContents(Object objectToTest, Object semanticParent, TreeFillingConfiguration conf, int depth) {
        boolean result = false;
        if (semanticParent instanceof EObject && objectToTest instanceof EObject && conf != null && conf.getAxisUsedAsAxisProvider() != null) {
            IBooleanEObjectExpression filter;
            IBooleanEObjectExpression iBooleanEObjectExpression = filter = conf.getFilterRule() != null ? conf.getFilterRule() : this.defaultFilter;
            if (((Boolean)filter.evaluate((Object)((EObject)objectToTest))).booleanValue()) {
                result = CellManagerFactory.INSTANCE.getCrossValueAsCollection(semanticParent, (Object)conf.getAxisUsedAsAxisProvider(), this.tableManager).contains(objectToTest);
            }
        }
        return result;
    }

    @Override
    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        EStructuralFeature editedFeature = (EStructuralFeature)(notification.getFeature() instanceof EStructuralFeature ? notification.getFeature() : null);
        if (editedFeature == null) {
            return;
        }
        TreeFillingConfiguration configuration = this.featureVSConfiguration.get(editedFeature);
        if (configuration == null) {
            return;
        }
        int eventType = notification.getEventType();
        EObject editedObject = (EObject)(notification.getNotifier() instanceof EObject ? notification.getNotifier() : null);
        if (editedObject == null) {
            return;
        }
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        switch (eventType) {
            case 8: {
                break;
            }
            case 3: {
                Object newValue = notification.getNewValue();
                if (!this.isAllowedContents(newValue, editedObject, configuration, configuration.getDepth()) || this.isAlreadyManaged(newValue)) break;
                toAdd.add(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Object current : newValues) {
                    if (!this.isAllowedContents(current, editedObject, configuration, configuration.getDepth()) || this.isAlreadyManaged(current)) continue;
                    toAdd.add(current);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Collection collection = (Collection)((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                Collection<EObject> subList = this.getSubFromFirstNotEquals(collection, (Integer)notification.getOldValue(), this.getIndex(collection, (EObject)notification.getNewValue()));
                toRemove.addAll(subList);
                toAdd.addAll(subList);
                break;
            }
            case 4: {
                Object oldValue = notification.getOldValue();
                if (!this.managedObject.contains(oldValue)) break;
                toRemove.add(oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Object current : oldValues) {
                    if (!this.managedObject.contains(oldValues)) continue;
                    toRemove.add(current);
                }
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }

    public boolean canBeUsedAsRowManager() {
        return false;
    }

    public boolean canBeUsedAsColumnManager() {
        return true;
    }

    protected List<EObject> getColumnSources() {
        AbstractAxisProvider columnProvider = this.getTableManager().getTable().getCurrentColumnAxisProvider();
        ArrayList<EObject> context = new ArrayList<EObject>();
        if (columnProvider instanceof MasterObjectAxisProvider) {
            for (IWrapper wrapper : ((MasterObjectAxisProvider)columnProvider).getSources()) {
                if (!(wrapper.getElement() instanceof EObject)) continue;
                context.add((EObject)wrapper.getElement());
            }
        }
        return context;
    }

    protected void updateAxisAfterConfigurationChange() {
        if (this.getTableManager() == null || this.getTableManager().getTable() == null || this.getTableManager().getTable().getCurrentColumnAxisProvider() == null) {
            return;
        }
        ArrayList<Object> allAxisToDisplay = new ArrayList<Object>();
        for (IWrapper current : ((IMasterAxisProvider)this.getTableManager().getTable().getCurrentColumnAxisProvider()).getSources()) {
            allAxisToDisplay.addAll(this.getListenFeatureValueFor((EObject)current.getElement()));
        }
        ArrayList<Object> toAdd = new ArrayList<Object>(allAxisToDisplay);
        toAdd.removeAll(this.managedObject);
        ArrayList<Object> toRemove = new ArrayList<Object>(this.managedObject);
        toRemove.removeAll(allAxisToDisplay);
        this.updateManagedList(toAdd, toRemove);
    }

    public void dispose() {
        this.removeListenersOnTableConfigurationObjects();
        this.getTableManager().getTable().eAdapters().remove((Object)this.tableConfigurationChangesListener);
        this.tableFeatureToListen.clear();
        this.featureVSConfiguration.clear();
        this.map.clear();
        super.dispose();
    }

    protected class TreeFillingConfigurationHelper {
        private final IBooleanEObjectExpression defaultExpression = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();
        private final TreeFillingConfiguration fillingConfiguration;

        public TreeFillingConfigurationHelper(TreeFillingConfiguration configuration) {
            this.fillingConfiguration = configuration;
        }

        public IBooleanEObjectExpression getFilterRule() {
            return this.fillingConfiguration.getFilterRule() == null ? this.defaultExpression : this.fillingConfiguration.getFilterRule();
        }

        private Object getFeatureToListen() {
            if (this.fillingConfiguration.getAxisUsedAsAxisProvider() != null) {
                return this.fillingConfiguration.getAxisUsedAsAxisProvider().getElement();
            }
            return null;
        }

        public EStructuralFeature getEStructuralFeatureToListen() {
            return (EStructuralFeature)(this.getFeatureToListen() instanceof EStructuralFeature ? this.getFeatureToListen() : null);
        }
    }
}

