/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import com.google.inject.Injector;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.papyrus.uml.xtext.integration.CompletionProposalAdapter;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextCellEditor;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextXtextAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.IXtextFakeContextResourcesProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class XtextStyledTextCellEditor
extends StyledTextCellEditor {
    public static final String GTK = "gtk";
    protected Injector injector;
    protected StyledTextXtextAdapter xtextAdapter;
    protected StyledText styledText;
    protected IXtextFakeContextResourcesProvider contextFakeResourceProvider;
    protected ContextElementAdapter.IContextElementProvider provider;
    protected Shell startingShell;
    boolean ignoreNextFocusLost = false;
    protected CompletionProposalAdapter completionProposalAdapter;

    public XtextStyledTextCellEditor(int style, Injector injector, IXtextFakeContextResourcesProvider contextFakeResourceProvider) {
        this(style, injector);
        this.contextFakeResourceProvider = contextFakeResourceProvider;
    }

    public XtextStyledTextCellEditor(int style, Injector injector) {
        this.setStyle(style);
        this.injector = injector;
    }

    public XtextStyledTextCellEditor(int style, Injector injector, ContextElementAdapter.IContextElementProvider provider) {
        this.setStyle(style);
        this.provider = provider;
        this.injector = injector;
    }

    protected Control createControl(Composite parent) {
        this.styledText = (StyledText)super.createControl(parent);
        this.startingShell = this.styledText.getDisplay().getActiveShell();
        this.xtextAdapter = new StyledTextXtextAdapter(this.injector, this.contextFakeResourceProvider == null ? IXtextFakeContextResourcesProvider.NULL_CONTEXT_PROVIDER : this.contextFakeResourceProvider);
        this.xtextAdapter.adapt(this.styledText);
        this.completionProposalAdapter = this.xtextAdapter.getCompletionProposalAdapter();
        if (this.provider != null) {
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)new ContextElementAdapter(this.provider));
            if (this.provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
                ((ContextElementAdapter.IContextElementProviderWithInit)this.provider).initResource(this.xtextAdapter.getFakeResourceContext().getFakeResource());
            }
        }
        this.xtextAdapter.getXtextSourceviewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                XtextStyledTextCellEditor.this.editOccured(null);
            }
        });
        if ((this.styledText.getStyle() & 4) != 0) {
            this.styledText.addListener(3005, new Listener(){

                public void handleEvent(Event event) {
                    if (event.character == '\r' && !XtextStyledTextCellEditor.this.completionProposalAdapter.isProposalPopupOpen()) {
                        XtextStyledTextCellEditor.this.focusLost();
                    }
                }
            });
        }
        Listener cancelListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u001b' && !XtextStyledTextCellEditor.this.completionProposalAdapter.delayedIsPopupOpen()) {
                    if (XtextStyledTextCellEditor.this.xtextAdapter.sourceviewer.getUndoManager().undoable()) {
                        XtextStyledTextCellEditor.this.fireApplyEditorValue();
                    } else {
                        XtextStyledTextCellEditor.this.fireCancelEditor();
                    }
                }
            }
        };
        this.styledText.addListener(3005, cancelListener);
        return this.styledText;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
        this.xtextAdapter.sourceviewer.getUndoManager().reset();
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void performUndo() {
        this.xtextAdapter.sourceviewer.getUndoManager().undo();
    }

    public boolean isRedoEnabled() {
        return true;
    }

    public void performRedo() {
        this.xtextAdapter.sourceviewer.getUndoManager().redo();
    }

    public boolean isFindEnabled() {
        return true;
    }

    protected void focusLost() {
        if (this.completionProposalAdapter == null) {
            super.focusLost();
            return;
        }
        if (SWT.getPlatform().equals(GTK)) {
            if (this.ignoreNextFocusLost) {
                this.ignoreNextFocusLost = false;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        XtextStyledTextCellEditor.this.styledText.setFocus();
                    }
                });
                return;
            }
            if (this.completionProposalAdapter.isProposalPopupOpen()) {
                this.ignoreNextFocusLost = true;
                return;
            }
        }
        if (!this.completionProposalAdapter.isProposalPopupOpen()) {
            super.focusLost();
        }
    }

    public void dispose() {
        this.xtextAdapter.dispose();
        super.dispose();
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public void setVisibleRegion(int start, int length) {
        this.xtextAdapter.setVisibleRegion(start, length);
    }
}

