/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.ContextElement;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelection;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelectionFactory;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelectionPackage;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.PropertyDefinition;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.providers.DataContextPropertiesContentProvider;
import org.eclipse.papyrus.customization.properties.generation.providers.DataContextPropertiesLabelProvider;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.TernaryButton;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFieldsPage
extends AbstractCreateContextPage {
    private List<URI> targetURI;
    private List<Context> contexts;
    private Composite root;
    private FieldSelection fieldSelection;
    public int fieldColumn = -1;
    public int selectionSingleColumn = -1;
    public int selectionMultipleColumn = -1;
    public int descriptionColumn = -1;
    private int columnId = 0;

    protected SelectFieldsPage() {
        super(Messages.SelectFieldsPage_title);
    }

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        this.root.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)this.root);
        this.setPageComplete(false);
        this.setDescription(Messages.SelectFieldsPage_selectFields);
    }

    public void setContexts(List<Context> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            Activator.log.warn("Generated context is null");
            return;
        }
        this.contexts = contexts;
        this.fieldSelection = this.createNewFieldSelection();
        this.getWizard().setContexts(contexts);
        Label label = new Label(this.root, 0);
        label.setText(Messages.SelectFieldsPage_availableFields);
        TreeViewer viewer = new TreeViewer(this.root, 2048);
        Tree tree = viewer.getTree();
        tree.setBackground(tree.getDisplay().getSystemColor(1));
        tree.setLayout((Layout)new TableLayout());
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fieldColumn = this.addColumn(tree, Messages.SelectFieldsPage_field, 40, 200);
        this.selectionSingleColumn = this.addColumn(tree, Messages.SelectFieldsPage_displaySingle, 25, 120);
        this.selectionMultipleColumn = this.addColumn(tree, Messages.SelectFieldsPage_displayMultiple, 25, 120);
        this.descriptionColumn = this.addColumn(tree, Messages.SelectFieldsPage_description, 60, 300);
        tree.setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new DataContextPropertiesContentProvider(contexts));
        viewer.setLabelProvider((IBaseLabelProvider)new DataContextPropertiesLabelProvider(this));
        viewer.setInput(new Object());
        viewer.expandAll();
        this.installEditors(viewer);
        this.root.layout();
    }

    private int addColumn(Tree tree, String label, int weight, int minimumWidth) {
        TreeColumn column = new TreeColumn(tree, 0);
        column.setText(label);
        column.setResizable(true);
        ((TableLayout)tree.getLayout()).addColumnData((ColumnLayoutData)new ColumnWeightData(weight, minimumWidth));
        return this.columnId++;
    }

    private void installEditors(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.installEditors(treeItem);
            ++n2;
        }
    }

    private void installEditors(TreeItem treeItem) {
        EObject eObject = EMFHelper.getEObject((Object)treeItem.getData());
        if (eObject instanceof Property) {
            Property property = (Property)eObject;
            boolean defaultSingleValue = this.getGenerator().isSelectedSingle(property);
            boolean defaultMultipleValue = this.getGenerator().isSelectedMultiple(property);
            PropertyDefinition propertyDefinition = this.getWizard().getPropertyDefinition(this.fieldSelection, property);
            IObservableValue singleValue = EMFProperties.value((EStructuralFeature)FieldSelectionPackage.eINSTANCE.getPropertyDefinition_ValueSingle()).observe((Object)propertyDefinition);
            IObservableValue multipleValue = EMFProperties.value((EStructuralFeature)FieldSelectionPackage.eINSTANCE.getPropertyDefinition_ValueMultiple()).observe((Object)propertyDefinition);
            this.createTreeEditor(treeItem, this.selectionSingleColumn, defaultSingleValue, singleValue);
            this.createTreeEditor(treeItem, this.selectionMultipleColumn, defaultMultipleValue, multipleValue);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            this.installEditors(subItem);
            ++n2;
        }
    }

    private void createTreeEditor(TreeItem treeItem, int columnIndex, boolean defaultValue, IObservableValue observable) {
        Tree tree = treeItem.getParent();
        TernaryButton button = new TernaryButton((Composite)tree, defaultValue);
        TreeEditor editor = new TreeEditor(tree);
        editor.horizontalAlignment = 0x1000000;
        editor.grabHorizontal = true;
        editor.setEditor((Control)button, treeItem, columnIndex);
        button.setObservable(observable);
    }

    private FieldSelection createNewFieldSelection() {
        FieldSelection selection = FieldSelectionFactory.eINSTANCE.createFieldSelection();
        for (Context context : this.contexts) {
            for (DataContextRoot dataContextRoot : context.getDataContexts()) {
                ContextElement definition = this.createContextPackage((DataContextPackage)dataContextRoot);
                selection.getContextElements().add((Object)definition);
            }
        }
        return selection;
    }

    private ContextElement createContextPackage(DataContextPackage sourcePackage) {
        ContextElement element = this.createContextElement((DataContextElement)sourcePackage);
        for (DataContextElement sourceElement : sourcePackage.getElements()) {
            ContextElement subElement = sourceElement instanceof DataContextPackage ? this.createContextPackage((DataContextPackage)sourceElement) : this.createContextElement(sourceElement);
            element.getElements().add((Object)subElement);
        }
        return element;
    }

    private ContextElement createContextElement(DataContextElement sourceElement) {
        ContextElement element = FieldSelectionFactory.eINSTANCE.createContextElement();
        element.setName(sourceElement.getName());
        for (Property property : sourceElement.getProperties()) {
            PropertyDefinition propertyDefinition = FieldSelectionFactory.eINSTANCE.createPropertyDefinition();
            propertyDefinition.setName(property.getName());
            propertyDefinition.setValueSingle(TernaryButton.State.DEFAULT);
            propertyDefinition.setValueMultiple(TernaryButton.State.DEFAULT);
            element.getProperties().add((Object)propertyDefinition);
        }
        return element;
    }

    private void displayFields(DataContextElement contextElement, TreeViewer treeViewer) {
    }

    private IGenerator getGenerator() {
        return this.getWizard().generator;
    }

    public void setTargetURI(List<URI> uri) {
        this.targetURI = uri;
    }

    public void setVisible(boolean visible) {
        super.setPageComplete(true);
        super.setVisible(visible);
        if (this.contexts == null && visible) {
            this.setContexts(this.getWizard().generator.generate(this.targetURI));
        }
    }

    public FieldSelection getFieldSelection() {
        return this.fieldSelection;
    }
}

