/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.editor.DatatypeDialogCellEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLStereotypeSingleDataTypeCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.UMLStereotypeSingleDataTypeCellEditorConfiguration.dialog";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a dialog to edit a single UML datatype";
    }

    public boolean handles(Table table, Object axisElement) {
        boolean result = false;
        String id = AxisUtils.getPropertyId((Object)axisElement);
        if (id != null && id.startsWith("property_of_stereotype:/")) {
            Property prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), id);
            Type type = prop.getType();
            if (prop != null && !prop.isMultivalued()) {
                result = type instanceof DataType && !(type instanceof Enumeration) && !(type instanceof PrimitiveType);
            }
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "EDIT", configLabel);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new DatatypeDialogCellEditor(axis, modelManager.getTableAxisElementProvider()), "EDIT", configLabel);
    }
}

