/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.converter.UnlimitedNaturalDisplayConverter;
import org.eclipse.papyrus.uml.nattable.validator.UnlimitedNaturalDataValidator;
import org.eclipse.uml2.types.TypesPackage;

public class SingleUnlimitedNaturalCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.SingleUnlimitedNaturalCellEditorConfiguration.Text";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a Text Editor and a validator for a single Unlimited Natural";
    }

    public boolean handles(Table table, Object axisElement) {
        EStructuralFeature feature;
        boolean result = false;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature && !(feature = (EStructuralFeature)object).isMany()) {
            EClassifier etype = feature.getEType();
            result = etype == TypesPackage.eINSTANCE.getUnlimitedNatural();
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new UnlimitedNaturalDisplayConverter(), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new UnlimitedNaturalDataValidator(), "EDIT", configLabel);
    }
}

