/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.communication.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part.InteractionOverviewDiagramEditPart;
import org.eclipse.papyrus.uml.diagram.interactionoverview.figures.InteractionWithSnapshotFigure;
import org.eclipse.papyrus.uml.diagram.interactionoverview.part.Messages;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CallBehaviorUtil;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CreateDiagramImage;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.DiagramUtils;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.URIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallBehaviorAction;

public class CreateSnapshotForInteractionFromRefreshCommand
extends AbstractTransactionalCommand {
    protected static final String ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_TIMING = "org.eclipse.papyrus.uml.diagram.timing";
    protected static final String PAPYRUS_UML_TIMING_DIAGRAM = "PapyrusUMLTimingDiagram";
    protected View callBehaviorView;
    protected CallBehaviorAction callBehaviorAction;
    protected GraphicalEditPart host;
    protected boolean isOverrideImage;

    public CreateSnapshotForInteractionFromRefreshCommand(TransactionalEditingDomain editingDomain, View callBehaviorActionView, GraphicalEditPart host) {
        super(editingDomain, Messages.CreateSnapshotForInteractionFromRefreshCommand_CreateSnapshotForRefresh, null);
        this.callBehaviorView = callBehaviorActionView;
        this.callBehaviorAction = (CallBehaviorAction)callBehaviorActionView.getElement();
        this.host = host;
        this.isOverrideImage = false;
    }

    public boolean canExecute() {
        return true;
    }

    public static CreateSnapshotForInteractionFromRefreshCommand create(View callBehaviorActionView, GraphicalEditPart host) {
        return new CreateSnapshotForInteractionFromRefreshCommand(TransactionUtil.getEditingDomain((EObject)callBehaviorActionView.getElement()), callBehaviorActionView, host);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Behavior behavior = this.callBehaviorAction.getBehavior();
        Diagram diagram = this.findSequenceDiagram();
        ResourceSet resourceSet = behavior.eResource().getResourceSet();
        Resource newResource = null;
        Diagram cloneDiagram = null;
        try {
            GraphicalEditPart behaviorEditPart;
            IFigure borderedNodeImage;
            IFigure callActionBehaviorImage;
            newResource = resourceSet.createResource(URI.createURI((String)URIUtils.getTimestampedURI()));
            EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
            cloneDiagram = (Diagram)copier.copy((EObject)diagram);
            copier.copyReferences();
            if (cloneDiagram != null) {
                newResource.getContents().add((Object)cloneDiagram);
            }
            if ((callActionBehaviorImage = this.findInteractionWithSnapshotInFigure(borderedNodeImage = (behaviorEditPart = this.findBehaviorEditPart((EditPart)this.host, this.callBehaviorAction)).getFigure())) instanceof InteractionWithSnapshotFigure) {
                ImageFigure imageFigure = ((InteractionWithSnapshotFigure)callActionBehaviorImage).getImageFigure();
                if (this.isOverrideImage || imageFigure.getImage() == null) {
                    PreferencesHint preferenceHint = this.getReferenceHint(diagram.getType());
                    Image image = CreateDiagramImage.getDiagramImage(cloneDiagram, preferenceHint, imageFigure, this.callBehaviorView);
                    ((InteractionWithSnapshotFigure)callActionBehaviorImage).setSnapshot(image);
                    CallBehaviorUtil.setDiagramLinked(this.callBehaviorView, (View)diagram);
                }
            }
        }
        catch (Throwable throwable) {
            if (newResource != null) {
                resourceSet.getResources().remove((Object)newResource);
            }
            if (cloneDiagram != null) {
                cloneDiagram.unsetElement();
                EcoreUtil.delete(cloneDiagram, (boolean)true);
            }
            throw throwable;
        }
        if (newResource != null) {
            resourceSet.getResources().remove((Object)newResource);
        }
        if (cloneDiagram != null) {
            cloneDiagram.unsetElement();
            EcoreUtil.delete((EObject)cloneDiagram, (boolean)true);
        }
        return CommandResult.newOKCommandResult();
    }

    protected PreferencesHint getReferenceHint(String type) {
        if ("PapyrusUMLSequenceDiagram".equals(type)) {
            return org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }
        if (PAPYRUS_UML_TIMING_DIAGRAM.equals(type)) {
            return new PreferencesHint(ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_TIMING);
        }
        if (InteractionOverviewDiagramEditPart.MODEL_ID.equals(type)) {
            return Activator.DIAGRAM_PREFERENCES_HINT;
        }
        if ("PapyrusUMLCommunicationDiagram".equals(type)) {
            return UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }
        return null;
    }

    protected GraphicalEditPart findBehaviorEditPart(EditPart parentEditPart, CallBehaviorAction callBehaviorAction) {
        for (Object child : parentEditPart.getChildren()) {
            GraphicalEditPart editPartChild;
            if (!(child instanceof GraphicalEditPart) || (editPartChild = (GraphicalEditPart)child).resolveSemanticElement() != callBehaviorAction) continue;
            return editPartChild;
        }
        return null;
    }

    protected IFigure findInteractionWithSnapshotInFigure(IFigure containerFigure) {
        for (Object childFigureAsObject : containerFigure.getChildren()) {
            if (!(childFigureAsObject instanceof IFigure)) continue;
            IFigure childFigure = (IFigure)childFigureAsObject;
            if (childFigure instanceof InteractionWithSnapshotFigure) {
                return childFigure;
            }
            if (childFigure.getChildren().isEmpty()) continue;
            return this.findInteractionWithSnapshotInFigure(childFigure);
        }
        return null;
    }

    protected Diagram findSequenceDiagram() {
        String uuidDiagram = CallBehaviorUtil.getDiagramLinked(this.callBehaviorView);
        if (uuidDiagram != null && !uuidDiagram.equals("")) {
            ResourceSet resourceSet = this.callBehaviorAction.eResource().getResourceSet();
            TreeIterator ite = resourceSet.getAllContents();
            while (ite.hasNext()) {
                Diagram diagram;
                Object eObject = ite.next();
                if (!(eObject instanceof Diagram) || !uuidDiagram.equals(DiagramUtils.getUUIDForSnapshot((View)(diagram = (Diagram)eObject)))) continue;
                return diagram;
            }
        }
        return null;
    }
}

