/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RoundedRectangleBorder;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.NotVisibleBorder;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.RGBColor;

public class RoundedCompartmentFigure
extends NodeNamedElementFigure
implements IRoundedRectangleFigure {
    private Map<String, RectangleFigure> containerFigures;
    protected Dimension cornerDimension = new Dimension();
    protected boolean isOval = false;
    protected boolean isLabelConstrained = false;
    protected Dimension floatingNameOffset = new Dimension();
    protected int borderStyle = 1;
    private boolean hasHeader = false;
    private Border cachedBorder;
    private int cachedTransparency;
    private int shadowWidth = 4;
    private String shadowColor = null;
    private boolean isPackage = false;
    private boolean shadow;
    private String labelColor = null;

    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
        Border border = this.getBorder();
        if (border instanceof RoundedRectangleBorder) {
            ((RoundedRectangleBorder)border).setStyle(borderStyle);
        }
    }

    public RoundedCompartmentFigure() {
        this(null, null);
    }

    public RoundedCompartmentFigure(String taggedLabel) {
        this(null, taggedLabel);
    }

    public RoundedCompartmentFigure(List<String> compartmentFigure) {
        this(compartmentFigure, null);
    }

    public RoundedCompartmentFigure(List<String> compartmentFigure, String taggedLabelValue) {
        super(taggedLabelValue);
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new AutomaticCompartmentLayoutManager());
        if (compartmentFigure != null) {
            this.createContentPane(compartmentFigure);
        }
        this.setBorder(this.getRoundedBorder());
    }

    public void setShadowWidth(int shadowWidth) {
        this.shadowWidth = shadowWidth;
    }

    protected int getShadowWidth() {
        return this.shadowWidth;
    }

    public void setIsPackage(boolean isPackage) {
        this.isPackage = isPackage;
    }

    protected void createContentPane(List<String> compartmentFigure) {
        this.containerFigures = new HashMap<String, RectangleFigure>();
        for (String id : compartmentFigure) {
            RectangleFigure newFigure = new RectangleFigure();
            newFigure.setLayoutManager((LayoutManager)new SubCompartmentLayoutManager());
            newFigure.setFill(false);
            newFigure.setBorder(null);
            newFigure.setOutline(false);
            newFigure.setOpaque(false);
            this.add((IFigure)newFigure);
            this.containerFigures.put(id, newFigure);
        }
    }

    public RectangleFigure getCompartment(String id) {
        return this.containerFigures.get(id);
    }

    public Dimension getCornerDimensions() {
        return this.cornerDimension;
    }

    public Rectangle getRoundedRectangleBounds() {
        return this.getBounds();
    }

    @Override
    public void paintFigure(Graphics graphics) {
        Rectangle clipRectangle = new Rectangle();
        graphics.getClip(clipRectangle);
        graphics.setClip(clipRectangle.expand(2, 2));
        graphics.pushState();
        Rectangle rectangle = this.getBounds().getCopy();
        this.refreshCornerSizeWhenOval();
        this.applyTransparency(graphics);
        if (this.isPackage) {
            SVGNodePlateFigure mainFigure = (SVGNodePlateFigure)FigureUtils.findParentFigureInstance((IFigure)this, SVGNodePlateFigure.class);
            ConnectionAnchor connectionAnchor = mainFigure.getConnectionAnchor("");
            if (connectionAnchor instanceof SlidableRoundedRectangleAnchor) {
                PointList polygonPoints = ((SlidableRoundedRectangleAnchor)connectionAnchor).getPolygonPoints();
                this.translateToRelative((Translatable)polygonPoints);
                graphics.clipRect(clipRectangle.expand(1, 1));
                if (this.isShadow()) {
                    this.setShadowTransparency(graphics, true);
                    polygonPoints.translate(this.shadowWidth, this.shadowWidth);
                    clipRectangle.width += this.shadowWidth;
                    clipRectangle.height += this.shadowWidth;
                    graphics.setClip(clipRectangle);
                    graphics.setBackgroundColor(this.getColorOfShadow());
                    graphics.fillPolygon(polygonPoints);
                    polygonPoints.translate(-this.shadowWidth, -this.shadowWidth);
                    clipRectangle.width -= this.shadowWidth;
                    clipRectangle.height -= this.shadowWidth;
                    graphics.clipRect(clipRectangle);
                    this.setShadowTransparency(graphics, false);
                }
                this.fillPolygon(graphics, polygonPoints);
                graphics.setLineWidth(this.getLineWidth());
                graphics.setLineStyle(this.borderStyle);
                if (this.cachedBorder == null) {
                    this.cachedBorder = this.getBorder();
                }
                if (this.getBorder() != null && !(this.getBorder() instanceof NotVisibleBorder)) {
                    this.setBorder((Border)new NotVisibleBorder());
                }
                if (!this.noBorder) {
                    if (graphics.getLineStyle() == 6) {
                        graphics.setLineDash(this.getCustomDash());
                    }
                    graphics.drawPolyline(polygonPoints);
                }
            }
        } else {
            Border border;
            if (this.cachedBorder != null) {
                this.setBorder(this.cachedBorder);
                this.cachedBorder = null;
            }
            if (this.isShadow()) {
                this.setShadowTransparency(graphics, true);
                rectangle.translate(this.shadowWidth, this.shadowWidth);
                graphics.getClip(clipRectangle);
                clipRectangle.width += this.shadowWidth;
                clipRectangle.height += this.shadowWidth;
                graphics.setClip(clipRectangle);
                graphics.setBackgroundColor(this.getColorOfShadow());
                graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
                rectangle.translate(-this.shadowWidth, -this.shadowWidth);
                clipRectangle.width -= this.shadowWidth;
                clipRectangle.height -= this.shadowWidth;
                graphics.clipRect(clipRectangle);
                this.setShadowTransparency(graphics, false);
            }
            this.fillRoundedRectangle(graphics, rectangle, this.cornerDimension.width, this.cornerDimension.height);
            if (this.hasHeader) {
                PointList header = this.getHeader();
                graphics.drawPolyline(header);
                Path path = new Path(null);
                path.moveTo((float)(this.getBounds().x + this.cornerDimension.width / 2), (float)this.getBounds().y);
                int i = 0;
                while (i < header.size()) {
                    path.lineTo((float)header.getPoint((int)i).x, (float)header.getPoint((int)i).y);
                    ++i;
                }
                path.lineTo((float)this.getBounds().x, (float)(header.getPoint((int)(header.size() - 1)).y + this.cornerDimension.height / 2));
                path.addArc((float)this.getBounds().x, (float)this.getBounds().y, (float)this.cornerDimension.width, (float)this.cornerDimension.height, 180.0f, -90.0f);
                graphics.pushState();
                graphics.clipPath(path);
                this.paintName(graphics);
                graphics.popState();
                path.dispose();
            }
            if ((border = this.getBorder()) instanceof RoundedRectangleBorder) {
                ((RoundedRectangleBorder)border).setArcHeight(this.cornerDimension.height);
                ((RoundedRectangleBorder)border).setArcWidth(this.cornerDimension.width);
                ((RoundedRectangleBorder)border).setWidth(this.getLineWidth());
                ((RoundedRectangleBorder)border).setStyle(this.borderStyle);
            }
        }
        graphics.popState();
    }

    protected void fillPolygon(Graphics graphics, PointList polygonPoints) {
        graphics.pushState();
        Path path = new Path(null);
        path.moveTo((float)polygonPoints.getPoint((int)0).x, (float)polygonPoints.getPoint((int)0).y);
        int i = 1;
        while (i < polygonPoints.size()) {
            path.lineTo((float)polygonPoints.getPoint((int)i).x, (float)polygonPoints.getPoint((int)i).y);
            ++i;
        }
        path.close();
        graphics.clipPath(path);
        if (!this.isUsingGradient()) {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getBackgroundColor());
            graphics.fillPath(path);
        } else {
            graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            graphics.fillGradient(this.getBounds(), this.getGradientStyle() == 0);
        }
        if (!this.hasHeader || this.isPackage) {
            this.paintName(graphics);
        }
        path.dispose();
        graphics.popState();
    }

    protected void fillRoundedRectangle(Graphics graphics, Rectangle rectangle, int arcWidths, int arcHeights) {
        graphics.pushState();
        Rectangle rect = rectangle.getCopy();
        Dimension arc = new Dimension(arcWidths, arcHeights);
        Path path = new Path(null);
        rect.setWidth(rect.width - 1);
        rect.setHeight(rect.height - 1);
        if (this.isOval) {
            arc.width = rect.width;
            arc.height = rect.height;
        } else {
            if (rect.width < arc.width) {
                arc.width = rect.width;
            }
            if (rect.height < arc.height) {
                arc.height = rect.height;
            }
        }
        path.moveTo((float)(rect.x + arc.width / 2), (float)rect.y);
        path.lineTo((float)(rect.x + rect.width - arc.width / 2), (float)rect.y);
        path.addArc((float)(rect.x + rect.width - arc.width), (float)rect.y, (float)arc.width, (float)arc.height, 90.0f, -90.0f);
        path.lineTo((float)(rect.x + rect.width), (float)(rect.y + rect.height - arc.height / 2));
        path.addArc((float)(rect.x + rect.width - arc.width), (float)(rect.y + rect.height - arc.height), (float)arc.width, (float)arc.height, 0.0f, -90.0f);
        path.lineTo((float)(rect.x + arc.width / 2), (float)(rect.y + rect.height));
        path.addArc((float)rect.x, (float)(rect.y + rect.height - arc.height), (float)arc.width, (float)arc.height, -90.0f, -90.0f);
        path.lineTo((float)rect.x, (float)(rect.y + arc.height / 2));
        path.addArc((float)rect.x, (float)rect.y, (float)arc.width, (float)arc.height, 180.0f, -90.0f);
        if (!this.isUsingGradient()) {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getBackgroundColor());
        } else {
            graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
        }
        graphics.clipPath(path);
        graphics.fillGradient(this.getBounds(), this.getGradientStyle() == 0);
        if (!this.hasHeader) {
            this.paintName(graphics);
        }
        graphics.popState();
        path.dispose();
    }

    protected void paintName(Graphics graphics) {
        if (this.getColorOfLabelBackground() != null) {
            Rectangle nameBounds = new Rectangle(this.getLocation(), this.getLabelsDimension());
            nameBounds.y -= nameBounds.height;
            nameBounds.height *= 2;
            nameBounds.width = this.getBounds().width;
            if (this.isUsingGradient()) {
                graphics.setForegroundColor(ColorConstants.white);
            } else {
                graphics.setForegroundColor(this.getColorOfLabelBackground());
            }
            graphics.setBackgroundColor(this.getColorOfLabelBackground());
            graphics.fillGradient(nameBounds, this.getGradientStyle() == 0);
        }
    }

    protected Color getColorOfShadow() {
        Color color = this.stringToColor(this.shadowColor);
        return color != null ? color : this.getForegroundColor();
    }

    protected Color getColorOfLabelBackground() {
        return this.stringToColor(this.labelColor);
    }

    private Color stringToColor(String stringColor) {
        Color color = null;
        if (stringColor != null && !"-1".equals(stringColor)) {
            RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)stringColor);
            if (rgbColor != null) {
                int red = Integer.parseInt(rgbColor.getRed().toString());
                int green = Integer.parseInt(rgbColor.getGreen().toString());
                int blue = Integer.parseInt(rgbColor.getBlue().toString());
                color = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
            }
            if (color == null) {
                try {
                    color = ColorRegistry.getInstance().getColor(Integer.valueOf(stringColor));
                }
                catch (NumberFormatException e) {
                    Activator.log.error("Shadow Color not well set", (Throwable)e);
                }
            }
        }
        return color;
    }

    private void setShadowTransparency(Graphics graphics, boolean toApplied) {
        if (toApplied) {
            this.cachedTransparency = this.getTransparency();
            int transparency = this.cachedTransparency + (100 - this.cachedTransparency) / 2;
            if (transparency > 100) {
                transparency = 100;
            }
            graphics.setAlpha(255 - transparency * 255 / 100);
        } else {
            graphics.setAlpha(255 - this.cachedTransparency * 255 / 100);
        }
    }

    @Override
    public boolean isShadow() {
        return this.shadow;
    }

    @Override
    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    protected PointList getHeader() {
        PointList points = new PointList();
        Rectangle labelBounds = new Rectangle(this.getLocation(), this.getLabelsDimension());
        if (labelBounds.width <= 0) {
            labelBounds.width = this.getBounds().width / 4;
        }
        Point verticalStart = new Point();
        Point verticalEnd = new Point();
        Point diagonalStart = new Point();
        Point diagonalEnd = new Point();
        Point horizontalStart = new Point();
        Point horizontalEnd = new Point();
        verticalStart.x = labelBounds.x + labelBounds.width + 10;
        verticalStart.y = this.getBounds().y;
        points.addPoint(verticalStart);
        verticalEnd.x = verticalStart.x;
        verticalEnd.y = verticalStart.y + labelBounds.height / 2 + 3;
        points.addPoint(verticalEnd);
        diagonalStart.x = verticalEnd.x;
        diagonalStart.y = verticalEnd.y;
        points.addPoint(diagonalStart);
        diagonalEnd.x = diagonalStart.x - labelBounds.height / 2 + 3;
        diagonalEnd.y = labelBounds.y + labelBounds.height - 1;
        points.addPoint(diagonalEnd);
        horizontalStart.x = diagonalEnd.x;
        horizontalStart.y = diagonalEnd.y;
        points.addPoint(horizontalStart);
        horizontalEnd.x = labelBounds.x;
        horizontalEnd.y = horizontalStart.y;
        points.addPoint(horizontalEnd);
        return points;
    }

    private Border getRoundedBorder() {
        this.refreshCornerSizeWhenOval();
        RoundedRectangleBorder border = new RoundedRectangleBorder(this.cornerDimension.width, this.cornerDimension.height){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                int transparency = 255 - ((NodeFigure)figure).getTransparency() * 255 / 100;
                graphics.setAlpha(transparency);
                if (this.getStyle() == 6) {
                    graphics.setLineDash(RoundedCompartmentFigure.this.getCustomDash());
                }
                super.paint(figure, graphics, insets);
            }
        };
        return border;
    }

    private void refreshCornerSizeWhenOval() {
        if (this.isOval && (this.cornerDimension.width != this.getBounds().width || this.cornerDimension.height != this.getBounds().height)) {
            this.cornerDimension.width = this.getBounds().width;
            this.cornerDimension.height = this.getBounds().height;
        }
    }

    public Rectangle getPackageHeader() {
        Rectangle headerBound = new Rectangle();
        if (this.isPackage) {
            headerBound.setBounds(this.getLocation(), this.getLabelsDimension());
            if (-1 == headerBound.width) {
                headerBound.width = 60;
            }
            headerBound.width = Math.min(headerBound.width, this.getBounds().width);
        }
        return headerBound;
    }

    public void setCornerDimensions(Dimension cornerDimension) {
        this.cornerDimension = cornerDimension.width == 0 || cornerDimension.height == 0 ? new Dimension() : cornerDimension;
    }

    public void setOval(boolean booleanValue) {
        this.isOval = booleanValue;
        if (booleanValue) {
            this.refreshCornerSizeWhenOval();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setFloatingNameConstrained(boolean booleanValue) {
        this.isLabelConstrained = booleanValue;
    }

    public boolean isFloatingNameConstrained() {
        return this.isLabelConstrained;
    }

    public void setFloatingNameOffset(Dimension offset) {
        this.floatingNameOffset = offset;
    }

    public Dimension getFloatingNameOffset() {
        return this.floatingNameOffset;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    protected Dimension getLabelsDimension() {
        ResizableCompartmentFigure firstCompartment;
        Dimension labelDimension = new Dimension(-1, -1);
        if (this.nameLabel != null && labelDimension.width < this.nameLabel.getPreferredSize().width) {
            labelDimension.width = this.nameLabel.getPreferredSize().width;
        }
        if (this.taggedLabel != null && labelDimension.width < this.taggedLabel.getPreferredSize().width) {
            labelDimension.width = this.taggedLabel.getPreferredSize().width;
        }
        if (this.stereotypesLabel != null && labelDimension.width < this.stereotypesLabel.getPreferredSize().width) {
            labelDimension.width = this.stereotypesLabel.getPreferredSize().width;
        }
        if (this.stereotypePropertiesInBraceContent != null && labelDimension.width < this.stereotypePropertiesInBraceContent.getPreferredSize().width) {
            labelDimension.width = this.stereotypePropertiesInBraceContent.getPreferredSize().width;
        }
        if (this.qualifiedLabel != null && labelDimension.width < this.qualifiedLabel.getPreferredSize().width) {
            labelDimension.width = this.qualifiedLabel.getPreferredSize().width;
        }
        if ((firstCompartment = (ResizableCompartmentFigure)FigureUtils.findChildFigureInstance((IFigure)this, ResizableCompartmentFigure.class)) != null) {
            labelDimension.height = firstCompartment.getBounds().y - this.getBounds().y;
        }
        return labelDimension;
    }

    public String getNameBackgroundColor() {
        return this.labelColor;
    }

    public void setNameBackgroundColor(String labelBackgroundColor) {
        this.labelColor = labelBackgroundColor;
    }
}

