/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.ObjectFlowUtil;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";
    private final IElementType myElementType;

    protected UMLBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            String id = UMLVisualIDRegistry.getVisualID((View)view);
            request.getExtendedData().put(VISUAL_ID_KEY, id);
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, view);
        }
        return super.getCommand(request);
    }

    protected String getVisualID(IEditCommandRequest request) {
        return (String)request.getParameter(VISUAL_ID_KEY);
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        IElementType requestContextElementType;
        if (this.requestIsDisabled(request)) {
            return null;
        }
        if (request instanceof ReorientRelationshipRequest) {
            return editPolicyCommand;
        }
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        if ((requestContextElementType = this.getContextElementType(request)) != null) {
            request.setParameter("context element type", (Object)requestContextElementType);
            ICommand command = requestContextElementType.getEditCommand(request);
            request.setParameter("edit policy command", null);
            request.setParameter("context element type", null);
            if (command != null) {
                if (!(command instanceof CompositeTransactionalCommand)) {
                    command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
                }
                return new ICommandProxy(command);
            }
        }
        return editPolicyCommand;
    }

    private boolean requestIsDisabled(IEditCommandRequest request) {
        if (request instanceof MoveRequest) {
            for (Object element : ((MoveRequest)request).getElementsToMove().keySet()) {
                if (!(element instanceof Constraint)) continue;
                return true;
            }
        }
        return false;
    }

    protected IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = UMLElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((EObject)((IGraphicalEditPart)this.getHost()).resolveSemanticElement());
        if (req.getElementType() != null) {
            commandService = ElementEditServiceUtils.getCommandProvider((Object)req.getElementType(), (IClientContext)req.getClientContext());
        }
        if (commandService == null) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        ICommand semanticCommand = commandService.getEditCommand((IEditCommandRequest)req);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return this.getGEFWrapper(semanticCommand);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        ICommand command;
        IElementEditService commandProvider;
        IElementType requestElementType = req.getElementType();
        if (requestElementType instanceof IElementType && (commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)req.getContainer())) != null && (command = commandProvider.getEditCommand((IEditCommandRequest)req)) != null && command.canExecute()) {
            return new ICommandProxy(command);
        }
        return null;
    }

    protected ICommand getSemanticCreationCommand(CreateElementRequest req) {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((EObject)req.getContainer());
        if (commandService == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return commandService.getEditCommand((IEditCommandRequest)req);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        EObject targetCEObject = req.getTargetContainer();
        if (targetCEObject != null) {
            ICommand moveCommand;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetCEObject);
            if (provider != null && (moveCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
                return new ICommandProxy(moveCommand);
            }
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return this.getGEFWrapper((ICommand)new MoveElementsCommand(req));
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return cmd == null ? org.eclipse.gef.commands.UnexecutableCommand.INSTANCE : new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static LinkConstraints getLinkConstraints() {
        LinkConstraints cached = UMLDiagramEditorPlugin.getInstance().getLinkConstraints();
        if (cached == null) {
            cached = new LinkConstraints();
            UMLDiagramEditorPlugin.getInstance().setLinkConstraints(cached);
        }
        return cached;
    }

    public static class LinkConstraints {
        public boolean canCreateAction_LocalPreconditionEdge(Action source, Constraint target) {
            if (source != null) {
                if (source.getLocalPreconditions().contains((Object)target)) {
                    return false;
                }
                if (source == target) {
                    return false;
                }
            }
            return this.canExistAction_LocalPreconditionEdge(source, target);
        }

        public boolean canCreateAction_LocalPostconditionEdge(Action source, Constraint target) {
            if (source != null) {
                if (source.getLocalPostconditions().contains((Object)target)) {
                    return false;
                }
                if (source == target) {
                    return false;
                }
            }
            return this.canExistAction_LocalPostconditionEdge(source, target);
        }

        public boolean canCreateObjectFlow_Edge(Activity container, ActivityNode source, ActivityNode target) {
            return this.canExistObjectFlow_Edge(container, null, source, target);
        }

        public boolean canCreateControlFlow_Edge(Activity container, ActivityNode source, ActivityNode target) {
            return this.canExistControlFlow_Edge(container, null, source, target);
        }

        public boolean canCreateExceptionHandler_Edge(ExecutableNode container, ExecutableNode source, ObjectNode target) {
            return this.canExistExceptionHandler_Edge(container, null, source, target);
        }

        public boolean canCreateComment_AnnotatedElementEdge(Comment source, Element target) {
            if (source != null && source.getAnnotatedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistComment_AnnotatedElementEdge(source, target);
        }

        public boolean canCreateConstraint_ConstrainedElementEdge(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraint_ConstrainedElementEdge(source, target);
        }

        public boolean canExistAction_LocalPreconditionEdge(Action source, Constraint target) {
            return true;
        }

        public boolean canExistAction_LocalPostconditionEdge(Action source, Constraint target) {
            return true;
        }

        public boolean canExistObjectFlow_Edge(Activity container, ObjectFlow linkInstance, ActivityNode source, ActivityNode target) {
            try {
                return ObjectFlowUtil.canExistObjectFlow((Activity)container, (ObjectFlow)linkInstance, (ActivityNode)source, (ActivityNode)target);
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }

        public boolean canExistControlFlow_Edge(Activity container, ControlFlow linkInstance, ActivityNode source, ActivityNode target) {
            block39: {
                ActivityEdge outgoingObjectFlow;
                block40: {
                    block38: {
                        block36: {
                            block37: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block30: {
                                                    ActivityEdge incomingObjectFlow;
                                                    block31: {
                                                        block29: {
                                                            block27: {
                                                                block28: {
                                                                    block26: {
                                                                        block25: {
                                                                            block24: {
                                                                                if (!(source instanceof ObjectNode) || ((ObjectNode)source).isControlType()) break block24;
                                                                                return false;
                                                                            }
                                                                            if (!(source instanceof InputPin)) break block25;
                                                                            if (source.getOwner() instanceof StructuredActivityNode) {
                                                                                if (target != null && !source.getOwner().equals(target.getInStructuredNode())) {
                                                                                    return false;
                                                                                }
                                                                                break block25;
                                                                            }
                                                                            return false;
                                                                        }
                                                                        if (!(source instanceof FinalNode)) break block26;
                                                                        return false;
                                                                    }
                                                                    if (!(source instanceof JoinNode)) break block27;
                                                                    if (source.getOutgoings().isEmpty()) break block28;
                                                                    return false;
                                                                }
                                                                ActivityEdge incomingObjectFlow2 = source.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                                if (incomingObjectFlow2 == null) break block27;
                                                                return false;
                                                            }
                                                            if (!(source instanceof ForkNode)) break block29;
                                                            outgoingObjectFlow = source.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                            incomingObjectFlow = source.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                            if (outgoingObjectFlow == null && incomingObjectFlow == null) break block29;
                                                            return false;
                                                        }
                                                        if (!(source instanceof MergeNode)) break block30;
                                                        if (source.getOutgoings().isEmpty()) break block31;
                                                        return false;
                                                    }
                                                    outgoingObjectFlow = source.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                    incomingObjectFlow = source.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                    if (outgoingObjectFlow == null && incomingObjectFlow == null) break block30;
                                                    return false;
                                                }
                                                if (!(source instanceof DecisionNode)) break block32;
                                                outgoingObjectFlow = source.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                                                int incomingObjectFlowNumber = 0;
                                                for (ActivityEdge incomingEdge : source.getIncomings()) {
                                                    if (!(incomingEdge instanceof ObjectFlow)) continue;
                                                    ++incomingObjectFlowNumber;
                                                }
                                                if (outgoingObjectFlow == null && incomingObjectFlowNumber <= true) break block32;
                                                return false;
                                            }
                                            if (!(target instanceof ObjectNode) || ((ObjectNode)target).isControlType()) break block33;
                                            return false;
                                        }
                                        if (!(target instanceof OutputPin)) break block34;
                                        if (target.getOwner() instanceof StructuredActivityNode) {
                                            if (source != null && !target.getOwner().equals(source.getInStructuredNode())) {
                                                return false;
                                            }
                                            break block34;
                                        }
                                        return false;
                                    }
                                    if (!(target instanceof InitialNode)) break block35;
                                    return false;
                                }
                                if (!(target instanceof ForkNode)) break block36;
                                if (target.getIncomings().isEmpty()) break block37;
                                return false;
                            }
                            outgoingObjectFlow = target.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                            ActivityEdge incomingObjectFlow = target.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                            if (outgoingObjectFlow == null && incomingObjectFlow == null) break block36;
                            return false;
                        }
                        if (!(target instanceof MergeNode)) break block38;
                        outgoingObjectFlow = target.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                        ActivityEdge incomingObjectFlow = target.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                        if (outgoingObjectFlow == null && incomingObjectFlow == null) break block38;
                        return false;
                    }
                    if (!(target instanceof DecisionNode)) break block39;
                    if (target.getIncomings().size() < 2) break block40;
                    return false;
                }
                try {
                    outgoingObjectFlow = target.getOutgoing(null, true, UMLPackage.eINSTANCE.getObjectFlow());
                    ActivityEdge incomingObjectFlow = null;
                    for (ActivityEdge incomingEdge : target.getIncomings()) {
                        if (!(incomingEdge instanceof ObjectFlow) || incomingEdge == ((DecisionNode)target).getDecisionInputFlow()) continue;
                        incomingObjectFlow = incomingEdge;
                    }
                    if (outgoingObjectFlow == null && incomingObjectFlow == null) break block39;
                    return false;
                }
                catch (Exception e) {
                    UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    return false;
                }
            }
            return true;
        }

        public boolean canExistExceptionHandler_Edge(ExecutableNode container, ExceptionHandler linkInstance, ExecutableNode source, ObjectNode target) {
            return true;
        }

        public boolean canExistComment_AnnotatedElementEdge(Comment source, Element target) {
            return true;
        }

        public boolean canExistConstraint_ConstrainedElementEdge(Constraint source, Element target) {
            return true;
        }
    }
}

