/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusSpanningDataLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.DefaultSizeUtils;
import org.eclipse.papyrus.infra.nattable.utils.PercentageCalculationUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.InputDialogWithLocation;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractAxisManager
implements IAxisManager {
    protected AxisManagerRepresentation representedAxisManager;
    private AbstractAxisProvider representedContentProvider;
    protected INattableModelManager tableManager;
    protected Adapter axisListener;
    private EObject tableContext;
    protected final List<Object> managedObject = this.createManagedObjectList();

    protected List<Object> createManagedObjectList() {
        return new ArrayList<Object>();
    }

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        this.tableManager = manager;
        this.representedAxisManager = rep;
        this.representedContentProvider = provider;
        this.tableContext = manager.getTable().getContext();
        this.initializeManagedObjectList();
        this.addListeners();
    }

    protected void addListeners() {
        this.axisListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                AbstractAxisManager.this.axisManagerHasChanged(notification);
            }
        };
        this.representedContentProvider.eAdapters().add((Object)this.axisListener);
    }

    protected void axisManagerHasChanged(Notification notification) {
    }

    protected void initializeManagedObjectList() {
    }

    @Override
    public boolean canBeSavedAsConfig() {
        return false;
    }

    @Override
    public NattableModelManager getTableManager() {
        return (NattableModelManager)this.tableManager;
    }

    @Override
    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (Object object : objectsToAdd) {
            if (!this.isAllowedContents(object) || this.isAlreadyManaged(object)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.removeListeners();
        this.tableContext = null;
        this.tableManager = null;
        this.representedAxisManager = null;
        this.representedContentProvider = null;
        if (this.managedObject != null) {
            this.managedObject.clear();
        }
    }

    protected void removeListeners() {
        if (this.axisListener != null) {
            this.representedContentProvider.eAdapters().remove((Object)this.axisListener);
            this.axisListener = null;
        }
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        return true;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        return true;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        return null;
    }

    @Override
    public Command getInsertAxisCommand(Collection<Object> objectsToAdd, int index) {
        return null;
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        return null;
    }

    @Override
    public AbstractAxisProvider getRepresentedContentProvider() {
        return this.representedContentProvider;
    }

    @Override
    public void setHeaderDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    @Override
    public boolean isAllowedContents(Object object) {
        return true;
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        return this.managedObject.contains(object);
    }

    @Override
    public boolean canMoveAxis() {
        return true;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return null;
    }

    @Override
    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToDestroy) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.getRepresentedContentProvider());
        ArrayList<Object> objectsToRemove = new ArrayList<Object>(objectToDestroy.size());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager || !objectToDestroy.contains(current) && !objectToDestroy.contains(current.getElement())) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            if (current instanceof IAxis) {
                objectsToRemove.add(current.getElement());
                continue;
            }
            objectsToRemove.add(current);
        }
        if (!compositeCommand.isEmpty()) {
            return new RemoveCommandWrapper((Command)new GMFtoEMFCommandWrapper((ICommand)compositeCommand), objectsToRemove);
        }
        return null;
    }

    protected final EObject getTableContext() {
        return this.tableContext;
    }

    @Override
    public List<Object> getAllManagedAxis() {
        ArrayList<Object> eObjects = new ArrayList<Object>();
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager) continue;
            eObjects.add(current.getElement());
        }
        return eObjects;
    }

    protected TransactionalEditingDomain getTableEditingDomain() {
        ServicesRegistry registry = null;
        if (this.getTableManager() != null && this.getTableManager().getTable() != null && this.getTableManager().getTable().eResource() != null) {
            try {
                registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getTableManager().getTable());
                return (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
            }
            catch (ServiceException e) {
                Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            }
        }
        return null;
    }

    protected TransactionalEditingDomain getContextEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.getTableContext());
            return (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
    }

    @Override
    public void openEditAxisAliasDialog(NatEventData event, int axisPosition) {
        IAxis axis = (IAxis)this.representedContentProvider.getAxis().get(axisPosition);
        String alias = axis.getAlias();
        if (alias == null) {
            alias = "";
        }
        String dialogMessage = String.format(Messages.AbstractAxisManager_InputDialogMessage, this.getElementAxisName(axis));
        Point location = new Point(event.getOriginalEvent().x, event.getOriginalEvent().y);
        NatTable natTable = event.getNatTable();
        location = natTable.toDisplay(location);
        InputDialogWithLocation dialog = new InputDialogWithLocation(Display.getDefault().getActiveShell(), Messages.AbstractAxisManager_InputDialogTitle, dialogMessage, alias, null, location);
        int result = dialog.open();
        if (result == 0) {
            String newAlias = dialog.getText();
            if ("".equals(newAlias)) {
                newAlias = null;
            }
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            SetRequest request = new SetRequest(domain, (EObject)axis, (EStructuralFeature)NattableaxisPackage.eINSTANCE.getIAxis_Alias(), (Object)newAlias);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)axis);
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisManagerRepresentation getAxisManagerRepresentation() {
        return this.representedAxisManager;
    }

    @Override
    public boolean canEditAxisHeader() {
        return false;
    }

    @Override
    public boolean canDestroyAxis(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxis(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDestroyAxisElement(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxisElement(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void destroyAxis(List<Integer> axisPositions) {
        List<Object> toDestroy = this.getElements(axisPositions);
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        ArrayList<Object> objectsToRemove = new ArrayList<Object>(toDestroy.size());
        for (Object objectToDestroy : toDestroy) {
            if (objectToDestroy instanceof IAxis) {
                objectsToRemove.add(((IAxis)objectToDestroy).getElement());
                continue;
            }
            objectsToRemove.add(objectToDestroy);
        }
        Command cmd = this.getDestroyAxisCommand(domain, objectsToRemove);
        domain.getCommandStack().execute(cmd);
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        return !this.isDynamic();
    }

    protected List<Object> getElements(List<Integer> axisPositions) {
        List<Object> elements = this.getElements();
        ArrayList<Object> toDestroy = new ArrayList<Object>();
        for (Integer position : axisPositions) {
            Object element = elements.get(position);
            toDestroy.add(element);
        }
        return toDestroy;
    }

    @Override
    public void destroyAxisElement(List<Integer> axisPosition) {
        CompoundCommand cmd = new CompoundCommand("Destroy Axis Element Command");
        TransactionalEditingDomain domain = this.getContextEditingDomain();
        for (Integer integer : axisPosition) {
            cmd.append(this.getDestroyAxisElementCommand(domain, integer));
        }
        domain.getCommandStack().execute((Command)cmd);
    }

    protected final List<Object> getElements() {
        if (this.isUsedAsColumnManager()) {
            return this.tableManager.getColumnElementsList();
        }
        return this.tableManager.getRowElementsList();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public final boolean isUsedAsColumnManager() {
        Table table = this.getTableManager().getTable();
        AbstractAxisProvider columnAxisProvider = table.isInvertAxis() ? table.getCurrentRowAxisProvider() : table.getCurrentColumnAxisProvider();
        return columnAxisProvider == this.getRepresentedContentProvider();
    }

    protected class AddCommandWrapper
    extends ReorderAxisCommandWrapper {
        private Collection<Object> objectsToAdd;

        public AddCommandWrapper(Command command, Collection<Object> objectsToAdd) {
            super(command);
            this.objectsToAdd = objectsToAdd;
        }

        @Override
        public void execute() {
            super.execute();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.addAll(this.objectsToAdd);
            }
        }

        @Override
        public void undo() {
            super.undo();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.removeAll(this.objectsToAdd);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.addAll(this.objectsToAdd);
            }
        }
    }

    protected class RemoveCommandWrapper
    extends ReorderAxisCommandWrapper {
        private Collection<Object> objectsToRemove;

        public RemoveCommandWrapper(Command command, Collection<Object> objectsToRemove) {
            super(command);
            if (AbstractAxisManager.this.managedObject != null) {
                this.objectsToRemove = objectsToRemove;
            }
        }

        @Override
        public void execute() {
            super.execute();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.removeAll(this.objectsToRemove);
            }
        }

        @Override
        public void undo() {
            super.undo();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.addAll(this.objectsToRemove);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (AbstractAxisManager.this.managedObject != null) {
                AbstractAxisManager.this.managedObject.removeAll(this.objectsToRemove);
            }
        }
    }

    protected class ReorderAxisCommandWrapper
    extends CommandWrapper {
        private final boolean isRowsReordering;

        public ReorderAxisCommandWrapper(Command command) {
            this(command, false);
        }

        public ReorderAxisCommandWrapper(Command command, boolean isRowsReordering) {
            super(command);
            this.isRowsReordering = isRowsReordering;
        }

        public void execute() {
            super.execute();
            this.reInitializeColumnsWidth();
        }

        public void undo() {
            super.undo();
            this.reInitializeColumnsWidth();
        }

        public void redo() {
            super.redo();
            this.reInitializeColumnsWidth();
        }

        protected void reInitializeColumnsWidth() {
            EList notationAxisList = this.isRowsReordering && !AbstractAxisManager.this.tableManager.getTable().isInvertAxis() || !this.isRowsReordering && AbstractAxisManager.this.tableManager.getTable().isInvertAxis() ? AbstractAxisManager.this.tableManager.getTable().getCurrentRowAxisProvider().getAxis() : AbstractAxisManager.this.tableManager.getTable().getCurrentColumnAxisProvider().getAxis();
            BodyLayerStack bodyLayerStack = AbstractAxisManager.this.tableManager.getBodyLayerStack();
            if (bodyLayerStack != null) {
                DataLayer tableBodyLayer = bodyLayerStack.getBodyDataLayer();
                BooleanValueStyle columnsWidthAsPercentage = (BooleanValueStyle)AbstractAxisManager.this.tableManager.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
                if (columnsWidthAsPercentage == null) {
                    TableConfiguration config = AbstractAxisManager.this.tableManager.getTable().getTableConfiguration();
                    columnsWidthAsPercentage = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
                }
                boolean isUsedPercentage = columnsWidthAsPercentage != null && columnsWidthAsPercentage.isBooleanValue();
                HashSet<Integer> notManagedIndexAxisWidth = new HashSet<Integer>();
                int remainingPercentage = 100;
                int index = 0;
                while (index < notationAxisList.size()) {
                    IAxis currentAxis = (IAxis)notationAxisList.get(index);
                    if (!AbstractAxisManager.this.tableManager.getTable().isInvertAxis()) {
                        IntValueStyle value;
                        if (this.isRowsReordering) {
                            int axisHeight = tableBodyLayer.getRowHeightByPosition(index);
                            value = (IntValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisHeight");
                            if (value != null) {
                                tableBodyLayer.setRowHeightByPosition(index, value.getIntValue(), false);
                            } else if (axisHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                                tableBodyLayer.setRowHeightByPosition(index, DefaultSizeUtils.getDefaultCellHeight(), false);
                            }
                        } else {
                            int axisWidth = tableBodyLayer.getColumnWidthByPosition(index);
                            value = (IntValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisWidth");
                            if (value != null) {
                                if (isUsedPercentage) {
                                    ((PapyrusSpanningDataLayer)tableBodyLayer).setColumnWidthPercentageByPosition(index, value.getIntValue());
                                    remainingPercentage -= value.getIntValue();
                                } else {
                                    tableBodyLayer.setColumnWidthByPosition(index, value.getIntValue(), false);
                                }
                            } else if (axisWidth != DefaultSizeUtils.getDefaultCellWidth() && !isUsedPercentage) {
                                tableBodyLayer.setColumnWidthByPosition(index, DefaultSizeUtils.getDefaultCellWidth(), false);
                            } else if (isUsedPercentage) {
                                notManagedIndexAxisWidth.add(index);
                            }
                        }
                    }
                    ++index;
                }
                int numberIndex = 0;
                Iterator iterator = notManagedIndexAxisWidth.iterator();
                while (iterator.hasNext()) {
                    int index2 = (Integer)iterator.next();
                    ((PapyrusSpanningDataLayer)tableBodyLayer).setColumnWidthPercentageByPosition(index2, PercentageCalculationUtils.calculatePercentageToSet(numberIndex, remainingPercentage, notManagedIndexAxisWidth.size()), false);
                    ++numberIndex;
                }
            }
        }
    }
}

