/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ConnectionAssistantRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private UML _uML;
    private final HashMap<ArrayList<?>, ConnectionAssistant> _createCache_toConnectionAssistant = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionAssistant toConnectionAssistant(ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        ConnectionAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, basetype});
        HashMap<ArrayList<?>, ConnectionAssistant> hashMap = this._createCache_toConnectionAssistant;
        synchronized (hashMap) {
            ConnectionAssistant _createConnectionAssistant;
            if (this._createCache_toConnectionAssistant.containsKey(_cacheKey)) {
                return this._createCache_toConnectionAssistant.get(_cacheKey);
            }
            _result = _createConnectionAssistant = assistantFactory.createConnectionAssistant();
            this._createCache_toConnectionAssistant.put(_cacheKey, _result);
        }
        this._init_toConnectionAssistant(_result, umlExtension, basetype);
        return _result;
    }

    private void _init_toConnectionAssistant(ConnectionAssistant it, ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        it.setElementTypeID(this._identifiers.toElementTypeID(umlExtension, basetype));
        it.setOwnedSourceFilter(this._filtersUtil.andProfileApplied(this._filtersUtil.reduce(this.createPossibleSourcesFilter(basetype, umlExtension)), this._uML.getProfile((Object)umlExtension)));
        it.setOwnedTargetFilter(this._filtersUtil.andProfileApplied(this._filtersUtil.reduce(this.createPossibleTargetsFilter(basetype, umlExtension)), this._uML.getProfile((Object)umlExtension)));
    }

    private Filter createPossibleSourcesFilter(ElementTypeConfiguration basetype, ImpliedExtension umlExtension) {
        Functions.Function1 _function = it -> {
            boolean _isRelationship = this._uMLElementTypes.isRelationship(it);
            return !_isRelationship;
        };
        Functions.Function2 _function_1 = (filter, elementType) -> {
            Filter _xifexpression = null;
            boolean _canSourceToType = this._uMLElementTypes.canSourceToType(elementType, basetype);
            if (_canSourceToType) {
                ElementTypeFilter _filter = this._filtersUtil.toFilter((ElementTypeConfiguration)elementType, this._uML.getProfile((Object)umlExtension));
                _xifexpression = this._filtersUtil.operator_or((Filter)filter, (Filter)_filter);
            } else {
                _xifexpression = filter;
            }
            return _xifexpression;
        };
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)this._uMLElementTypes.getBaseElementTypes(), (Functions.Function1)_function), null, (Functions.Function2)_function_1);
    }

    private Filter createPossibleTargetsFilter(ElementTypeConfiguration basetype, ImpliedExtension umlExtension) {
        Functions.Function1 _function = it -> {
            boolean _isRelationship = this._uMLElementTypes.isRelationship(it);
            return !_isRelationship;
        };
        Functions.Function2 _function_1 = (filter, elementType) -> {
            Filter _xifexpression = null;
            boolean _canTargetFromType = this._uMLElementTypes.canTargetFromType(elementType, basetype);
            if (_canTargetFromType) {
                ElementTypeFilter _filter = this._filtersUtil.toFilter((ElementTypeConfiguration)elementType, this._uML.getProfile((Object)umlExtension));
                _xifexpression = this._filtersUtil.operator_or((Filter)filter, (Filter)_filter);
            } else {
                _xifexpression = filter;
            }
            return _xifexpression;
        };
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)this._uMLElementTypes.getBaseElementTypes(), (Functions.Function1)_function), null, (Functions.Function2)_function_1);
    }
}

