/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.toolsmiths.validation.common.command.TouchResourceCommand;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionGenerator;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.SimpleMissingExtensionMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.SimpleModelEditMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix.DataContextElementResolutionFactory;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix.DataContextPropertyResolutionFactory;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix.FindNewPackageLocation;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;
import org.eclipse.ui.IMarkerResolution;

public class PropertiesMarkerResolutionGenerator
extends CommonMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (this.hasCommonResolutions(marker)) {
            return super.getResolutions(marker);
        }
        int problemID = PropertiesMarkerResolutionGenerator.getProblemID((IMarker)marker);
        switch (problemID) {
            case 16715840: {
                return this.only((IMarkerResolution)new SimpleMissingExtensionMarkerResolution(problemID, Messages.MissingPropertiesExtension_0, Messages.MissingPropertiesExtension_1, "org.eclipse.papyrus.infra.properties.contexts", "context", new BiConsumer[]{SimpleMissingExtensionMarkerResolution.optionalAttribute((String)"contextModel", m -> CommonMarkerResolutionUtils.getModelPath((IMarker)m).map(IPath::toPortableString))}));
            }
            case 16715841: {
                return this.only((IMarkerResolution)new SimpleMissingExtensionMarkerResolution(problemID, Messages.MissingPropertiesExtension_2, Messages.MissingPropertiesExtension_3, "org.eclipse.papyrus.infra.properties.environments", "environment", new BiConsumer[]{SimpleMissingExtensionMarkerResolution.optionalAttribute((String)"environmentModel", m -> CommonMarkerResolutionUtils.getModelPath((IMarker)m).map(IPath::toPortableString))}));
            }
            case 16715847: {
                return this.only(this.createSetValueResolution(problemID, ContextsPackage.Literals.PROPERTY__TYPE, Messages.PropertiesMarkerResolutionGenerator_0, Messages.PropertiesMarkerResolutionGenerator_1));
            }
            case 16715848: {
                return this.only(this.createSetReferenceResolution(problemID, UiPackage.Literals.PROPERTY_EDITOR__WIDGET_TYPE, Messages.PropertiesMarkerResolutionGenerator_2, Messages.PropertiesMarkerResolutionGenerator_3));
            }
            case 16715843: 
            case 16715844: 
            case 16715852: {
                return this.allOf(new DataContextElementResolutionFactory(problemID).createResolutions(marker));
            }
            case 16715845: 
            case 16715846: {
                return this.allOf(new DataContextPropertyResolutionFactory(problemID).createResolutions(marker));
            }
            case 16715849: 
            case 16715850: 
            case 16715851: {
                return this.maybe(CommonMarkerResolutionUtils.getModelAttribute((IMarker)marker).map(feature -> this.createSetValueResolution(problemID, (EAttribute)feature, Messages.PropertiesMarkerResolutionGenerator_4, Messages.PropertiesMarkerResolutionGenerator_5)));
            }
            case 16715853: {
                return this.only((IMarkerResolution)SimpleModelEditMarkerResolution.create((int)problemID, (String)Messages.PropertiesMarkerResolutionGenerator_6, (String)Messages.PropertiesMarkerResolutionGenerator_7, DataContextRoot.class, new FindNewPackageLocation()::fix));
            }
            case 16715854: {
                return this.maybe(CommonMarkerResolutionUtils.getModelAttribute((IMarker)marker).map(feature -> this.createSetValueResolution(problemID, (EAttribute)feature, Messages.PropertiesMarkerResolutionGenerator_8, Messages.PropertiesMarkerResolutionGenerator_9)));
            }
            case 16715855: {
                String validClassNames = PropertiesPluginValidationConstants.getValueToSet(marker, String.class, EcorePackage.Literals.ESTRING).orElse("");
                return this.allOf((IMarkerResolution[])Stream.of(validClassNames.split(",")).map(className -> CommonMarkerResolutionUtils.getModelAttribute((IMarker)marker).map(feature -> this.createSetValueResolution(problemID, (EAttribute)feature, className, NLS.bind((String)Messages.PropertiesMarkerResolutionGenerator_10, (Object)className), NLS.bind((String)Messages.PropertiesMarkerResolutionGenerator_11, (Object)className)))).filter(Optional::isPresent).map(Optional::get).toArray(IMarkerResolution[]::new));
            }
            case 16715856: {
                return this.only(this.createSetValueResolution(problemID, ContextsPackage.Literals.PROPERTY__MULTIPLICITY, Messages.PropertiesMarkerResolutionGenerator_12, Messages.PropertiesMarkerResolutionGenerator_13));
            }
        }
        return this.noResolutions();
    }

    public boolean hasResolutions(IMarker marker) {
        return super.hasResolutions(marker) || this.matchProblemID(marker, 16715840, 16715903);
    }

    protected IMarkerResolution createSetValueResolution(int problemID, EAttribute attribute, String label, String description) {
        Class<EObject> ownerType = attribute.getEContainingClass().getInstanceClass().asSubclass(EObject.class);
        return SimpleModelEditMarkerResolution.create((int)problemID, (String)label, (String)description, ownerType, (domain, owner, marker) -> {
            CompoundCommand result = new CompoundCommand();
            EDataType dataType = attribute.getEAttributeType();
            Optional value = PropertiesPluginValidationConstants.getValueToSet(marker, dataType.getInstanceClass(), dataType);
            result.append(value.map(v -> SetCommand.create((EditingDomain)domain, (Object)owner, (Object)attribute, (Object)v)).orElse((Command)UnexecutableCommand.INSTANCE));
            if (attribute == ContextsPackage.Literals.PROPERTY__NAME) {
                result.append(this.touchSectionFiles((EditingDomain)domain, (Property)owner));
            } else if (attribute == ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__NAME) {
                result.append(this.touchSectionFiles((EditingDomain)domain, (DataContextElement)owner));
            }
            return result.unwrap();
        });
    }

    protected IMarkerResolution createSetValueResolution(int problemID, EAttribute attribute, Object value, String label, String description) {
        Class<EObject> ownerType = attribute.getEContainingClass().getInstanceClass().asSubclass(EObject.class);
        return SimpleModelEditMarkerResolution.create((int)problemID, (String)label, (String)description, ownerType, (domain, owner, marker) -> {
            CompoundCommand result = new CompoundCommand();
            result.append(SetCommand.create((EditingDomain)domain, (Object)owner, (Object)attribute, (Object)value));
            if (attribute == ContextsPackage.Literals.PROPERTY__NAME) {
                result.append(this.touchSectionFiles((EditingDomain)domain, (Property)owner));
            } else if (attribute == ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__NAME) {
                result.append(this.touchSectionFiles((EditingDomain)domain, (DataContextElement)owner));
            }
            return result.unwrap();
        }).disableMultiFix();
    }

    protected IMarkerResolution createSetReferenceResolution(int problemID, EReference reference, String label, String description) {
        Class<EObject> ownerType = reference.getEContainingClass().getInstanceClass().asSubclass(EObject.class);
        return SimpleModelEditMarkerResolution.create((int)problemID, (String)label, (String)description, ownerType, (domain, owner, marker) -> {
            Class<EObject> referenceType = reference.getEReferenceType().getInstanceClass().asSubclass(EObject.class);
            Optional<EObject> object = PropertiesPluginValidationConstants.getObjectToReference(marker, referenceType, domain);
            return object.map(ref -> SetCommand.create((EditingDomain)domain, (Object)owner, (Object)reference, (Object)ref)).orElse((Command)UnexecutableCommand.INSTANCE);
        });
    }

    protected Command touchSectionFiles(EditingDomain domain, Property property) {
        PropertiesCache.getInstance((Notifier)property).getSections(property.getContextElement()).forEach(Section::getWidget);
        return (Command)PropertiesCache.getInstance((Notifier)property).getReferencers((EObject)property, UiPackage.Literals.PROPERTY_EDITOR__PROPERTY).stream().map(EObject::eResource).distinct().collect(TouchResourceCommand.toTouchCommand((EditingDomain)domain));
    }

    protected Command touchSectionFiles(EditingDomain domain, DataContextElement element) {
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)element);
        Stream<DataContextElement> classes = !(element instanceof DataContextPackage) ? Stream.of(element) : Iterators2.stream((TreeIterator)Iterators2.filter((TreeIterator)element.eAllContents(), DataContextElement.class)).filter(Predicate.not(DataContextPackage.class::isInstance));
        return (Command)classes.map(cache::getSections).flatMap(Collection::stream).map(Section::getWidget).filter(Objects::nonNull).filter(Predicate.not(EObject::eIsProxy)).map(EObject::eResource).distinct().collect(TouchResourceCommand.toTouchCommand((EditingDomain)domain));
    }
}

