/**
 * Copyright (c) 2006, 2010, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Remi Schnekenburger (CEA LIST) - modification for Papyrus MDT
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : Remove reference to gmfgraph and ModelViewMap
 */
package impl.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;

/**
 * Revisit: [MG]: @Inject extension same-named-api-class -> template extends api-class?
 */
@Singleton
@SuppressWarnings("all")
public class LinkEditPart {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;

  @Inject
  private TextAware xptTextAware;

  public CharSequence className(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence packageName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }

  public CharSequence constructor(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createDefaultEditPoliciesBody(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    {
      LinkModelFacet _modelFacet = it.getModelFacet();
      boolean _tripleEquals = (null == _modelFacet);
      if (_tripleEquals) {
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.COMPONENT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy(it);
    _builder.append(_installSemanticEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * FIXME: [MG] check counterpart for ModeledViewmap,
   */
  public CharSequence addFixedChild(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = it.getLabels().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean addFixedChild(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        {
          EList<GenLinkLabel> _labels = it.getLabels();
          for(final GenLinkLabel label : _labels) {
            _builder.append("\t");
            CharSequence _addLabel = this.addLabel(label.getViewmap(), label);
            _builder.append(_addLabel, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _addLabel(final Viewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _addLabel(final ParentAssignedViewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonAddLabel = this.commonAddLabel(it, it.getGetterName(), label);
    _builder.append(_commonAddLabel);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence commonAddLabel(final Viewmap it, final String getterName, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (childEditPart instanceof ");
    String _editPartQualifiedClassName = label.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("((");
    String _editPartQualifiedClassName_1 = label.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName_1, "\t");
    _builder.append(") childEditPart).");
    CharSequence _labelSetterName = this.xptTextAware.labelSetterName(it);
    _builder.append(_labelSetterName, "\t");
    _builder.append("(getPrimaryShape().");
    _builder.append(getterName, "\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence removeFixedChild(final GenLink it) {
    CharSequence _xifexpression = null;
    boolean _isEmpty = it.getLabels().isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _generatedMemberComment = this._common.generatedMemberComment();
      _builder.append(_generatedMemberComment);
      _builder.newLineIfNotEmpty();
      _builder.append("protected boolean removeFixedChild(org.eclipse.gef.EditPart childEditPart) {");
      _builder.newLine();
      {
        EList<GenLinkLabel> _labels = it.getLabels();
        for(final GenLinkLabel label : _labels) {
          _builder.append("\t");
          CharSequence _removeLabel = this.removeLabel(label.getViewmap(), label);
          _builder.append(_removeLabel, "\t");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.append("return false;");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xifexpression = _builder;
    }
    return _xifexpression;
  }

  protected CharSequence _removeLabel(final Viewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _removeLabel(final ParentAssignedViewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonRemoveLabel = this.commonRemoveLabel(it, label);
    _builder.append(_commonRemoveLabel);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _removeLabel(final ModeledViewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonRemoveLabel = this.commonRemoveLabel(it, label);
    _builder.append(_commonRemoveLabel);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence commonRemoveLabel(final Viewmap it, final GenLinkLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (childEditPart instanceof ");
    String _editPartQualifiedClassName = label.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence addChildVisual(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addChildVisual(org.eclipse.gef.EditPart childEditPart, int index) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (addFixedChild(childEditPart)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.addChildVisual(childEditPart, -1);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence removeChildVisual(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void removeChildVisual(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (removeFixedChild(childEditPart)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.removeChildVisual(childEditPart);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence createLinkFigure(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(((("Creates figure for this edit part.\n" + "\n") + 
      "Body of this method does not depend on settings in generation model\n") + 
      "so you may safely remove <i>generated</i> tag and modify it."));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _createLinkFigure = this.createLinkFigure(it.getViewmap(), it);
    _builder.append(_createLinkFigure);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _createLinkFigure(final Viewmap it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unknown viewmap: " + it) + ", for link: ") + link));
    return _builder;
  }

  protected CharSequence _createLinkFigure(final FigureViewmap it, final GenLink link) {
    CharSequence _xblockexpression = null;
    {
      String _xifexpression = null;
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _tripleEquals = (_figureQualifiedClassName == null);
      if (_tripleEquals) {
        _xifexpression = "org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx";
      } else {
        _xifexpression = it.getFigureQualifiedClassName();
      }
      String fqn = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _overrideC = this._codeStyle.overrideC(link);
      _builder.append(_overrideC);
      _builder.newLineIfNotEmpty();
      _builder.append("protected org.eclipse.draw2d.Connection createConnectionFigure() {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("return new ");
      _builder.append(fqn, "\t");
      _builder.append("();");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      CharSequence _generatedMemberComment = this._common.generatedMemberComment();
      _builder.append(_generatedMemberComment);
      _builder.newLineIfNotEmpty();
      CharSequence _overrideI = this._codeStyle.overrideI(link);
      _builder.append(_overrideI);
      _builder.newLineIfNotEmpty();
      _builder.append("public ");
      _builder.append(fqn);
      _builder.append(" getPrimaryShape() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("return (");
      _builder.append(fqn, "\t");
      _builder.append(") getFigure();");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }

  protected CharSequence _createLinkFigure(final SnippetViewmap it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _overrideC = this._codeStyle.overrideC(link);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.Connection createConnectionFigure() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _body = it.getBody();
    _builder.append(_body, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _createLinkFigure(final InnerClassViewmap it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _overrideC = this._codeStyle.overrideC(link);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.Connection createConnectionFigure() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    String _className = it.getClassName();
    _builder.append(_className, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(link);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _className_1 = it.getClassName();
    _builder.append(_className_1);
    _builder.append(" getPrimaryShape() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return (");
    String _className_2 = it.getClassName();
    _builder.append(_className_2, "\t");
    _builder.append(") getFigure();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    String _classBody = it.getClassBody();
    _builder.append(_classBody);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * FIXME: [MG] it looks like the ModeledViewmap is fixed, check that
   * FIXME: [MG] and add the dispatch for modeled viewmaps then
   */
  public boolean hasFixedLabels(final GenLink it) {
    return (this._common_qvto.<GenLinkLabel>notEmpty(it.getLabels()) && (this._common_qvto.<GenLinkLabel>notEmpty(IterableExtensions.<GenLinkLabel>filter(it.getLabels(), ((Function1<GenLinkLabel, Boolean>) (GenLinkLabel l) -> {
      return Boolean.valueOf(this._common_qvto.oclIsKindOf(l.getViewmap(), ParentAssignedViewmap.class));
    }))) || this._common_qvto.<GenLinkLabel>notEmpty(IterableExtensions.<GenLinkLabel>filter(it.getLabels(), ((Function1<GenLinkLabel, Boolean>) (GenLinkLabel l) -> {
      return Boolean.valueOf(this._common_qvto.oclIsKindOf(l.getViewmap(), ModeledViewmap.class));
    })))));
  }

  /**
   * computes super type of the link edit part in case the edit part manages a representation of a UML element
   */
  public String extendsListContents(final GenLink it) {
    String _superEditPart = it.getSuperEditPart();
    boolean _tripleNotEquals = (_superEditPart != null);
    if (_tripleNotEquals) {
      StringConcatenation _builder = new StringConcatenation();
      String _superEditPart_1 = it.getSuperEditPart();
      _builder.append(_superEditPart_1);
      return _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart");
      return _builder_1.toString();
    }
  }

  public CharSequence addLabel(final Viewmap it, final GenLinkLabel label) {
    if (it instanceof ParentAssignedViewmap) {
      return _addLabel((ParentAssignedViewmap)it, label);
    } else if (it != null) {
      return _addLabel(it, label);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, label).toString());
    }
  }

  public CharSequence removeLabel(final Viewmap it, final GenLinkLabel label) {
    if (it instanceof ModeledViewmap) {
      return _removeLabel((ModeledViewmap)it, label);
    } else if (it instanceof ParentAssignedViewmap) {
      return _removeLabel((ParentAssignedViewmap)it, label);
    } else if (it != null) {
      return _removeLabel(it, label);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, label).toString());
    }
  }

  public CharSequence createLinkFigure(final Viewmap it, final GenLink link) {
    if (it instanceof FigureViewmap) {
      return _createLinkFigure((FigureViewmap)it, link);
    } else if (it instanceof InnerClassViewmap) {
      return _createLinkFigure((InnerClassViewmap)it, link);
    } else if (it instanceof SnippetViewmap) {
      return _createLinkFigure((SnippetViewmap)it, link);
    } else if (it != null) {
      return _createLinkFigure(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }
}
