/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.reconcile;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.gmf.internal.common.reconcile.Decision;

public class StringPatternDecision
extends Decision {
    protected final Pattern myPattern;

    public StringPatternDecision(String valuePattern, EAttribute attribute) {
        this(Pattern.compile(valuePattern), attribute);
    }

    public StringPatternDecision(Pattern valuePattern, EAttribute attribute) {
        super((EStructuralFeature)attribute);
        if (attribute.getEAttributeType() != EcorePackage.eINSTANCE.getEString()) {
            throw new IllegalArgumentException("Expected string attribute");
        }
        if (attribute.getUpperBound() != 1) {
            throw new IllegalArgumentException("Expected multiplicity [0..1] or [1]");
        }
        this.myPattern = valuePattern;
    }

    @Override
    public void apply(EObject current, EObject old) {
        String oldValue = (String)old.eGet(this.getFeature());
        if (oldValue != null && !this.myPattern.matcher(oldValue).matches()) {
            this.preserveOld(current, old);
        } else {
            this.acceptNew(current, old);
        }
    }
}

