/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.Editor;
import xpt.editor.GenDiagram_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
public class DiagramEditorUtil {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private GenDiagram_qvto _genDiagram_qvto;
    @Inject
    @Extension
    private ExternalizerUtils_qvto _externalizerUtils_qvto;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private Activator xptActivator;
    @Inject
    private Editor xptEditor;

    @MetaDef
    public CharSequence callSetCharset(GenDiagram it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramEditorUtilQualifiedClassName = it.getDiagramEditorUtilQualifiedClassName();
        _builder.append(_diagramEditorUtilQualifiedClassName);
        _builder.append(".setCharset(");
        _builder.append(varName);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @MetaDef
    public CharSequence callGetSaveOptions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".getSaveOptions()");
        return _builder;
    }

    @Localization
    public String i18nKeyForDiagramEditorUtil(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return String.valueOf(_className);
    }

    @Localization
    public String i18nKeyForOpenModelResourceErrorDialog(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return _i18nKeyForDiagramEditorUtil + ".OpenModelResourceErrorDialog";
    }

    @Localization
    public String i18nKeyForCreateDiagramProgressTask(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return _i18nKeyForDiagramEditorUtil + ".CreateDiagramProgressTask";
    }

    @Localization
    public String i18nKeyForCreateDiagramCommandLabel(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return _i18nKeyForDiagramEditorUtil + ".CreateDiagramCommandLabel";
    }

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramEditorUtilClassName = it.getDiagramEditorUtilClassName();
        _builder.append(_diagramEditorUtilClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence DiagramEditorUtil(GenDiagram it) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("@SuppressWarnings(\"deprecation\")");
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _saveOptions = this.saveOptions(it);
        _builder.append((Object)_saveOptions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _openDiagramMethod = this.openDiagramMethod(it);
        _builder.append((Object)_openDiagramMethod, "\t");
        _builder.newLineIfNotEmpty();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("\t");
            CharSequence _setCharsetMethods = this.setCharsetMethods(it);
            _builder.append((Object)_setCharsetMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _uniqueFileNameMethod = this.getUniqueFileNameMethod(it);
        _builder.append((Object)_uniqueFileNameMethod, "\t");
        _builder.newLineIfNotEmpty();
        GenApplication _application_1 = it.getEditorGen().getApplication();
        boolean bl2 = _tripleNotEquals = _application_1 != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            CharSequence _generatedMemberComment = this._common.generatedMemberComment("Allows user to select file and loads it as a model.");
            _builder.append((Object)_generatedMemberComment, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("public static org.eclipse.emf.ecore.resource.Resource openModel(org.eclipse.swt.widgets.Shell shell, String description, org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.swt.widgets.FileDialog fileDialog = new org.eclipse.swt.widgets.FileDialog(shell, org.eclipse.swt.SWT.OPEN);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (description != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("fileDialog.setText(description);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("fileDialog.open();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("String fileName = fileDialog.getFileName();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (fileName == null || fileName.length() == 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (fileDialog.getFilterPath() != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("fileName = fileDialog.getFilterPath() + java.io.File.separator + fileName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.emf.common.util.URI uri = org.eclipse.emf.common.util.URI.createFileURI(fileName);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.emf.ecore.resource.Resource resource = null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("resource = editingDomain.getResourceSet().getResource(uri, true);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} catch (org.eclipse.emf.common.util.WrappedException we) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
            _builder.append((Object)_qualifiedClassName, "\t\t");
            _builder.append(".getInstance().logError(\"Unable to load resource: \" + uri, we);  ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.jface.dialogs.MessageDialog.openError(shell, ");
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForOpenModelResourceErrorDialog(it)));
            _builder.append((Object)_accessorCall, "\t\t");
            _builder.append(", org.eclipse.osgi.util.NLS.bind(");
            CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForOpenModelResourceErrorDialog(it)));
            _builder.append((Object)_accessorCall_1, "\t\t");
            _builder.append(", fileName));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return resource;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("Runs the wizard in a dialog.");
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public static void runWizard(org.eclipse.swt.widgets.Shell shell, org.eclipse.jface.wizard.Wizard wizard, String settingsKey) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.dialogs.IDialogSettings pluginDialogSettings = ");
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".getInstance().getDialogSettings();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.dialogs.IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (wizardDialogSettings == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("wizard.setDialogSettings(wizardDialogSettings);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.wizard.WizardDialog dialog = new org.eclipse.jface.wizard.WizardDialog(shell, wizard);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("dialog.create();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("dialog.open();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createDiagramMethod = this.createDiagramMethod(it);
        _builder.append((Object)_createDiagramMethod, "\t");
        _builder.newLineIfNotEmpty();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl3 = _tripleNotEquals_1 = _domainDiagramElement != null;
        if (_tripleNotEquals_1) {
            _builder.append("\t");
            CharSequence _createInitialModelMethod = this.createInitialModelMethod(it);
            _builder.append((Object)_createInitialModelMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _attachModelMethod = this.attachModelMethod(it);
            _builder.append((Object)_attachModelMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            boolean _hasDocumentRoot = this._genDiagram_qvto.hasDocumentRoot(it);
            if (_hasDocumentRoot) {
                CharSequence _createDocumentRootMethod = this.createDocumentRootMethod(it);
                _builder.append((Object)_createDocumentRootMethod, "\t");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _selectElementsMethod = this.selectElementsMethod(it);
        _builder.append((Object)_selectElementsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _findElementsMethod = this.findElementsMethod(it);
        _builder.append((Object)_findElementsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _findViewMethod = this.findViewMethod(it);
        _builder.append((Object)_findViewMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence saveOptions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static java.util.Map<?, ?> getSaveOptions() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.HashMap<String, Object> saveOptions = new java.util.HashMap<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "String", "Object");
        _builder.append(_diamondOp, "\t");
        _builder.append(">(); ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("saveOptions.put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_ENCODING, \"UTF-8\");  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("saveOptions.put(org.eclipse.emf.ecore.resource.Resource.OPTION_SAVE_ONLY_IF_CHANGED, org.eclipse.emf.ecore.resource.Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return saveOptions;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openDiagramMethod(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean openDiagram(org.eclipse.emf.ecore.resource.Resource diagram) throws org.eclipse.ui.PartInitException {");
        _builder.newLine();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("String path = diagram.getURI().toPlatformString(true);");
            _builder.newLine();
            _builder.append("org.eclipse.core.resources.IResource workspaceResource = org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot().findMember(new org.eclipse.core.runtime.Path(path));");
            _builder.newLine();
            _builder.append("if (workspaceResource instanceof org.eclipse.core.resources.IFile) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.ui.IWorkbenchPage page = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return null != page.openEditor(new org.eclipse.ui.part.FileEditorInput((org.eclipse.core.resources.IFile) workspaceResource), ");
            CharSequence _qualifiedClassName = this.xptEditor.qualifiedClassName(it.getEditorGen().getEditor());
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append(".ID);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("return false;");
            _builder.newLine();
        } else {
            _builder.append("org.eclipse.ui.IWorkbenchPage page = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
            _builder.newLine();
            _builder.append("page.openEditor(new org.eclipse.emf.common.ui.URIEditorInput(diagram.getURI()), ");
            CharSequence _qualifiedClassName_1 = this.xptEditor.qualifiedClassName(it.getEditorGen().getEditor());
            _builder.append((Object)_qualifiedClassName_1);
            _builder.append(".ID);");
            _builder.newLineIfNotEmpty();
            _builder.append("return true;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setCharsetMethods(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void setCharset(org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("file.setCharset(\"UTF-8\", new org.eclipse.core.runtime.NullProgressMonitor());  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} catch (org.eclipse.core.runtime.CoreException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append(".getInstance().logError(\"Unable to set charset for file \" + file.getFullPath(), e);  ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getUniqueFileNameMethod(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String getUniqueFileName(org.eclipse.core.runtime.IPath containerFullPath, String fileName, String extension) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.part.DefaultDiagramEditorUtil.getUniqueFileName(containerFullPath, fileName, extension, org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.part.DefaultDiagramEditorUtil.");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("EXISTS_IN_WORKSPACE");
        } else {
            _builder.append("EXISTS_AS_IO_FILE");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDiagramMethod(GenDiagram it) {
        boolean _tripleEquals_1;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _xifexpression = null;
        GenApplication _application = it.getEditorGen().getApplication();
        boolean _tripleEquals = _application == null;
        _xifexpression = _tripleEquals ? "This method should be called within a workspace modify operation since it creates resources." : "";
        CharSequence _generatedMemberComment = this._common.generatedMemberComment(_xifexpression);
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static org.eclipse.emf.ecore.resource.Resource createDiagram(org.eclipse.emf.common.util.URI diagramURI,");
        boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel) {
            _builder.append(" org.eclipse.emf.common.util.URI modelURI,");
        }
        _builder.append(" org.eclipse.core.runtime.IProgressMonitor progressMonitor) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = org.eclipse.emf.workspace.WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("progressMonitor.beginTask(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreateDiagramProgressTask(it));
        _builder.append((Object)_accessorCall, "\t");
        _builder.append(", 3);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final org.eclipse.emf.ecore.resource.Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);");
        _builder.newLine();
        boolean _standaloneDomainModel_1 = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel_1) {
            _builder.append("\t");
            _builder.append("final org.eclipse.emf.ecore.resource.Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);");
            _builder.newLine();
        } else if (it.getDomainDiagramElement() != null && this._genDiagram_qvto.hasDocumentRoot(it)) {
            _builder.append("\t");
            _builder.append("((org.eclipse.emf.ecore.xmi.XMLResource) diagramResource).getDefaultSaveOptions().put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_EXTENDED_META_DATA, Boolean.TRUE);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("((org.eclipse.emf.ecore.xmi.XMLResource) diagramResource).getDefaultLoadOptions().put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_EXTENDED_META_DATA, Boolean.TRUE);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("final String diagramName = diagramURI.lastSegment();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand command = new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(editingDomain, ");
        CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreateDiagramCommandLabel(it));
        _builder.append((Object)_accessorCall_1, "\t");
        _builder.append(", java.util.Collections.EMPTY_LIST) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl = _tripleNotEquals = _domainDiagramElement != null;
        if (_tripleNotEquals) {
            _builder.append("\t\t\t");
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getDomainDiagramElement());
            _builder.append((Object)_QualifiedClassName, "\t\t\t");
            _builder.append(" model = createInitialModel();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("attachModelToResource(model, ");
            boolean _standaloneDomainModel_2 = this._genDiagram_qvto.standaloneDomainModel(it);
            if (_standaloneDomainModel_2) {
                _builder.append("model");
            } else {
                _builder.append("diagram");
            }
            _builder.append("Resource);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createDiagram(");
        GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
        boolean bl2 = _tripleNotEquals_1 = _domainDiagramElement_1 != null;
        if (_tripleNotEquals_1) {
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getDomainDiagramElement(), "model");
            _builder.append((Object)_DowncastToEObject, "\t\t\t");
            _builder.append(", ");
        }
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t\t");
        _builder.append(", ");
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
        _builder.append((Object)_preferenceHintAccess, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (diagram != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("diagramResource.getContents().add(diagram);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("diagram.setName(diagramName);");
        _builder.newLine();
        GenClass _domainDiagramElement_2 = it.getDomainDiagramElement();
        boolean bl3 = _tripleNotEquals_2 = _domainDiagramElement_2 != null;
        if (_tripleNotEquals_2) {
            _builder.append("\t\t\t\t");
            _builder.append("diagram.setElement(");
            CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(it.getDomainDiagramElement(), "model");
            _builder.append((Object)_DowncastToEObject_1, "\t\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        boolean _standaloneDomainModel_3 = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel_3) {
            _builder.append("modelResource.save(");
            CharSequence _callGetSaveOptions = this.callGetSaveOptions(it);
            _builder.append((Object)_callGetSaveOptions, "\t\t\t\t");
            _builder.append(");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("diagramResource.save(");
        CharSequence _callGetSaveOptions_1 = this.callGetSaveOptions(it);
        _builder.append((Object)_callGetSaveOptions_1, "\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t\t\t");
        _builder.append(".getInstance().logError(\"Unable to store model and diagram resources\", e);  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.commands.operations.OperationHistoryFactory.getOperationHistory().execute(command, new org.eclipse.core.runtime.SubProgressMonitor(progressMonitor, 1), null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (org.eclipse.core.commands.ExecutionException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".getInstance().logError(\"Unable to create model and diagram\", e);  ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        GenApplication _application_1 = it.getEditorGen().getApplication();
        boolean bl4 = _tripleEquals_1 = _application_1 == null;
        if (_tripleEquals_1) {
            _builder.append("\t");
            boolean _standaloneDomainModel_4 = this._genDiagram_qvto.standaloneDomainModel(it);
            if (_standaloneDomainModel_4) {
                _builder.append("setCharset(org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(modelResource));");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("setCharset(org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(diagramResource));");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return diagramResource;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createInitialModelMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Create a new instance of domain element associated with canvas.\n<!-- begin-user-doc -->\n<!-- end-user-doc -->");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static ");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getDomainDiagramElement());
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" createInitialModel() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _NewInstance = this.xptMetaModel.NewInstance(it.getDomainDiagramElement());
        _builder.append((Object)_NewInstance, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attachModelMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Store model element in the resource.\n<!-- begin-user-doc -->\n<!-- end-user-doc -->");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static void attachModelToResource(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getDomainDiagramElement());
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" model, org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("resource.getContents().add(");
        boolean _hasDocumentRoot = this._genDiagram_qvto.hasDocumentRoot(it);
        if (_hasDocumentRoot) {
            _builder.append("createDocumentRoot(model)");
        } else {
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getDomainDiagramElement(), "model");
            _builder.append((Object)_DowncastToEObject, "\t");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDocumentRootMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static ");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)this._genDiagram_qvto.getDocumentRoot(it));
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" createDocumentRoot(");
        CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getDomainDiagramElement());
        _builder.append((Object)_QualifiedClassName_1);
        _builder.append(" model) {");
        _builder.newLineIfNotEmpty();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        GenClass _documentRoot = this._genDiagram_qvto.getDocumentRoot(it);
        boolean _equals = Objects.equal((Object)_domainDiagramElement, (Object)_documentRoot);
        if (_equals) {
            _builder.append("\t");
            _builder.append("return model;");
            _builder.newLine();
        } else {
            _builder.append("\t");
            CharSequence _NewInstance = this.xptMetaModel.NewInstance(this._genDiagram_qvto.getDocumentRoot(it), "docRoot");
            _builder.append((Object)_NewInstance, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            GenFeature rootFeature = this._genDiagram_qvto.getDocumentRootSetFeature(it);
            _builder.newLineIfNotEmpty();
            if (rootFeature == null) {
                _builder.append("\t");
                _builder.append("docRoot.set");
                String _name = it.getDomainDiagramElement().getEcoreClass().getName();
                _builder.append(_name, "\t");
                _builder.append("(model); // FIXME name of the set method is pure guess");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(rootFeature, "docRoot", this._genDiagram_qvto.getDocumentRoot(it), "model");
                _builder.append((Object)_modifyFeature, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("return docRoot;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence selectElementsMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void selectElementsInDiagram(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart diagramPart, java.util.List<org.eclipse.gef.EditPart> editParts) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("diagramPart.getDiagramGraphicalViewer().deselectAll();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gef.EditPart firstPrimary = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (org.eclipse.gef.EditPart nextPart : editParts) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(firstPrimary == null && nextPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("firstPrimary = nextPart;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(!editParts.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : (org.eclipse.gef.EditPart)editParts.get(0));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence findElementsMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static int findElementsInDiagramByID(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramPart, org.eclipse.emf.ecore.EObject element, java.util.List<org.eclipse.gef.EditPart> editPartCollector) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer viewer = (org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer) diagramPart.getViewer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final int intialNumOfEditParts = editPartCollector.size();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (element instanceof org.eclipse.gmf.runtime.notation.View) { // support notation element lookup");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPart editPart = (org.eclipse.gef.EditPart) viewer.getEditPartRegistry().get(element);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (editPart != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("editPartCollector.add(editPart);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return 1;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String elementID = org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getProxyID(element);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<org.eclipse.gef.EditPart> associatedParts = viewer.findEditPartsForElement(elementID, org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// perform the possible hierarchy disjoint -> take the top-most parts only");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (org.eclipse.gef.EditPart nextPart : associatedParts) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPart parentPart = nextPart.getParent();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (parentPart != null && !associatedParts.contains(parentPart)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("parentPart = parentPart.getParent();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (parentPart == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("editPartCollector.add(nextPart);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (intialNumOfEditParts == editPartCollector.size()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!associatedParts.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("editPartCollector.add(associatedParts.get(0));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (element.eContainer() != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return findElementsInDiagramByID(diagramPart, element.eContainer(), editPartCollector);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return editPartCollector.size() - intialNumOfEditParts;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence findViewMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static org.eclipse.gmf.runtime.notation.View findView(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.emf.ecore.EObject targetElement, LazyElement2ViewMap lazyElement2ViewMap) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("boolean hasStructuralURI = false;\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(targetElement.eResource() instanceof org.eclipse.emf.ecore.xmi.XMLResource) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hasStructuralURI = ((org.eclipse.emf.ecore.xmi.XMLResource)targetElement.eResource()).getID(targetElement) == null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.LinkedList<org.eclipse.gef.EditPart> editPartHolder = new java.util.LinkedList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.gef.EditPart");
        _builder.append(_diamondOp, "\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(hasStructuralURI && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("view = lazyElement2ViewMap.getElement2ViewMap().get(targetElement);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else if (findElementsInDiagramByID(diagramEditPart, targetElement, editPartHolder) > 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPart editPart = editPartHolder.get(0);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("view = editPart.getModel() instanceof org.eclipse.gmf.runtime.notation.View ? (org.eclipse.gmf.runtime.notation.View) editPart.getModel() : null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return (view == null) ? diagramEditPart.getDiagramView() : view;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("XXX This is quite suspicious code (especially editPartTmpHolder) and likely to be removed soon");
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public static class LazyElement2ViewMap {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> element2ViewMap;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.runtime.notation.View scope;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private java.util.Set<? extends org.eclipse.emf.ecore.EObject> elementSet;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public LazyElement2ViewMap(org.eclipse.gmf.runtime.notation.View scope, java.util.Set<? extends org.eclipse.emf.ecore.EObject> elements) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.scope = scope;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.elementSet = elements;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public final java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> getElement2ViewMap() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element2ViewMap == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("element2ViewMap = new java.util.HashMap<");
        String _diamondOp_1 = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.emf.ecore.EObject", "org.eclipse.gmf.runtime.notation.View");
        _builder.append(_diamondOp_1, "\t\t\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("// map possible notation elements to itself as these can't be found by view.getElement()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for (org.eclipse.emf.ecore.EObject element : elementSet) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(element instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) element;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(view.getDiagram() == scope.getDiagram()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("element2ViewMap.put(element, view); // take only those that part of our diagram");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("buildElement2ViewMap(scope, element2ViewMap, elementSet);\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return element2ViewMap;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_7, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private static boolean buildElement2ViewMap(org.eclipse.gmf.runtime.notation.View parentView, java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> element2ViewMap, java.util.Set<? extends org.eclipse.emf.ecore.EObject> elements) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (elements.size() == element2ViewMap.size()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(parentView.isSetElement() && !element2ViewMap.containsKey(parentView.getElement()) && elements.contains(parentView.getElement())) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("element2ViewMap.put(parentView.getElement(), parentView);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (elements.size() == element2ViewMap.size()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("boolean complete = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator<?> it = parentView.getChildren().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator<?> it = parentView.getSourceEdges().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator<?> it = parentView.getTargetEdges().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return complete;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}// LazyElement2ViewMap");
        _builder.newLine();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForOpenModelResourceErrorDialog(it)));
        _builder.append((Object)_accessorField);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForOpenModelResourceErrorDialog(it)));
        _builder.append((Object)_accessorField_1);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this.i18nKeyForCreateDiagramProgressTask(it));
        _builder.append((Object)_accessorField_2);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this.i18nKeyForCreateDiagramCommandLabel(it));
        _builder.append((Object)_accessorField_3);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForOpenModelResourceErrorDialog(it)), "Error");
        _builder.append((Object)_messageEntry);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForOpenModelResourceErrorDialog(it)), "Failed to load model file {0}");
        _builder.append((Object)_messageEntry_1);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this.i18nKeyForCreateDiagramProgressTask(it), "Creating diagram and model files");
        _builder.append((Object)_messageEntry_2);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this.i18nKeyForCreateDiagramCommandLabel(it), "Creating diagram and model");
        _builder.append((Object)_messageEntry_3);
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

