/**
 * Copyright (c) 2006-2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenFeatureImpl;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@Singleton
@SuppressWarnings("all")
public class GenModelUtils_qvto {
  private static final Set<String> PRIMITIVES = CollectionLiterals.<String>newHashSet("boolean", "byte", "char", "double", "float", "int", "long", 
    "short");

  /**
   * GenModel functionality unrelated to EMF generated code
   * or metamodel access only.
   */
  public GenFeature getReverse(final GenFeature feature) {
    return feature.getReverse();
  }

  /**
   * For primitive types, return their java.lang wrappers, for non-primitive
   * types returns instanceClassName as is
   */
  public String getObjectCompatibleClassName(final EDataType dt) {
    final String instanceClass = dt.getInstanceClassName();
    boolean _contains = instanceClass.contains(".");
    if (_contains) {
      return instanceClass;
    }
    String _switchResult = null;
    if (instanceClass != null) {
      switch (instanceClass) {
        case "boolean":
          return "java.lang.Boolean";
        case "byte":
          return "java.lang.Byte";
        case "char":
          return "java.lang.Character";
        case "double":
          return "java.lang.Double";
        case "float":
          return "java.lang.Float";
        case "int":
          return "java.lang.Integer";
        case "long":
          return "java.lang.Long";
        case "short":
          return "java.lang.Short";
        default:
          _switchResult = "java.lang.Object";
          break;
      }
    } else {
      _switchResult = "java.lang.Object";
    }
    return _switchResult;
  }

  public GenClassifier getTypeGenClassifier(final GenFeature feature) {
    return feature.getTypeGenClassifier();
  }

  /**
   * FIXME: for models loaded from generated package (e.g. gmf tests often
   * refer to EClass/EOperation directly from EcorePackage) instanceClassName
   * is always set and thus all metamodel types are treated as external interfaces,
   * with useless casts to EObject
   * 
   * GenClass#isExternalInterface()
   */
  public boolean isExternalInterface(final GenClass gc) {
    return gc.isExternalInterface();
  }

  public boolean isContains(final GenFeature gf) {
    return ((GenFeatureImpl) gf).isContains();
  }

  public boolean isPrimitiveType(final GenFeature gf) {
    return GenModelUtils_qvto.PRIMITIVES.contains(gf.getEcoreFeature().getEType().getInstanceClassName());
  }

  public boolean isSuperTypeOf(final GenClass xptSelf, final GenClass subclassCandidate) {
    if ((Objects.equal(xptSelf.getEcoreClass().getName(), "EObject") && 
      Objects.equal(xptSelf.getEcoreClass().getEPackage().getNsURI(), "http://www.eclipse.org/emf/2002/Ecore"))) {
      return true;
    }
    return xptSelf.getEcoreClass().isSuperTypeOf(subclassCandidate.getEcoreClass());
  }
}
