/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.requests.MoveSeparatorRequest;
import org.eclipse.papyrus.uml.diagram.sequence.tools.SeparatorResizeTracker;

public class CombinedFragmentResizeEditPolicy
extends ResizableEditPolicyEx {
    private Polyline separatorFeedback;

    protected List<Handle> createSelectionHandles() {
        List handles = super.createSelectionHandles();
        List<GraphicalEditPart> operands = this.getOperands();
        int separators = operands.size() - 1;
        if (this.getHost().getSelected() == 2) {
            int i = 0;
            while (i < separators) {
                handles.add(this.createSeparatorHandle(i, operands));
                ++i;
            }
        }
        return handles;
    }

    public GraphicalEditPart getHost() {
        return super.getHost();
    }

    private Handle createSeparatorHandle(final int separatorIndex, List<GraphicalEditPart> operands) {
        GraphicalEditPart resizedOperand = operands.get(separatorIndex + 1);
        RelativeHandleLocator locator = new RelativeHandleLocator(resizedOperand.getFigure(), 1);
        SquareHandle handle = new SquareHandle(this.getHost(), (Locator)locator, Cursors.SIZENS){

            protected DragTracker createDragTracker() {
                return new SeparatorResizeTracker(CombinedFragmentResizeEditPolicy.this.getHost(), 1, separatorIndex);
            }
        };
        return handle;
    }

    public Command getCommand(Request request) {
        if (request instanceof MoveSeparatorRequest) {
            return this.getMoveSeparatorCommand((MoveSeparatorRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        Command resizeCFCommand = super.getResizeCommand(request);
        if (resizeCFCommand != null && resizeCFCommand.canExecute()) {
            CompoundCommand command = new CompoundCommand(resizeCFCommand.getLabel());
            command.setDebugLabel("Resize CF & Operand");
            command.add(resizeCFCommand);
            ChangeBoundsRequest cbr = request;
            int direction = cbr.getResizeDirection();
            List<GraphicalEditPart> operands = this.getOperands();
            if (!operands.isEmpty()) {
                int firstOrLastOperandResizeDirection;
                GraphicalEditPart operand;
                ChangeBoundsRequest resizeOperand = new ChangeBoundsRequest();
                if ((direction & 1) != 0) {
                    operand = operands.get(0);
                    firstOrLastOperandResizeDirection = 1;
                } else {
                    operand = operands.get(operands.size() - 1);
                    firstOrLastOperandResizeDirection = 4;
                }
                resizeOperand.setMoveDelta(cbr.getMoveDelta());
                resizeOperand.setLocation(cbr.getLocation());
                resizeOperand.setType((Object)"resize");
                for (GraphicalEditPart operandPart : operands) {
                    resizeOperand.setEditParts((EditPart)operand);
                    if (operandPart == operand) {
                        resizeOperand.setSizeDelta(new Dimension(cbr.getSizeDelta()));
                        resizeOperand.setResizeDirection(firstOrLastOperandResizeDirection);
                    } else {
                        resizeOperand.setSizeDelta(new Dimension(cbr.getSizeDelta().width(), 0));
                        resizeOperand.setResizeDirection(16);
                    }
                    command.add(operandPart.getCommand((Request)resizeOperand));
                }
                return command;
            }
        }
        return resizeCFCommand;
    }

    protected Command getMoveSeparatorCommand(MoveSeparatorRequest request) {
        int separatorIndex = request.getSeparatorIndex();
        if (separatorIndex < 0 || separatorIndex > this.getOperands().size() - 1) {
            return UnexecutableCommand.INSTANCE;
        }
        double moveDistance = request.getMoveDelta().getDistance(new Point(0, 0));
        if (moveDistance < 1.0) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest requestAbove = this.getResizeAboveRequest(request);
        ChangeBoundsRequest requestBelow = this.getResizeBelowRequest(request);
        CompoundCommand moveSeparatorCommand = new CompoundCommand("Move Operands Separator");
        moveSeparatorCommand.add(this.getOperandAbove(request).getCommand((Request)requestAbove));
        moveSeparatorCommand.add(this.getOperandBelow(request).getCommand((Request)requestBelow));
        return moveSeparatorCommand;
    }

    protected GraphicalEditPart getOperandAbove(MoveSeparatorRequest request) {
        return this.getOperandAbove(request.getSeparatorIndex());
    }

    protected GraphicalEditPart getOperandAbove(int separatorIndex) {
        return this.getOperands().get(separatorIndex);
    }

    protected GraphicalEditPart getOperandBelow(MoveSeparatorRequest request) {
        return this.getOperandBelow(request.getSeparatorIndex());
    }

    protected GraphicalEditPart getOperandBelow(int separatorIndex) {
        return this.getOperands().get(separatorIndex + 1);
    }

    protected ChangeBoundsRequest getResizeAboveRequest(MoveSeparatorRequest request) {
        ChangeBoundsRequest requestAbove = new ChangeBoundsRequest((Object)"resize");
        requestAbove.setMoveDelta(new Point(0, 0));
        requestAbove.setSizeDelta(new Dimension(request.getMoveDelta().x, request.getMoveDelta().y));
        requestAbove.setResizeDirection(4);
        requestAbove.setLocation(request.getLocation());
        requestAbove.setEditParts((EditPart)this.getOperandAbove(request.getSeparatorIndex()));
        return requestAbove;
    }

    protected ChangeBoundsRequest getResizeBelowRequest(MoveSeparatorRequest request) {
        ChangeBoundsRequest requestBelow = new ChangeBoundsRequest((Object)"resize");
        Point sizeDelta = request.getMoveDelta().getNegated();
        requestBelow.setSizeDelta(new Dimension(sizeDelta.x, sizeDelta.y));
        requestBelow.setMoveDelta(request.getMoveDelta().getCopy());
        requestBelow.setResizeDirection(1);
        requestBelow.setLocation(request.getLocation());
        requestBelow.setEditParts((EditPart)this.getOperandBelow(request.getSeparatorIndex()));
        return requestBelow;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof MoveSeparatorRequest) {
            this.showMoveSeparatorFeedback((MoveSeparatorRequest)request);
        }
        super.showSourceFeedback(request);
    }

    protected void showMoveSeparatorFeedback(MoveSeparatorRequest request) {
        Polyline feedback = this.getMoveSeparatorFeedbackFigure();
        GraphicalEditPart operandPart = this.getOperandBelow(request.getSeparatorIndex());
        IFigure operandBelowFigure = operandPart.getFigure();
        IFigure operandAboveFigure = this.getOperandAbove(request.getSeparatorIndex()).getFigure();
        PrecisionRectangle location = new PrecisionRectangle(operandBelowFigure.getBounds());
        Point newPosition = location.getTopLeft();
        if (operandBelowFigure.containsPoint(newPosition) || operandAboveFigure.containsPoint(newPosition)) {
            feedback.setVisible(true);
        } else {
            feedback.setVisible(false);
        }
        operandBelowFigure.translateToAbsolute((Translatable)location);
        feedback.translateToRelative((Translatable)location);
        location.translate(0.0, request.getMoveDelta().preciseY());
        feedback.setPoint(location.getTopLeft(), 0);
        feedback.setPoint(location.getTopRight(), 1);
        feedback.validate();
    }

    protected Polyline getMoveSeparatorFeedbackFigure() {
        if (this.separatorFeedback == null) {
            this.separatorFeedback = this.createSeparatorFeedbackFigure();
        }
        return this.separatorFeedback;
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof MoveSeparatorRequest) {
            this.eraseMoveSeparatorFeedback((MoveSeparatorRequest)request);
        }
        super.eraseSourceFeedback(request);
    }

    protected void eraseMoveSeparatorFeedback(MoveSeparatorRequest request) {
        if (this.separatorFeedback != null) {
            this.removeFeedback((IFigure)this.separatorFeedback);
        }
        this.separatorFeedback = null;
    }

    protected Polyline createSeparatorFeedbackFigure() {
        Polyline l = new Polyline(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
            }
        };
        l.setLineStyle(2);
        l.setForegroundColor(ColorConstants.darkGray);
        l.addPoint(new Point(0, 0));
        l.addPoint(new Point(0, 50));
        l.setBounds(this.getHostFigure().getBounds());
        l.validate();
        this.addFeedback((IFigure)l);
        return l;
    }

    private List<GraphicalEditPart> getOperands() {
        List children = this.getHost().getChildren();
        CompartmentEditPart cfCompartment = children.stream().filter(CombinedFragmentCombinedFragmentCompartmentEditPart.class::isInstance).map(CombinedFragmentCombinedFragmentCompartmentEditPart.class::cast).findFirst().orElse(null);
        if (cfCompartment == null) {
            return Collections.emptyList();
        }
        List compartmentChildren = cfCompartment.getChildren();
        return compartmentChildren.stream().filter(part -> !(part instanceof IBorderItemEditPart)).filter(GraphicalEditPart.class::isInstance).map(GraphicalEditPart.class::cast).collect(Collectors.toList());
    }
}

