/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands.requests;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.tools.util.Iterables2;

public class RollingDeferredArrangeRequest
implements Runnable {
    private static ConcurrentMap<IArrangementContext, RollingDeferredArrangeRequest> deferredArrangements = new MapMaker().weakKeys().weakValues().makeMap();
    private final IArrangementContext context;
    private List<IAdaptable> viewAdapters;
    private volatile boolean cancelled;
    private AtomicBoolean bump = new AtomicBoolean();

    private RollingDeferredArrangeRequest(IArrangementContext context, Iterable<? extends IAdaptable> viewAdapters) {
        this.context = context;
        this.viewAdapters = Lists.newArrayList(viewAdapters);
    }

    public static RollingDeferredArrangeRequest post(IArrangementContext context, Iterable<? extends IAdaptable> viewAdapters) {
        RollingDeferredArrangeRequest result = (RollingDeferredArrangeRequest)deferredArrangements.get(context);
        if (result == null) {
            result = RollingDeferredArrangeRequest.rollup(context);
        }
        if (result != null) {
            result.addAll(viewAdapters);
        } else {
            result = new RollingDeferredArrangeRequest(context, viewAdapters);
            RollingDeferredArrangeRequest pending = deferredArrangements.putIfAbsent(context, result);
            if (pending != null) {
                pending.addAll(viewAdapters);
            } else {
                result.schedule();
            }
        }
        return result;
    }

    private static RollingDeferredArrangeRequest rollup(IArrangementContext context) {
        RollingDeferredArrangeRequest result = null;
        for (Map.Entry next : deferredArrangements.entrySet()) {
            if (!RollingDeferredArrangeRequest.isAncestor((IArrangementContext)next.getKey(), context)) continue;
            result = (RollingDeferredArrangeRequest)next.getValue();
            break;
        }
        if (result == null) {
            for (Map.Entry next : deferredArrangements.entrySet()) {
                IArrangementContext commonAncestor = RollingDeferredArrangeRequest.commonAncestor((IArrangementContext)next.getKey(), context);
                if (commonAncestor == null) continue;
                result = new RollingDeferredArrangeRequest(commonAncestor, ((RollingDeferredArrangeRequest)next.getValue()).viewAdapters);
                ((RollingDeferredArrangeRequest)next.getValue()).cancel();
                deferredArrangements.remove(next.getKey());
                deferredArrangements.put(commonAncestor, result);
                break;
            }
        }
        return result;
    }

    private static boolean isAncestor(IArrangementContext putativeAncestor, IArrangementContext context) {
        return RollingDeferredArrangeRequest.isAncestor(putativeAncestor.getHost(), context.getHost());
    }

    private static boolean isAncestor(EditPart putativeAncestor, EditPart editPart) {
        boolean result = false;
        EditPart next = editPart;
        while (!result && next != null) {
            result = next == putativeAncestor;
            next = next.getParent();
        }
        return result;
    }

    private static Comparator<EditPart> ancestorComparator() {
        return new Comparator<EditPart>(){

            @Override
            public int compare(EditPart o1, EditPart o2) {
                int result = 0;
                if (RollingDeferredArrangeRequest.isAncestor(o1, o2)) {
                    result = 1;
                } else if (RollingDeferredArrangeRequest.isAncestor(o2, o1)) {
                    result = -1;
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                return obj != null && obj.getClass() == this.getClass();
            }
        };
    }

    private static IArrangementContext commonAncestor(IArrangementContext context1, IArrangementContext context2) {
        IArrangementContext result = null;
        final EditPart ancestor = RollingDeferredArrangeRequest.commonAncestor(context1.getHost(), context2.getHost());
        if (ancestor != null) {
            final IArrangementContext executor = context1;
            result = new IArrangementContext(){

                @Override
                public EditPart getHost() {
                    return ancestor;
                }

                @Override
                public void execute(Command command) {
                    executor.execute(command);
                }
            };
        }
        return result;
    }

    private static EditPart commonAncestor(EditPart ep1, EditPart ep2) {
        EditPart result = null;
        if (ep1 != null && ep2 != null) {
            result = RollingDeferredArrangeRequest.isAncestor(ep1, ep2) ? ep1 : RollingDeferredArrangeRequest.commonAncestor(ep1.getParent(), ep2.getParent());
        }
        return result;
    }

    private void schedule() {
        DiagramHelper.asyncExec(this.context.getHost(), (Runnable)this);
    }

    @Override
    public void run() {
        if (this.bump.compareAndSet(true, false)) {
            this.schedule();
        } else if (deferredArrangements.remove(this.context, this) && !this.cancelled) {
            this.doArrange();
        }
    }

    public RollingDeferredArrangeRequest addAll(Iterable<? extends IAdaptable> viewAdapters) {
        this.bump();
        Iterables.addAll(this.viewAdapters, viewAdapters);
        return this;
    }

    void bump() {
        if (!this.cancelled) {
            this.bump.set(true);
        }
    }

    void cancel() {
        this.cancelled = true;
        this.bump.set(false);
    }

    protected void doArrange() {
        ListMultimap<EditPart, IAdaptable> toArrange = this.partition(this.viewAdapters);
        if (!toArrange.isEmpty()) {
            CompoundCommand arrange = new CompoundCommand("Arrange Views");
            for (EditPart targetEditPart : Iterables2.topoSort((Iterable)toArrange.keySet(), RollingDeferredArrangeRequest.ancestorComparator())) {
                ArrangeRequest request = new ArrangeRequest("arrange_deferred");
                request.setViewAdaptersToArrange(toArrange.get((Object)targetEditPart));
                Command command = targetEditPart.getCommand((Request)request);
                if (command == null || !command.canExecute()) continue;
                arrange.add(command);
            }
            if (!arrange.isEmpty()) {
                this.context.execute(arrange.unwrap());
            }
        }
    }

    private ListMultimap<EditPart, IAdaptable> partition(Iterable<? extends IAdaptable> viewAdapters) {
        ArrayListMultimap result = ArrayListMultimap.create();
        EditPartViewer viewer = this.context.getHost().getViewer();
        Map registry = viewer.getEditPartRegistry();
        for (IAdaptable iAdaptable : viewAdapters) {
            EditPart editPart;
            View view = this.resolveArrangeableView(iAdaptable);
            if (view == null || (editPart = (EditPart)registry.get(view)) == null) continue;
            EditPart parent = editPart.getParent();
            if (parent == null) {
                Activator.log.warn("Attempt to arrange the root edit part: " + String.valueOf(editPart));
                continue;
            }
            result.put((Object)parent, (Object)iAdaptable);
        }
        return result;
    }

    private View resolveArrangeableView(IAdaptable viewAdapter) {
        View result = null;
        View view = (View)viewAdapter.getAdapter(View.class);
        while (view != null) {
            if (view instanceof Shape || view instanceof Connector) {
                result = view;
                break;
            }
            view = (View)view.eContainer();
        }
        return result;
    }

    public static interface IArrangementContext {
        public EditPart getHost();

        public void execute(Command var1);
    }
}

