/**
 * Copyright (c) 2009-2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;
import xpt.GenModelUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class DeleteLinkCommand {
  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  public CharSequence newInstance(final GenLink it, final String requestVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newDeleteLinkCommand = this.newDeleteLinkCommand(it.getModelFacet(), it, requestVar);
    _builder.append(_newDeleteLinkCommand);
    return _builder;
  }

  public CharSequence newRequest(final GenLink it, final String requestVar, final String edgeVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newDestroyRequest = this.newDestroyRequest(it.getModelFacet(), it, requestVar, edgeVar);
    _builder.append(_newDestroyRequest);
    return _builder;
  }

  protected CharSequence _newDeleteLinkCommand(final LinkModelFacet it, final GenLink genLink, final String requestVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unsupported model facet: " + it) + ", link: ") + genLink));
    return _builder;
  }

  protected CharSequence _newDeleteLinkCommand(final TypeLinkModelFacet it, final GenLink genLink, final String requestVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newDeleteLinkWithClassCommand = this.newDeleteLinkWithClassCommand(it, genLink, requestVar);
    _builder.append(_newDeleteLinkWithClassCommand);
    return _builder;
  }

  protected CharSequence _newDeleteLinkCommand(final FeatureLinkModelFacet it, final GenLink genLink, final String requestVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newDeleteReferenceLinkCommand = this.newDeleteReferenceLinkCommand(it, genLink, requestVar);
    _builder.append(_newDeleteReferenceLinkCommand);
    return _builder;
  }

  public CharSequence newDeleteReferenceLinkCommand(final FeatureLinkModelFacet it, final GenLink genLink, final String destroyReferenceRequest) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyReferenceCommand(");
    _builder.append(destroyReferenceRequest);
    _builder.append(") ");
    {
      boolean _isContains = this._genModelUtils_qvto.isContains(it.getMetaFeature());
      if (_isContains) {
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor progressMonitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.EObject referencedObject = getReferencedObject();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.resource.Resource resource = referencedObject.eResource();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.common.core.command.CommandResult result = super.doExecuteWithResult(progressMonitor, info);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (resource != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("resource.getContents().add(referencedObject);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence newDeleteLinkWithClassCommand(final TypeLinkModelFacet it, final GenLink genLink, final String destroyElementRequest) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(");
    _builder.append(destroyElementRequest);
    _builder.append(")");
    return _builder;
  }

  protected CharSequence _newDestroyRequest(final LinkModelFacet it, final GenLink genLink, final String requestVar, final String edgeVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(
      ((("Unsupported model facet: " + it) + ", link: ") + genLink));
    return _builder;
  }

  protected CharSequence _newDestroyRequest(final TypeLinkModelFacet it, final GenLink genLink, final String requestVar, final String edgeVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest ");
    _builder.append(requestVar);
    _builder.append(" = new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest(");
    _builder.append(edgeVar);
    _builder.append(".getElement(), false);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * FIXME source not always container, target is not always referenced object. And containerReference is known at generation time
   */
  protected CharSequence _newDestroyRequest(final FeatureLinkModelFacet it, final GenLink genLink, final String requestVar, final String edgeVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest ");
    _builder.append(requestVar);
    _builder.append(" = new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest(");
    _builder.append(edgeVar);
    _builder.append(".getSource().getElement(), null, ");
    _builder.append(edgeVar);
    _builder.append(".getTarget().getElement(), false);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence newDeleteLinkCommand(final LinkModelFacet it, final GenLink genLink, final String requestVar) {
    if (it instanceof FeatureLinkModelFacet) {
      return _newDeleteLinkCommand((FeatureLinkModelFacet)it, genLink, requestVar);
    } else if (it instanceof TypeLinkModelFacet) {
      return _newDeleteLinkCommand((TypeLinkModelFacet)it, genLink, requestVar);
    } else if (it != null) {
      return _newDeleteLinkCommand(it, genLink, requestVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, genLink, requestVar).toString());
    }
  }

  public CharSequence newDestroyRequest(final LinkModelFacet it, final GenLink genLink, final String requestVar, final String edgeVar) {
    if (it instanceof FeatureLinkModelFacet) {
      return _newDestroyRequest((FeatureLinkModelFacet)it, genLink, requestVar, edgeVar);
    } else if (it instanceof TypeLinkModelFacet) {
      return _newDestroyRequest((TypeLinkModelFacet)it, genLink, requestVar, edgeVar);
    } else if (it != null) {
      return _newDestroyRequest(it, genLink, requestVar, edgeVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, genLink, requestVar, edgeVar).toString());
    }
  }
}
