/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;

public class CleanDiagramHelper {
    protected static CleanDiagramHelper cleanDiagramHelper;
    protected ArrayList<View> viewToRemove = new ArrayList();
    protected DiagramEditPart selectedElement;

    public static CleanDiagramHelper getInstance() {
        if (cleanDiagramHelper == null) {
            cleanDiagramHelper = new CleanDiagramHelper();
        }
        return cleanDiagramHelper;
    }

    public void run(DiagramEditPart diagramEditPart) {
        this.selectedElement = diagramEditPart;
        this.scan((EditPart)diagramEditPart);
        this.deleteUnknownViews();
    }

    protected void deleteUnknownViews() {
        int i = 0;
        while (i < this.viewToRemove.size()) {
            Activator.getDefault().logInfo("Remove " + this.viewToRemove.get(i));
            this.executeCommand(this.getDeleteViewCommand(this.viewToRemove.get(i)));
            ++i;
        }
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        DiagramEditPart ep = this.selectedElement;
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)this.selectedElement, (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(this.selectedElement.getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"executeCommand", (Throwable)e);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
        }
    }

    protected EditPart tryToConstruct(EditPart parent, View child) {
        if (this.selectedElement.getViewer().getEditPartFactory().createEditPart(parent, (Object)child) instanceof DefaultNodeEditPart) {
            this.viewToRemove.add(child);
        } else {
            Object object = this.selectedElement.getViewer().getEditPartRegistry().get(child);
            if (object instanceof EditPart) {
                return (EditPart)object;
            }
        }
        return null;
    }

    protected Command getDeleteViewCommand(View view) {
        TransactionalEditingDomain editingDomain = this.selectedElement.getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, view));
    }

    protected void scan(EditPart editPart) {
        View parentView = (View)editPart.getModel();
        TreeIterator iterator = parentView.eAllContents();
        while (iterator.hasNext()) {
            EObject currentObject = (EObject)iterator.next();
            if (!(currentObject instanceof View)) continue;
            this.tryToConstruct(editPart, (View)currentObject);
        }
    }
}

