/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.expression;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;

public class ExpressionList
extends WritableList
implements IChangeListener,
ICommitListener,
IObserving {
    private List<Expression> expressions = this.wrappedList;
    private IObservableList languages;
    private IObservableList bodies;
    private boolean ignoreChanges = false;
    private IChangeListener nestedChangeListener;

    public ExpressionList(IObservableList languages, IObservableList bodies, IChangeListener nestedChangeListener) {
        super(new LinkedList(), Expression.class);
        this.languages = languages;
        this.bodies = bodies;
        languages.addChangeListener((IChangeListener)this);
        bodies.addChangeListener((IChangeListener)this);
        this.nestedChangeListener = nestedChangeListener;
        this.UMLToExpression();
    }

    public ExpressionList(IObservableList languages, IObservableList bodies) {
        this(languages, bodies, null);
    }

    private void UMLToExpression() {
        int maxSize = Math.max(this.languages.size(), this.bodies.size());
        Iterator languageIterator = this.languages.iterator();
        Iterator bodyIterator = this.bodies.iterator();
        int i = 0;
        while (i < maxSize) {
            Expression expression;
            if (i < this.expressions.size()) {
                expression = this.expressions.get(i);
            } else {
                expression = new Expression();
                if (this.nestedChangeListener != null) {
                    expression.addChangeListener(this.nestedChangeListener);
                }
                this.expressions.add(expression);
            }
            if (languageIterator.hasNext()) {
                expression.setLanguage((String)languageIterator.next());
            }
            if (bodyIterator.hasNext()) {
                expression.setBody((String)bodyIterator.next());
            }
            ++i;
        }
        i = maxSize;
        while (i < this.expressions.size()) {
            this.expressions.remove(i);
            ++i;
        }
    }

    public void handleChange(ChangeEvent event) {
        if (!this.ignoreChanges) {
            this.UMLToExpression();
        }
    }

    public void commit(AbstractEditor editor) {
        this.ignoreChanges = true;
        this.expressionToUML();
        if (this.languages instanceof ICommitListener) {
            ((ICommitListener)this.languages).commit(editor);
        }
        if (this.bodies instanceof ICommitListener) {
            ((ICommitListener)this.bodies).commit(editor);
        }
        this.ignoreChanges = false;
    }

    void expressionToUML() {
        int fillLanguage = 0;
        int fillBody = 0;
        this.languages.clear();
        this.bodies.clear();
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (expression == null) {
                iterator.remove();
                continue;
            }
            String language = expression.getLanguage();
            String body = expression.getBody();
            if (language == null && body == null) {
                iterator.remove();
                continue;
            }
            if (language != null && body != null) {
                this.addLanguage(language, fillLanguage);
                this.addBody(body, fillBody);
                fillLanguage = 0;
                fillBody = 0;
            }
            if (language == null) {
                ++fillLanguage;
                this.addBody(body, fillBody);
                fillBody = 0;
                continue;
            }
            if (body != null) continue;
            ++fillBody;
            this.addLanguage(language, fillLanguage);
            fillLanguage = 0;
        }
    }

    private void addBody(String body, int fillBody) {
        int i = 0;
        while (i < fillBody) {
            this.bodies.add((Object)"");
            ++i;
        }
        this.bodies.add((Object)body);
    }

    private void addLanguage(String language, int fillLanguage) {
        int i = 0;
        while (i < fillLanguage) {
            this.languages.add((Object)"");
            ++i;
        }
        this.languages.add((Object)language);
    }

    public Object getObserved() {
        return this.languages instanceof IObserving ? ((IObserving)this.languages).getObserved() : (this.bodies instanceof IObserving ? ((IObserving)this.bodies).getObserved() : null);
    }

    public static class Expression
    extends AbstractObservable {
        String language;
        String body;

        public Expression() {
            super(Realm.getDefault());
        }

        public String getLanguage() {
            return this.language;
        }

        public String getBody() {
            return this.body;
        }

        public void setLanguage(String language) {
            if (!StringHelper.equals((String)language, (String)this.language)) {
                this.language = language;
                this.fireChange();
            }
        }

        public void setBody(String body) {
            if (!StringHelper.equals((String)body, (String)this.body)) {
                this.body = body;
                this.fireChange();
            }
        }

        public String toString() {
            return this.language;
        }

        public int hashCode() {
            return this.language == null ? 0 : this.language.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Expression)) {
                return false;
            }
            Expression otherExpression = (Expression)((Object)other);
            if (otherExpression.getLanguage() == null) {
                return this.getLanguage() == null;
            }
            return otherExpression.getLanguage().equals(this.getLanguage());
        }

        public boolean isStale() {
            return false;
        }
    }
}

