/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.AbstractImageFigure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class VerticalLabel
extends AbstractImageFigure {
    private Image img;
    private String myText;
    private Font myImageFont;
    private Color myForegroundColor;
    private Color myBackgroundColor;

    protected void paintFigure(Graphics g) {
        Image image = this.getImage();
        if (image != null) {
            g.drawImage(image, this.bounds.x, this.bounds.y);
        }
    }

    public void addNotify() {
        this.updateImage();
        super.addNotify();
    }

    public void removeNotify() {
        if (this.img != null) {
            this.img.dispose();
            this.img = null;
        }
        super.removeNotify();
    }

    public Image getImage() {
        boolean update = false;
        if (this.myImageFont != this.getFont()) {
            this.myImageFont = this.getFont();
            update = true;
        }
        if (VerticalLabel.needsUpdate(this.myForegroundColor, this.getForegroundColor())) {
            this.myForegroundColor = this.getForegroundColor();
            update = true;
        }
        if (VerticalLabel.needsUpdate(this.myBackgroundColor, this.getBackgroundColor())) {
            this.myBackgroundColor = this.getBackgroundColor();
            update = true;
        }
        if (update) {
            this.updateImage();
        }
        return this.img;
    }

    public void setText(String text) {
        this.myText = text;
        this.updateImage();
    }

    public String getText() {
        return this.myText;
    }

    public void updateImage() {
        if (this.img != null) {
            this.img.dispose();
            this.img = null;
        }
        if (this.getText() == null || this.getFont() == null) {
            return;
        }
        this.setImage(VerticalLabel.createRotatedImageOfString(this.getText(), this.getFont(), this.getForegroundColor(), this.getBackgroundColor(), this.isOpaque()));
    }

    private void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.revalidate();
        this.notifyImageChanged();
        this.repaint();
    }

    public static Image createRotatedImageOfString(String string, Font font, Color foreground, Color background, boolean opaque) {
        Display display = Display.getDefault();
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)font);
        Dimension strSize = FigureUtilities.getStringExtents((String)string, (Font)font);
        int height = strSize.width;
        int width = metrics.getAscent() + metrics.getDescent() + metrics.getLeading();
        ImageData data = new ImageData(width, height, 32, new PaletteData(65280, 0xFF0000, -16777216));
        if (!opaque) {
            data.transparentPixel = data.palette.getPixel(background.getRGB());
        }
        Image image = new Image((Device)display, data);
        GC gc = new GC((Drawable)image);
        gc.setFont(font);
        gc.setBackground(background);
        gc.fillRectangle(image.getBounds());
        gc.setForeground(foreground);
        Transform transform = new Transform((Device)Display.getCurrent());
        transform.translate(0.0f, (float)height);
        transform.rotate(-90.0f);
        gc.setTransform(transform);
        gc.drawString(string, 0, 0, true);
        gc.dispose();
        return image;
    }

    private static final boolean needsUpdate(Color cachedColor, Color actualColor) {
        if (cachedColor == null && actualColor == null) {
            return false;
        }
        return cachedColor == null || !cachedColor.equals((Object)actualColor);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.img != null) {
            return new Rectangle(this.img.getBounds()).getSize();
        }
        return super.getPreferredSize(wHint, hHint);
    }
}

