/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.properties.ui.xwt.XWTSection;
import org.eclipse.papyrus.infra.tools.databinding.IMultipleObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class ViewEditor
extends AbstractPropertyEditor {
    private String viewPath;
    private Composite self;
    private Map<Section, EditorSection> sections = new HashMap<Section, EditorSection>();
    private DisplayEngine displayEngine;
    private IDataSourceListener dataSourceListener;

    public ViewEditor(Composite parent, int style) {
        this.self = new Composite(parent, 0);
        PropertiesLayout layout = new PropertiesLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        this.addDisposeListener((Control)this.self);
    }

    private void addDisposeListener(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewEditor.this.disposeDisplayEngine();
            }
        });
    }

    private void disposeDisplayEngine() {
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
            this.displayEngine = null;
            this.sections.clear();
        }
    }

    @Override
    public void checkInput() {
        if (this.propertyPath != null && this.input != null && this.viewPath != null) {
            this.display();
        }
    }

    @Override
    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
        super.unhookDataSourceListener(oldInput);
    }

    @Override
    protected void hookDataSourceListener(DataSource newInput) {
        super.hookDataSourceListener(newInput);
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                @Override
                public void dataSourceChanged(DataSourceChangedEvent event) {
                    if (ViewEditor.this.self != null && !ViewEditor.this.self.isDisposed()) {
                        ViewEditor.this.self.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).ViewEditor.this.self.isDisposed()) {
                                    ViewEditor.this.checkInput();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.dataSourceListener;
    }

    public void setNumColumns(int numColumns) {
        ((PropertiesLayout)this.self.getLayout()).numColumns = numColumns;
    }

    public int getNumColumns() {
        return ((PropertiesLayout)this.self.getLayout()).numColumns;
    }

    public void setView(String viewPath) {
        this.viewPath = viewPath;
        this.checkInput();
    }

    public String getView() {
        return this.viewPath;
    }

    private View resolveView() {
        String contextName = this.viewPath.substring(0, this.viewPath.indexOf(":"));
        String viewName = this.viewPath.substring(this.viewPath.indexOf(":") + 1);
        Context context = PropertiesRuntime.getConfigurationManager().getContext(contextName);
        for (View view : context.getViews()) {
            if (!view.getName().equals(viewName)) continue;
            return view;
        }
        return null;
    }

    private void display() {
        View view = this.resolveView();
        if (view == null) {
            Activator.log.warn("Unabled to resolve view : " + this.viewPath);
            return;
        }
        IObservable observable = this.getInputObservable();
        if (observable == null) {
            return;
        }
        if (this.displayEngine == null) {
            this.displayEngine = new DefaultDisplayEngine(false);
        }
        int index = 0;
        if (observable instanceof IObservableValue) {
            IObservableValue observableValue = (IObservableValue)observable;
            if (observableValue instanceof IMultipleObservableValue) {
                IMultipleObservableValue multipleObservable = (IMultipleObservableValue)observableValue;
                this.display(this.displayEngine, multipleObservable.getObservedValues(), view, (Object)index++);
            } else {
                Object value = observableValue.getValue();
                this.display(this.displayEngine, value, view, (Object)index++);
            }
        } else if (observable instanceof IObservableList) {
            IObservableList observableList = (IObservableList)observable;
            for (Object value : observableList) {
                this.display(this.displayEngine, value, view, (Object)index++);
            }
        }
        this.purgeUnusedSections(index);
        Composite next = this.self;
        while (next != null) {
            if (next.getParent() instanceof ScrolledComposite) {
                final ScrolledComposite scrolled = (ScrolledComposite)next.getParent();
                next.layout();
                scrolled.layout();
                scrolled.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (scrolled.isDisposed()) {
                            return;
                        }
                        ViewEditor.this.resizeScrolledComposite(scrolled);
                    }
                });
            }
            next = next.getParent();
        }
        this.updateControls();
    }

    private void purgeUnusedSections(int maxDiscriminator) {
        Iterator<Section> iter = this.sections.keySet().iterator();
        while (iter.hasNext()) {
            Section section = iter.next();
            Object discriminator = DefaultDisplayEngine.getDiscriminator(section);
            if (!(discriminator instanceof Number) || ((Number)discriminator).intValue() < maxDiscriminator) continue;
            this.sections.get(section).dispose();
            iter.remove();
        }
    }

    private void resizeScrolledComposite(ScrolledComposite scrolled) {
        ScrollBar hbar;
        Point sizeConstraint = scrolled.getContent().getSize();
        sizeConstraint = scrolled.getContent().computeSize(-1, -1);
        scrolled.setMinSize(sizeConstraint);
        Rectangle clientArea = scrolled.getClientArea();
        ScrollBar vbar = scrolled.getVerticalBar();
        if (vbar != null) {
            vbar.setPageIncrement(clientArea.height - 5);
        }
        if ((hbar = scrolled.getHorizontalBar()) != null) {
            hbar.setPageIncrement(clientArea.width - 5);
        }
    }

    protected void display(DisplayEngine display, Object data, View view, Object discriminator) {
        this.display(display, Collections.singletonList(data), view, discriminator);
    }

    protected void display(DisplayEngine display, List<Object> selectedElements, View view, Object discriminator) {
        for (Section section : view.getSections()) {
            EditorSection editorSection = this.sections.get(section = DefaultDisplayEngine.discriminate(section, discriminator));
            if (editorSection == null) {
                editorSection = new EditorSection(new XWTSection(section, view, display));
                this.sections.put(section, editorSection);
            }
            StructuredSelection selection = new StructuredSelection(selectedElements);
            editorSection.setInput((ISelection)selection);
        }
    }

    protected void updateControls() {
        Control[] controlArray = this.self.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control container = controlArray[n2];
            if (container instanceof Composite) {
                Control[] controlArray2 = ((Composite)container).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control control = controlArray2[n4];
                    if (control instanceof AbstractEditor) {
                        AbstractEditor editor = (AbstractEditor)control;
                        editor.setReadOnly(this.getReadOnly() || editor.isReadOnly());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.self.setEnabled(!this.getReadOnly());
    }

    @Override
    protected IObservable getInputObservable() {
        return this.input.getObservable(this.propertyPath);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.updateControls();
    }

    @Override
    protected void doBinding() {
    }

    @Override
    public Control getControl() {
        return this.self;
    }

    private class EditorSection {
        private final XWTSection xwt;
        private final Composite sectionComposite;

        EditorSection(XWTSection xwt) {
            this.xwt = xwt;
            this.sectionComposite = new Composite(ViewEditor.this.self, 0);
            xwt.createControls(this.sectionComposite, null);
        }

        void dispose() {
            if (!this.sectionComposite.isDisposed()) {
                this.xwt.dispose();
                this.sectionComposite.dispose();
            }
        }

        void setInput(ISelection selection) {
            this.xwt.setInput(null, selection);
            this.xwt.refresh();
        }
    }
}

