/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.junit.Assert;

public class TableUtils {
    public static Table getNotationFirstTable(ModelSet modelSet, String tableName) {
        IModel notationModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        AbstractBaseModel notationBaseModel = null;
        if (!(notationModel instanceof AbstractBaseModel)) {
            Assert.fail((String)"notation model is not an abstract base model");
            return null;
        }
        notationBaseModel = (AbstractBaseModel)notationModel;
        Assert.assertTrue((String)"notation resource contains nothing", (notationBaseModel.getResource().getContents().size() >= 1 ? 1 : 0) != 0);
        for (EObject eObject : notationBaseModel.getResource().getContents()) {
            if (!(eObject instanceof Table) || !tableName.equals(((Table)eObject).getName())) continue;
            return (Table)eObject;
        }
        return null;
    }

    public static Collection<Table> getAllNotationTable(ModelSet modelSet, String tableName) {
        IModel notationModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        ArrayList<Table> tableList = new ArrayList<Table>();
        AbstractBaseModel notationBaseModel = null;
        if (!(notationModel instanceof AbstractBaseModel)) {
            Assert.fail((String)"notation model is not an abstract base model");
            return null;
        }
        notationBaseModel = (AbstractBaseModel)notationModel;
        Assert.assertTrue((String)"notation resource contains nothing", (notationBaseModel.getResource().getContents().size() >= 1 ? 1 : 0) != 0);
        for (EObject eObject : notationBaseModel.getResource().getContents()) {
            if (!(eObject instanceof Table) || !tableName.equals(((Table)eObject).getName())) continue;
            tableList.add((Table)eObject);
        }
        return tableList;
    }
}

