/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomStateInvariantLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeCommentCreationEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.StateInvariantResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StateInvariantFigure;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomStateInvariantEditPart
extends StateInvariantEditPart
implements IPapyrusEditPart {
    public static final int DEFAULT_MARGIN = 0;
    public static final String TOP_MARGIN_PROPERTY = "TopMarginLabel";
    public static final String LEFT_MARGIN_PROPERTY = "LeftMarginLabel";
    public static final String BOTTOM_MARGIN_PROPERTY = "BottomMarginLabel";
    public static final String RIGHT_MARGIN_PROPERTY = "RightMarginLabel";
    private NotificationHelper notifierHelper = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            CustomStateInvariantEditPart.this.handleNotificationEvent(msg);
        }
    });

    public CustomStateInvariantEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        EObject element = this.resolveSemanticElement();
        if (element instanceof StateInvariant && ((StateInvariant)element).getInvariant() != null) {
            this.notifierHelper.listenObject((Notifier)((StateInvariant)element).getInvariant());
        }
    }

    public void deactivate() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof StateInvariant && ((StateInvariant)element).getInvariant() != null) {
            this.notifierHelper.unlistenObject((Notifier)((StateInvariant)element).getInvariant());
        }
        super.deactivate();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("AppliedStereotypeComment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicyEx());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        if (this.getModel() != null && this.getModel() == notifier) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            }
        } else if (UMLPackage.eINSTANCE.getStateInvariant_Invariant() == feature) {
            if (1 == notification.getEventType() || 2 == notification.getEventType()) {
                this.notifierHelper.unlistenObject((Notifier)notification.getOldValue());
                this.notifierHelper.listenObject((Notifier)notification.getNewValue());
            }
            this.refreshLabels();
        } else if (notifier != null && (element = this.resolveSemanticElement()) instanceof StateInvariant && notifier == ((StateInvariant)element).getInvariant()) {
            this.refreshLabels();
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new StateInvariantResizableEditPolicy();
    }

    protected List getModelChildren() {
        ArrayList<DecorationNode> modelChildren = new ArrayList<DecorationNode>(super.getModelChildren());
        boolean hasInvariantView = false;
        for (Object e : modelChildren) {
            if (!(e instanceof View) || !UMLVisualIDRegistry.getType("StateInvariant_ConstraintLabel").equals(((View)e).getType())) continue;
            hasInvariantView = true;
            break;
        }
        if (!hasInvariantView) {
            View view = this.getNotationView();
            DecorationNode guardNode = NotationFactory.eINSTANCE.createDecorationNode();
            guardNode.setType(UMLVisualIDRegistry.getType("StateInvariant_ConstraintLabel"));
            modelChildren.add(guardNode);
        }
        return modelChildren;
    }

    protected void setFontColor(Color color) {
        super.setFontColor(color);
        StateInvariantFigure primaryShape = this.getPrimaryShape();
        if (primaryShape != null && primaryShape.getConstraintContentContainer() != null) {
            primaryShape.getConstraintContentContainer().setForegroundColor(color);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshTransparency();
        this.refreshLabels();
        this.refreshLabelMargin();
    }

    private void refreshLabelMargin() {
        IFigure figure = null;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        Object model = this.getModel();
        if (model instanceof View) {
            leftMargin = NotationUtils.getIntValue((View)((View)model), (String)LEFT_MARGIN_PROPERTY, (int)0);
            rightMargin = NotationUtils.getIntValue((View)((View)model), (String)RIGHT_MARGIN_PROPERTY, (int)0);
            topMargin = NotationUtils.getIntValue((View)((View)model), (String)TOP_MARGIN_PROPERTY, (int)0);
            bottomMargin = NotationUtils.getIntValue((View)((View)model), (String)BOTTOM_MARGIN_PROPERTY, (int)0);
        }
        if (this instanceof IPapyrusEditPart) {
            figure = this.getPrimaryShape();
            List labelChildFigureList = FigureUtils.findChildFigureInstances((IFigure)figure, IPapyrusWrappingLabel.class);
            for (IPapyrusWrappingLabel label : labelChildFigureList) {
                if (label == null) continue;
                label.setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            }
        }
    }

    protected void refreshLabels() {
        List parts = this.getChildren();
        for (Object p : parts) {
            if (!(p instanceof CustomStateInvariantLabelEditPart)) continue;
            ((CustomStateInvariantLabelEditPart)((Object)p)).refresh();
        }
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void refreshBounds() {
        if (this.getBorderItemLocator() != null) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point loc = new Point(x, y);
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension size = new Dimension(width, height);
            this.getFigure().setBounds(new Rectangle(loc, size));
            this.getBorderItemLocator().setConstraint(new Rectangle(loc, size));
        } else {
            super.refreshBounds();
        }
    }

    @Override
    public StateInvariantFigure getPrimaryShape() {
        return (StateInvariantFigure)this.primaryShape;
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CustomStateInvariantLabelEditPart) {
            ((CustomStateInvariantLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getInvariantFigure());
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CustomStateInvariantLabelEditPart) {
            return true;
        }
        return super.removeFixedChild(childEditPart);
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new StateInvariantFigure(this.getMapMode());
        return this.primaryShape;
    }
}

