/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.observables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ForkNodeEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.JoinNodeEditPart;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;

public class SwitchOrientationObservableValue
extends AbstractObservableValue<Boolean> {
    private TransactionalEditingDomain editingDomain;
    private List<EditPart> activityNodesEP;

    public SwitchOrientationObservableValue(TransactionalEditingDomain editingDomain, Collection<EditPart> activityNodesEP) {
        this.activityNodesEP = new ArrayList<EditPart>(activityNodesEP.size());
        this.activityNodesEP.addAll(activityNodesEP);
        this.editingDomain = editingDomain;
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected Boolean doGetValue() {
        return true;
    }

    protected void doSetValue(Boolean value) {
        CompositeCommand globalCommand = new CompositeCommand(CustomMessages.ForkJoinSegmentSwitchOrientation_actionLabel);
        for (EditPart part : this.activityNodesEP) {
            Object view = null;
            RoundedCompartmentFigure figure = null;
            if (part instanceof JoinNodeEditPart) {
                view = ((JoinNodeEditPart)part).getModel();
                figure = ((JoinNodeEditPart)part).getPrimaryShape();
            } else if (part instanceof ForkNodeEditPart) {
                view = ((ForkNodeEditPart)part).getModel();
                figure = ((ForkNodeEditPart)part).getPrimaryShape();
            }
            if (!(view instanceof View) || figure == null) continue;
            SwitchSegmentOrientation switchCom = new SwitchSegmentOrientation(this.editingDomain, (Figure)figure, (View)view);
            globalCommand.add((IUndoableOperation)switchCom);
        }
        if (!globalCommand.isEmpty() && globalCommand.canExecute()) {
            this.editingDomain.getCommandStack().execute(GEFtoEMFCommandWrapper.wrap((Command)new ICommandProxy((ICommand)globalCommand)));
        }
    }

    private class SwitchSegmentOrientation
    extends AbstractTransactionalCommand {
        private Figure selectedFigure;
        private View selectedView;

        SwitchSegmentOrientation(TransactionalEditingDomain domain, Figure figure, View view) {
            super(domain, CustomMessages.ForkJoinSegmentSwitchOrientation_actionLabel, null);
            this.selectedFigure = null;
            this.selectedView = null;
            this.selectedFigure = figure;
            this.selectedView = view;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.selectedFigure == null || this.selectedView == null) {
                return CommandResult.newCancelledCommandResult();
            }
            Dimension newSize = this.selectedFigure.getSize().getTransposed();
            Point newLocation = this.selectedFigure.getLocation().getCopy();
            newLocation.translate((newSize.height - newSize.width) / 2, (newSize.width - newSize.height) / 2);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)newLocation.x);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)newLocation.y);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)newSize.width);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)newSize.height);
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return this.selectedFigure != null && this.selectedView != null;
        }

        public boolean canRedo() {
            return this.selectedFigure != null && this.selectedView != null;
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doExecute(monitor, info);
        }

        protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doExecute(monitor, info);
        }
    }
}

