/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.helper.EditorHyperLinkHelper;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui.EditorLookForEditorShell;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkShell;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.swt.widgets.Shell;

public class EditorHyperLinkEditorShell
extends AbstractEditHyperlinkShell {
    protected boolean usedefaultTooltip = true;
    protected HyperLinkEditor hyperLinkEditor;
    private IPageIconsRegistry editorRegistry;
    protected final EObject amodel;

    public EditorHyperLinkEditorShell(Shell parentShell, IPageIconsRegistry editorFactoryRegistry, EObject model) {
        super(parentShell, true);
        this.amodel = model;
        this.editorRegistry = editorFactoryRegistry;
    }

    protected void contentsCreated() {
        this.getObjectLabel().setText(Messages.EditorHyperLinkEditorShell_View);
        this.updateFields();
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabelText().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        }
    }

    private void updateFields() {
        if (this.hyperLinkEditor != null) {
            if (this.getObjectLabelText() != null) {
                this.getObjectLabelText().setText(this.getLabel(this.hyperLinkEditor.getObject()));
            }
            if (this.getTooltipInputText() != null) {
                this.getTooltipInputText().setText(this.hyperLinkEditor.getTooltipText());
                if (this.getTooltipInputText().getText().equals(this.getObjectLabelText().getText())) {
                    this.usedefaultTooltip = true;
                }
            }
        }
    }

    private String getLabel(Object object) {
        String result = null;
        ILabelProvider labelProvider = null;
        try {
            try {
                labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry(this.amodel).getService(LabelProviderService.class)).getLabelProvider();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
                labelProvider = new LabelProvider();
            }
            result = labelProvider.getText(this.hyperLinkEditor.getObject());
        }
        finally {
            if (labelProvider != null) {
                labelProvider.dispose();
            }
        }
        return result;
    }

    protected void onSearch() {
        EditorLookForEditorShell editorLookForDiagram = new EditorLookForEditorShell((IShellProvider)this, this.editorRegistry, this.amodel);
        editorLookForDiagram.open();
        Object selection = editorLookForDiagram.getSelectedEditor();
        if (selection != null) {
            EditorHyperLinkHelper helper = new EditorHyperLinkHelper();
            this.hyperLinkEditor = helper.getHyperLinkObjectFor(selection);
            Assert.isNotNull((Object)((Object)this.hyperLinkEditor), (String)NLS.bind((String)Messages.EditorHyperLinkEditorShell_ICanFindTheHyperLinkEditorObject, (Object)selection));
            this.hyperLinkEditor.setObject(selection);
            this.getObjectLabelText().setText(this.getLabel(selection));
            if (this.usedefaultTooltip) {
                this.getTooltipInputText().setText(this.getObjectLabelText().getText());
            }
        }
    }

    protected void onUseDefaultTooltip() {
        this.usedefaultTooltip = this.getUseDefaultCheckBox().getSelection();
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        } else {
            this.getTooltipInputText().setEditable(true);
        }
    }

    protected void cancelPressed() {
        this.hyperLinkEditor = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.hyperLinkEditor != null) {
            this.hyperLinkEditor.setTooltipText(this.getTooltipInputText().getText().trim());
            if (this.hyperLinkEditor.getObject() == null) {
                this.hyperLinkEditor = null;
            }
        }
        super.okPressed();
    }

    public HyperLinkEditor getHyperLinkEditor() {
        return this.hyperLinkEditor;
    }

    public void setHyperLinkEditor(HyperLinkEditor hyperLinkEditor) {
        this.hyperLinkEditor = hyperLinkEditor;
        this.updateFields();
    }
}

