/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.papyrus.dev.project.management.internal.operations.DependencyKind;
import org.eclipse.papyrus.dev.project.management.internal.operations.VersionRules;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesOperation;
import org.osgi.framework.VersionRange;

public class DependencyAnalysisContext {
    private final Map<String, BundleAnalysis> bundles = new HashMap<String, BundleAnalysis>();
    private final Map<String, BundleAnalysis> packageProviders = new HashMap<String, BundleAnalysis>();
    private final VersionRules versionRules = new VersionRules();
    private final Deque<SubMonitor> monitorStack = new LinkedList<SubMonitor>();
    private SubMonitor currentMonitor;
    private final Set<BundleAnalysis> roots;

    public DependencyAnalysisContext(Collection<? extends IFile> bundleManifests) {
        this.pushMonitor((IProgressMonitor)new NullProgressMonitor());
        this.roots = Collections.unmodifiableSet(this.init(bundleManifests));
    }

    private Set<BundleAnalysis> init(Collection<? extends IFile> bundleManifests) {
        return bundleManifests.stream().map(this::getBundleID).filter(Objects::nonNull).map(this::internalGetBundle).map(BundleAnalysis::checkCycle).collect(Collectors.toSet());
    }

    private String getBundleID(IFile manifest) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)manifest.getProject());
        return model == null ? null : model.getPluginBase().getId();
    }

    public Set<BundleAnalysis> getAnalysisRoots() {
        return this.roots;
    }

    public boolean isAnalysisRoot(String bundleID) {
        return this.roots.contains(this.internalGetBundle(bundleID));
    }

    public BundleAnalysis getBundle(String bundleID) {
        return this.internalGetBundle(bundleID).analyze();
    }

    private BundleAnalysis internalGetBundle(String bundleID) {
        return this.bundles.computeIfAbsent(bundleID, string -> new BundleAnalysis((String)string));
    }

    public BundleAnalysis getProvidingBundle(String packageName) {
        if (this.packageProviders.containsKey(packageName)) {
            return this.packageProviders.get(packageName);
        }
        BundleAnalysis bundleAnalysis = this.findPackageProvider(packageName);
        this.packageProviders.put(packageName, bundleAnalysis);
        return bundleAnalysis;
    }

    private BundleAnalysis findPackageProvider(String packageName) {
        return new ArrayList<BundleAnalysis>(this.bundles.values()).stream().map(BundleAnalysis::getAPIExports).filter(api -> api.exports(packageName)).findAny().map(APIExports::getBundle).orElse(null);
    }

    public final void pushMonitor(IProgressMonitor monitor) {
        this.currentMonitor = monitor instanceof SubMonitor ? (SubMonitor)monitor : SubMonitor.convert((IProgressMonitor)monitor);
        this.monitorStack.push(this.currentMonitor);
    }

    public final void popMonitor() {
        this.monitorStack.pop();
        this.currentMonitor = this.monitorStack.peek();
    }

    public class APIExports {
        private final String bundleID;
        private VersionRange compatibleVersionRange;
        private Set<String> exports;
        private Map<String, BundleAnalysis> exposedDependencies;
        private Set<BundleAnalysis> missingReexports;

        private APIExports(String bundleID) {
            this.bundleID = bundleID;
        }

        public BundleAnalysis getBundle() {
            return DependencyAnalysisContext.this.internalGetBundle(this.bundleID);
        }

        public VersionRange getCompatibleVersionRange() {
            return this.compatibleVersionRange;
        }

        public boolean exports(String packageName) {
            this.analyze();
            return this.exports.contains(packageName);
        }

        public boolean isExposed(String bundleID) {
            this.analyze();
            return this.exposedDependencies.containsKey(bundleID);
        }

        public Set<BundleAnalysis> getExposedDependencies() {
            this.analyze();
            return new HashSet<BundleAnalysis>(this.exposedDependencies.values());
        }

        public Set<BundleAnalysis> getMissingReexports() {
            if (this.missingReexports == null) {
                this.missingReexports = this.getExposedDependencies().stream().filter(bundle -> !this.getBundle().isReexported(bundle.getBundleID())).filter(bundle -> !this.getBundle().hasDependency(bundle.getBundleID())).filter(bundle -> !this.isReexportedByExposedDependency((BundleAnalysis)bundle)).collect(Collectors.toCollection(() -> new TreeSet<BundleAnalysis>(Comparator.comparing(BundleAnalysis::getBundleID))));
            }
            return this.missingReexports;
        }

        void recomputeMissingReexports() {
            this.missingReexports = null;
        }

        private APIExports analyze() {
            if (this.exposedDependencies == null) {
                this.exposedDependencies = new HashMap<String, BundleAnalysis>();
                IPluginModelBase model = PluginRegistry.findModel((String)this.bundleID);
                BundleDescription desc = model.getBundleDescription();
                IProject project = model.getUnderlyingResource() == null ? null : model.getUnderlyingResource().getProject();
                BundleAnalysis self = this.getBundle();
                if (desc == null) {
                    this.exports = Collections.emptySet();
                    this.compatibleVersionRange = VersionRange.valueOf((String)"0.0.0");
                } else {
                    this.compatibleVersionRange = DependencyAnalysisContext.this.versionRules.getDependencyVersionRange(DependencyKind.REQUIRE_BUNDLE, this.bundleID);
                    if (project == null || !DependencyAnalysisContext.this.isAnalysisRoot(this.bundleID)) {
                        this.exports = Stream.of(desc.getExportPackages()).filter(this::isPublicExport).map(BaseDescription::getName).collect(Collectors.toSet());
                    } else {
                        Map<String, ? extends Set<String>> uses = new MyCalculateUsesOperation(project, model).calculate();
                        DependencyAnalysisContext.this.currentMonitor.setTaskName("Computing re-exported dependencies...");
                        this.exports = new HashSet<String>(uses.keySet());
                        Set allUsedPackages = uses.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toSet());
                        allUsedPackages.removeAll(this.exports);
                        for (String next : allUsedPackages) {
                            BundleAnalysis provider = DependencyAnalysisContext.this.getProvidingBundle(next);
                            if (provider == null || provider == self || this.exposedDependencies.containsKey(provider.getBundleID())) continue;
                            this.exposedDependencies.put(provider.getBundleID(), provider);
                        }
                    }
                }
                this.exports.forEach(x -> {
                    BundleAnalysis bundleAnalysis2 = DependencyAnalysisContext.this.packageProviders.put((String)x, self);
                });
            }
            return this;
        }

        private boolean isPublicExport(ExportPackageDescription exportPackage) {
            Map directives = exportPackage.getDeclaredDirectives();
            return !"true".equals(directives.get("x-internal")) && !directives.containsKey("x-friends");
        }

        private boolean isReexportedByExposedDependency(BundleAnalysis bundle) {
            return this.exposedDependencies.values().stream().anyMatch(dep -> dep.isReexported(bundle.getBundleID()));
        }

        public String toString() {
            return "API of " + this.bundleID;
        }

        private final class MyCalculateUsesOperation
        extends CalculateUsesOperation {
            MyCalculateUsesOperation(IProject project, IPluginModelBase model) {
                super(project, (IBundlePluginModelBase)model);
            }

            Map<String, ? extends Set<String>> calculate() {
                Collection packages = this.getPublicExportedPackages();
                Map result = packages.isEmpty() ? Collections.emptyMap() : this.findPackageReferences(packages, (IProgressMonitor)((APIExports)APIExports.this).DependencyAnalysisContext.this.currentMonitor.split(1));
                return result;
            }
        }
    }

    public class BundleAnalysis {
        private final String bundleID;
        private DependencyGraph dependencyGraph;
        private APIExports apiExports;

        private BundleAnalysis(String bundleID) {
            this.bundleID = bundleID;
        }

        public String getBundleID() {
            return this.bundleID;
        }

        public BundleAnalysis checkCycle() throws IllegalStateException {
            this.getDependencyGraph().checkCycle();
            return this;
        }

        public VersionRange getCompatibleVersionRange() {
            return this.getAPIExports().getCompatibleVersionRange();
        }

        public DependencyGraph getDependencyGraph() {
            this.analyze();
            return this.dependencyGraph;
        }

        public APIExports getAPIExports() {
            this.analyze();
            return this.apiExports;
        }

        public BundleAnalysis getDependency(String bundleID) {
            return this.getDependencyGraph().getDependency(bundleID);
        }

        public boolean isReexported(String bundleID) {
            return this.getDependencyGraph().isReexported(bundleID);
        }

        public boolean hasDependency(String bundleID) {
            return this.getDependencyGraph().hasDependency(bundleID);
        }

        public boolean hasDependency(String bundleID, boolean recursive) {
            return this.getDependencyGraph().hasDependency(bundleID, recursive);
        }

        public Set<BundleAnalysis> getMissingReexports() {
            return this.getAPIExports().getMissingReexports();
        }

        private BundleAnalysis analyze() {
            if (this.dependencyGraph == null) {
                this.dependencyGraph = new DependencyGraph(this.bundleID);
            }
            if (this.apiExports == null) {
                this.apiExports = new APIExports(this.bundleID);
            }
            return this;
        }

        public String toReexportDeclaration() {
            return String.format("%s;bundle-version=\"%s\";visibility:=reexport", this.getBundleID(), this.getCompatibleVersionRange());
        }

        public IFile getManifest() {
            IResource resource;
            IFile result = null;
            IPluginModelBase model = PluginRegistry.findModel((String)this.getBundleID());
            IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        if (!"MANIFEST.MF".equals(resource.getName())) break;
                        result = (IFile)resource;
                        break;
                    }
                    case 4: {
                        IFile manifest = ((IProject)resource).getFile("META-INF/MANIFEST.MF");
                        if (manifest == null || !manifest.isAccessible()) break;
                        result = manifest;
                    }
                }
            }
            return result;
        }

        public boolean isAnalysisRoot() {
            return DependencyAnalysisContext.this.isAnalysisRoot(this.getBundleID());
        }

        public int partialCompare(BundleAnalysis o) {
            int result = o == this ? 0 : (this.hasDependency(o.getBundleID(), true) ? 1 : (o.hasDependency(this.getBundleID(), true) ? -1 : 0));
            return result;
        }

        public String toString() {
            return "Analysis of " + this.bundleID;
        }

        public final void pushMonitor(IProgressMonitor monitor) {
            DependencyAnalysisContext.this.pushMonitor(monitor);
        }

        public final void popMonitor() {
            DependencyAnalysisContext.this.popMonitor();
        }
    }

    public class DependencyGraph {
        private final String bundleID;
        private final Map<String, BundleAnalysis> dependencies = new HashMap<String, BundleAnalysis>();
        private final Map<String, BundleAnalysis> reexports = new HashMap<String, BundleAnalysis>();
        private Set<BundleAnalysis> cycle;
        private Set<String> transitiveDependencies;

        private DependencyGraph(String bundleID) {
            this.bundleID = bundleID;
            IPluginModelBase model = PluginRegistry.findModel((String)bundleID);
            if (model == null) {
                throw new IllegalArgumentException("No such bundle: " + bundleID);
            }
            BundleDescription desc = model.getBundleDescription();
            if (desc != null) {
                BundleSpecification[] bundleSpecificationArray = desc.getRequiredBundles();
                int n = bundleSpecificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleSpecification next = bundleSpecificationArray[n2];
                    if (next.isResolved() && !next.isOptional() && !bundleID.equals(next.getName())) {
                        BundleAnalysis dep = DependencyAnalysisContext.this.internalGetBundle(next.getSupplier().getName());
                        this.dependencies.put(dep.getBundleID(), dep);
                        if (next.isExported()) {
                            this.reexports.put(dep.getBundleID(), dep);
                        }
                    }
                    ++n2;
                }
            }
        }

        public BundleAnalysis getBundle() {
            return DependencyAnalysisContext.this.internalGetBundle(this.bundleID);
        }

        public BundleAnalysis getDependency(String bundleID) {
            BundleAnalysis result = this.dependencies.get(bundleID);
            if (result == null) {
                result = this.dependencies.values().stream().map(bundle -> bundle.getDependency(bundleID)).filter(Objects::nonNull).findAny().orElse(null);
            }
            return result;
        }

        public boolean isReexported(String bundleID) {
            boolean result;
            boolean bl = result = this.bundleID.equals(bundleID) || this.reexports.containsKey(bundleID);
            if (!result) {
                result = this.reexports.values().stream().anyMatch(bundle -> bundle.isReexported(bundleID));
            }
            return result;
        }

        public boolean hasDependency(String bundleID) {
            return this.dependencies.containsKey(bundleID);
        }

        public boolean hasDependency(String bundleID, boolean recursive) {
            boolean result = this.hasDependency(bundleID);
            if (!result && recursive) {
                result = this.transitiveDependencies.contains(bundleID);
            }
            return result;
        }

        public boolean isRedundant(String bundleID) {
            boolean result = this.isReexported(bundleID) ? Stream.concat(this.reexports.values().stream(), this.getBundle().getMissingReexports().stream()).filter(bundle -> !bundleID.equals(bundle.getBundleID())).anyMatch(bundle -> bundle.isReexported(bundleID)) : this.dependencies.values().stream().filter(bundle -> !bundle.getBundleID().equals(bundleID)).anyMatch(bundle -> bundle.isReexported(bundleID));
            return result;
        }

        public void checkCycle() throws IllegalStateException {
            if (this.cycle == null) {
                this.cycle = this.computeCycle(new LinkedHashSet<BundleAnalysis>());
            }
            if (!this.cycle.isEmpty()) {
                List list = this.cycle.stream().map(BundleAnalysis::getBundleID).collect(Collectors.toList());
                list.add(this.cycle.iterator().next().getBundleID());
                throw new IllegalStateException("Dependency cycle detected: " + list);
            }
        }

        private Set<BundleAnalysis> computeCycle(LinkedHashSet<BundleAnalysis> trace) {
            if (this.cycle != null) {
                return this.cycle;
            }
            BundleAnalysis self = this.getBundle();
            if (!trace.add(self)) {
                Iterator iter = trace.iterator();
                while (iter.hasNext()) {
                    if (iter.next() == self) break;
                    iter.remove();
                }
                this.cycle = trace;
            } else {
                this.transitiveDependencies = new HashSet<String>();
                for (BundleAnalysis next : this.dependencies.values()) {
                    DependencyGraph child = next.getDependencyGraph();
                    this.cycle = child.computeCycle(trace);
                    if (!this.cycle.isEmpty()) break;
                    this.transitiveDependencies.addAll(child.dependencies.keySet());
                    this.transitiveDependencies.addAll(child.transitiveDependencies);
                }
                if (this.cycle == null || this.cycle.isEmpty()) {
                    this.transitiveDependencies.removeAll(this.dependencies.keySet());
                    trace.remove(self);
                    this.cycle = Collections.emptySet();
                }
            }
            return this.cycle;
        }

        public void removeDependency(String bundleID) {
            this.dependencies.remove(bundleID);
            this.transitiveDependencies.add(bundleID);
            this.reexports.remove(bundleID);
        }

        public void reexport(String bundleID) {
            this.reexports.put(bundleID, DependencyAnalysisContext.this.internalGetBundle(bundleID));
            this.getBundle().getAPIExports().recomputeMissingReexports();
        }

        public String toString() {
            return "Dependencies of " + this.bundleID;
        }
    }
}

