/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class MonitorUtils {
    public static void begin(IProgressMonitor monitor, int ticks) {
        MonitorUtils.begin(monitor, null, ticks);
    }

    public static void begin(IProgressMonitor monitor, String taskName, int ticks) {
        if (monitor != null && !monitor.isCanceled()) {
            monitor.beginTask(taskName, ticks);
        }
    }

    public static void complete(IProgressMonitor monitor) {
        if (monitor != null) {
            try {
                if (!monitor.isCanceled()) {
                    monitor.beginTask(null, 1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    public static IProgressMonitor ensureNotNull(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null && !monitor.isCanceled()) {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        }
        return monitor;
    }

    public static void subTask(IProgressMonitor monitor, String name) {
        if (monitor != null && !monitor.isCanceled()) {
            monitor.subTask(name);
        }
    }

    public static void testCancelStatus(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void worked(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.testCancelStatus(monitor);
            monitor.worked(work);
        }
    }
}

