/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class ArchitecturePluginXMLValidator {
    static final String CATEGORY = "architecture";
    static final String MODEL = "model";
    static final String PATH = "path";
    private final IFile modelFile;

    ArchitecturePluginXMLValidator(IFile modelFile) {
        this.modelFile = modelFile;
    }

    Optional<Element> matchExtension(Element element, String point, ArchitectureDomain architectureModel) {
        switch (point) {
            case "org.eclipse.papyrus.infra.architecture.models": {
                NodeList children = element.getElementsByTagName(MODEL);
                int i = 0;
                while (i < children.getLength()) {
                    Element model = (Element)children.item(i);
                    if (this.matchArchitectureDomain(model, architectureModel)) {
                        return Optional.of(model);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    boolean matchArchitectureDomain(Element element, ArchitectureDomain model) {
        String path = element.getAttribute(PATH);
        return Objects.equals(path, this.modelFile.getProjectRelativePath().toString());
    }

    int problemID(String point, ArchitectureDomain architectureDomain) {
        switch (point) {
            case "org.eclipse.papyrus.infra.architecture.models": {
                return 16715840;
            }
        }
        return -1;
    }
}

